/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Map;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public abstract class Behavior<E extends EntityLiving>
implements BehaviorControl<E> {
    public static final int DEFAULT_DURATION = 60;
    protected final Map<MemoryModuleType<?>, MemoryStatus> entryCondition;
    private Status status = Status.STOPPED;
    private long endTimestamp;
    private final int minDuration;
    private final int maxDuration;

    public Behavior(Map<MemoryModuleType<?>, MemoryStatus> var0) {
        this(var0, 60);
    }

    public Behavior(Map<MemoryModuleType<?>, MemoryStatus> var0, int var1) {
        this(var0, var1, var1);
    }

    public Behavior(Map<MemoryModuleType<?>, MemoryStatus> var0, int var1, int var2) {
        this.minDuration = var1;
        this.maxDuration = var2;
        this.entryCondition = var0;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public final boolean tryStart(WorldServer var0, E var1, long var2) {
        if (this.hasRequiredMemories(var1) && this.checkExtraStartConditions(var0, var1)) {
            this.status = Status.RUNNING;
            int var4 = this.minDuration + var0.getRandom().nextInt(this.maxDuration + 1 - this.minDuration);
            this.endTimestamp = var2 + (long)var4;
            this.start(var0, var1, var2);
            return true;
        }
        return false;
    }

    protected void start(WorldServer var0, E var1, long var2) {
    }

    @Override
    public final void tickOrStop(WorldServer var0, E var1, long var2) {
        if (!this.timedOut(var2) && this.canStillUse(var0, var1, var2)) {
            this.tick(var0, var1, var2);
        } else {
            this.doStop(var0, var1, var2);
        }
    }

    protected void tick(WorldServer var0, E var1, long var2) {
    }

    @Override
    public final void doStop(WorldServer var0, E var1, long var2) {
        this.status = Status.STOPPED;
        this.stop(var0, var1, var2);
    }

    protected void stop(WorldServer var0, E var1, long var2) {
    }

    protected boolean canStillUse(WorldServer var0, E var1, long var2) {
        return false;
    }

    protected boolean timedOut(long var0) {
        return var0 > this.endTimestamp;
    }

    protected boolean checkExtraStartConditions(WorldServer var0, E var1) {
        return true;
    }

    @Override
    public String debugString() {
        return this.getClass().getSimpleName();
    }

    protected boolean hasRequiredMemories(E var0) {
        for (Map.Entry<MemoryModuleType<?>, MemoryStatus> var2 : this.entryCondition.entrySet()) {
            MemoryModuleType<?> var3 = var2.getKey();
            MemoryStatus var4 = var2.getValue();
            if (((EntityLiving)var0).getBrain().checkMemory(var3, var4)) continue;
            return false;
        }
        return true;
    }

    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status STOPPED = new Status();
        public static final /* enum */ Status RUNNING = new Status();
        private static final /* synthetic */ Status[] c;

        public static Status[] values() {
            return (Status[])c.clone();
        }

        public static Status valueOf(String var0) {
            return Enum.valueOf(Status.class, var0);
        }

        private static /* synthetic */ Status[] a() {
            return new Status[]{STOPPED, RUNNING};
        }

        static {
            c = Status.a();
        }
    }
}

