/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.frog.Frog;

public class Croak
extends Behavior<Frog> {
    private static final int CROAK_TICKS = 60;
    private static final int TIME_OUT_DURATION = 100;
    private int croakCounter;

    public Croak() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)), 100);
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, Frog var1) {
        return var1.getPose() == EntityPose.STANDING;
    }

    @Override
    protected boolean canStillUse(WorldServer var0, Frog var1, long var2) {
        return this.croakCounter < 60;
    }

    @Override
    protected void start(WorldServer var0, Frog var1, long var2) {
        if (var1.isInLiquid()) {
            return;
        }
        var1.setPose(EntityPose.CROAKING);
        this.croakCounter = 0;
    }

    @Override
    protected void stop(WorldServer var0, Frog var1, long var2) {
        var1.setPose(EntityPose.STANDING);
    }

    @Override
    protected void tick(WorldServer var0, Frog var1, long var2) {
        ++this.croakCounter;
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (Frog)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void tick(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.tick(worldServer, (Frog)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (Frog)entityLiving, l2);
    }
}

