/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Map;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.item.component.KineticWeapon;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class SpearAttack
extends Behavior<EntityCreature> {
    public static final int MIN_REPOSITION_DISTANCE = 6;
    public static final int MAX_REPOSITION_DISTANCE = 7;
    double speedModifierWhenCharging;
    double speedModifierWhenRepositioning;
    float approachDistanceSq;
    float targetInRangeRadiusSq;

    public SpearAttack(double var0, double var2, float var4, float var5) {
        super(Map.of(MemoryModuleType.SPEAR_STATUS, MemoryStatus.VALUE_PRESENT));
        this.speedModifierWhenCharging = var0;
        this.speedModifierWhenRepositioning = var2;
        this.approachDistanceSq = var4 * var4;
        this.targetInRangeRadiusSq = var5 * var5;
    }

    private @Nullable EntityLiving getTarget(EntityCreature var0) {
        return var0.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    private boolean ableToAttack(EntityCreature var0) {
        return this.getTarget(var0) != null && var0.getMainHandItem().has(DataComponents.KINETIC_WEAPON);
    }

    private int getKineticWeaponUseDuration(EntityCreature var0) {
        return Optional.ofNullable(var0.getMainHandItem().get(DataComponents.KINETIC_WEAPON)).map(KineticWeapon::computeDamageUseDuration).orElse(0);
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityCreature var1) {
        return var1.getBrain().getMemory(MemoryModuleType.SPEAR_STATUS).orElse(a.APPROACH) == a.CHARGING && this.ableToAttack(var1) && !var1.isUsingItem();
    }

    @Override
    protected void start(WorldServer var0, EntityCreature var1, long var2) {
        var1.setAggressive(true);
        var1.getBrain().setMemory(MemoryModuleType.SPEAR_ENGAGE_TIME, this.getKineticWeaponUseDuration(var1));
        var1.getBrain().eraseMemory(MemoryModuleType.SPEAR_CHARGE_POSITION);
        var1.startUsingItem(EnumHand.MAIN_HAND);
        super.start(var0, var1, var2);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityCreature var1, long var2) {
        return var1.getBrain().getMemory(MemoryModuleType.SPEAR_ENGAGE_TIME).orElse(0) > 0 && this.ableToAttack(var1);
    }

    @Override
    protected void tick(WorldServer var0, EntityCreature var1, long var2) {
        EntityLiving var4 = this.getTarget(var1);
        double var5 = var1.distanceToSqr(var4.getX(), var4.getY(), var4.getZ());
        Entity var7 = var1.getRootVehicle();
        float var8 = 1.0f;
        if (var7 instanceof EntityInsentient) {
            EntityInsentient var9 = (EntityInsentient)var7;
            var8 = var9.chargeSpeedModifier();
        }
        int var9 = var1.isPassenger() ? 2 : 0;
        var1.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorPositionEntity(var4, true));
        var1.getBrain().setMemory(MemoryModuleType.SPEAR_ENGAGE_TIME, var1.getBrain().getMemory(MemoryModuleType.SPEAR_ENGAGE_TIME).orElse(0) - 1);
        Vec3D var10 = var1.getBrain().getMemory(MemoryModuleType.SPEAR_CHARGE_POSITION).orElse(null);
        if (var10 != null) {
            var1.getNavigation().moveTo(var10.x, var10.y, var10.z, (double)var8 * this.speedModifierWhenRepositioning);
            if (var1.getNavigation().isDone()) {
                var1.getBrain().eraseMemory(MemoryModuleType.SPEAR_CHARGE_POSITION);
            }
        } else {
            var1.getNavigation().moveTo(var4, (double)var8 * this.speedModifierWhenCharging);
            if (var5 < (double)this.targetInRangeRadiusSq || var1.getNavigation().isDone()) {
                double var11 = Math.sqrt(var5);
                Vec3D var13 = LandRandomPos.getPosAway(var1, (double)(6 + var9) - var11, (double)(7 + var9) - var11, 7, var4.position());
                var1.getBrain().setMemory(MemoryModuleType.SPEAR_CHARGE_POSITION, var13);
            }
        }
    }

    @Override
    protected void stop(WorldServer var0, EntityCreature var1, long var2) {
        var1.getNavigation().stop();
        var1.stopUsingItem();
        var1.getBrain().eraseMemory(MemoryModuleType.SPEAR_CHARGE_POSITION);
        var1.getBrain().eraseMemory(MemoryModuleType.SPEAR_ENGAGE_TIME);
        var1.getBrain().setMemory(MemoryModuleType.SPEAR_STATUS, a.RETREAT);
    }

    @Override
    protected boolean timedOut(long var0) {
        return false;
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (EntityCreature)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (EntityCreature)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityCreature)entityLiving, l2);
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a APPROACH = new a();
        public static final /* enum */ a CHARGING = new a();
        public static final /* enum */ a RETREAT = new a();
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{APPROACH, CHARGING, RETREAT};
        }

        static {
            d = a.a();
        }
    }
}

