/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.control;

import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.control.ControllerLook;

public class SmoothSwimmingLookControl
extends ControllerLook {
    private final int maxYRotFromCenter;
    private static final int HEAD_TILT_X = 10;
    private static final int HEAD_TILT_Y = 20;

    public SmoothSwimmingLookControl(EntityInsentient var0, int var1) {
        super(var0);
        this.maxYRotFromCenter = var1;
    }

    @Override
    public void tick() {
        if (this.lookAtCooldown > 0) {
            --this.lookAtCooldown;
            this.getYRotD().ifPresent(var0 -> {
                this.mob.yHeadRot = this.rotateTowards(this.mob.yHeadRot, var0.floatValue() + 20.0f, this.yMaxRotSpeed);
            });
            this.getXRotD().ifPresent(var0 -> this.mob.setXRot(this.rotateTowards(this.mob.getXRot(), var0.floatValue() + 10.0f, this.xMaxRotAngle)));
        } else {
            if (this.mob.getNavigation().isDone()) {
                this.mob.setXRot(this.rotateTowards(this.mob.getXRot(), 0.0f, 5.0f));
            }
            this.mob.yHeadRot = this.rotateTowards(this.mob.yHeadRot, this.mob.yBodyRot, this.yMaxRotSpeed);
        }
        float var02 = MathHelper.wrapDegrees(this.mob.yHeadRot - this.mob.yBodyRot);
        if (var02 < (float)(-this.maxYRotFromCenter)) {
            this.mob.yBodyRot -= 4.0f;
        } else if (var02 > (float)this.maxYRotFromCenter) {
            this.mob.yBodyRot += 4.0f;
        }
    }
}

