/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jspecify.annotations.Nullable;

public class PathfinderGoalBeg
extends PathfinderGoal {
    private final EntityWolf wolf;
    private @Nullable EntityHuman player;
    private final WorldServer level;
    private final float lookDistance;
    private int lookTime;
    private final PathfinderTargetCondition begTargeting;

    public PathfinderGoalBeg(EntityWolf var0, float var1) {
        this.wolf = var0;
        this.level = PathfinderGoalBeg.getServerLevel(var0);
        this.lookDistance = var1;
        this.begTargeting = PathfinderTargetCondition.forNonCombat().range(var1);
        this.setFlags(EnumSet.of(PathfinderGoal.Type.LOOK));
    }

    @Override
    public boolean canUse() {
        this.player = this.level.getNearestPlayer(this.begTargeting, this.wolf);
        if (this.player == null) {
            return false;
        }
        return this.playerHoldingInteresting(this.player);
    }

    @Override
    public boolean canContinueToUse() {
        if (!this.player.isAlive()) {
            return false;
        }
        if (this.wolf.distanceToSqr(this.player) > (double)(this.lookDistance * this.lookDistance)) {
            return false;
        }
        return this.lookTime > 0 && this.playerHoldingInteresting(this.player);
    }

    @Override
    public void start() {
        this.wolf.setIsInterested(true);
        this.lookTime = this.adjustedTickDelay(40 + this.wolf.getRandom().nextInt(40));
    }

    @Override
    public void stop() {
        this.wolf.setIsInterested(false);
        this.player = null;
    }

    @Override
    public void tick() {
        this.wolf.getLookControl().setLookAt(this.player.getX(), this.player.getEyeY(), this.player.getZ(), 10.0f, this.wolf.getMaxHeadXRot());
        --this.lookTime;
    }

    private boolean playerHoldingInteresting(EntityHuman var0) {
        for (EnumHand var4 : EnumHand.values()) {
            ItemStack var5 = var0.getItemInHand(var4);
            if (!var5.is(Items.BONE) && !this.wolf.isFood(var5)) continue;
            return true;
        }
        return false;
    }
}

