/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import com.mojang.datafixers.DataFixUtils;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.animal.fish.EntityFishSchool;

public class PathfinderGoalFishSchool
extends PathfinderGoal {
    private static final int INTERVAL_TICKS = 200;
    private final EntityFishSchool mob;
    private int timeToRecalcPath;
    private int nextStartTick;

    public PathfinderGoalFishSchool(EntityFishSchool var0) {
        this.mob = var0;
        this.nextStartTick = this.nextStartTick(var0);
    }

    protected int nextStartTick(EntityFishSchool var0) {
        return PathfinderGoalFishSchool.reducedTickDelay(200 + var0.getRandom().nextInt(200) % 20);
    }

    @Override
    public boolean canUse() {
        if (this.mob.hasFollowers()) {
            return false;
        }
        if (this.mob.isFollower()) {
            return true;
        }
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        this.nextStartTick = this.nextStartTick(this.mob);
        Predicate<EntityFishSchool> var02 = var0 -> var0.canBeFollowed() || !var0.isFollower();
        List<EntityFishSchool> var1 = this.mob.level().getEntitiesOfClass(this.mob.getClass(), this.mob.getBoundingBox().inflate(8.0, 8.0, 8.0), var02);
        EntityFishSchool var2 = (EntityFishSchool)DataFixUtils.orElse(var1.stream().filter(EntityFishSchool::canBeFollowed).findAny(), (Object)this.mob);
        var2.addFollowers(var1.stream().filter(var0 -> !var0.isFollower()));
        return this.mob.isFollower();
    }

    @Override
    public boolean canContinueToUse() {
        return this.mob.isFollower() && this.mob.inRangeOfLeader();
    }

    @Override
    public void start() {
        this.timeToRecalcPath = 0;
    }

    @Override
    public void stop() {
        this.mob.stopFollowing();
    }

    @Override
    public void tick() {
        if (--this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = this.adjustedTickDelay(10);
        this.mob.pathToLeader();
    }
}

