/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal.target;

import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.scores.ScoreboardTeam;
import org.jspecify.annotations.Nullable;

public abstract class PathfinderGoalTarget
extends PathfinderGoal {
    private static final int EMPTY_REACH_CACHE = 0;
    private static final int CAN_REACH_CACHE = 1;
    private static final int CANT_REACH_CACHE = 2;
    protected final EntityInsentient mob;
    protected final boolean mustSee;
    private final boolean mustReach;
    private int reachCache;
    private int reachCacheTime;
    private int unseenTicks;
    protected @Nullable EntityLiving targetMob;
    protected int unseenMemoryTicks = 60;

    public PathfinderGoalTarget(EntityInsentient var0, boolean var1) {
        this(var0, var1, false);
    }

    public PathfinderGoalTarget(EntityInsentient var0, boolean var1, boolean var2) {
        this.mob = var0;
        this.mustSee = var1;
        this.mustReach = var2;
    }

    @Override
    public boolean canContinueToUse() {
        EntityLiving var0 = this.mob.getTarget();
        if (var0 == null) {
            var0 = this.targetMob;
        }
        if (var0 == null) {
            return false;
        }
        if (!this.mob.canAttack(var0)) {
            return false;
        }
        ScoreboardTeam var1 = this.mob.getTeam();
        ScoreboardTeam var2 = var0.getTeam();
        if (var1 != null && var2 == var1) {
            return false;
        }
        double var3 = this.getFollowDistance();
        if (this.mob.distanceToSqr(var0) > var3 * var3) {
            return false;
        }
        if (this.mustSee) {
            if (this.mob.getSensing().hasLineOfSight(var0)) {
                this.unseenTicks = 0;
            } else if (++this.unseenTicks > PathfinderGoalTarget.reducedTickDelay(this.unseenMemoryTicks)) {
                return false;
            }
        }
        this.mob.setTarget(var0);
        return true;
    }

    protected double getFollowDistance() {
        return this.mob.getAttributeValue(GenericAttributes.FOLLOW_RANGE);
    }

    @Override
    public void start() {
        this.reachCache = 0;
        this.reachCacheTime = 0;
        this.unseenTicks = 0;
    }

    @Override
    public void stop() {
        this.mob.setTarget(null);
        this.targetMob = null;
    }

    protected boolean canAttack(@Nullable EntityLiving var0, PathfinderTargetCondition var1) {
        if (var0 == null) {
            return false;
        }
        if (!var1.test(PathfinderGoalTarget.getServerLevel(this.mob), this.mob, var0)) {
            return false;
        }
        if (!this.mob.isWithinHome(var0.blockPosition())) {
            return false;
        }
        if (this.mustReach) {
            if (--this.reachCacheTime <= 0) {
                this.reachCache = 0;
            }
            if (this.reachCache == 0) {
                int n2 = this.reachCache = this.canReach(var0) ? 1 : 2;
            }
            if (this.reachCache == 2) {
                return false;
            }
        }
        return true;
    }

    private boolean canReach(EntityLiving var0) {
        int var4;
        this.reachCacheTime = PathfinderGoalTarget.reducedTickDelay(10 + this.mob.getRandom().nextInt(5));
        PathEntity var1 = this.mob.getNavigation().createPath(var0, 0);
        if (var1 == null) {
            return false;
        }
        PathPoint var2 = var1.getEndNode();
        if (var2 == null) {
            return false;
        }
        int var3 = var2.x - var0.getBlockX();
        return (double)(var3 * var3 + (var4 = var2.z - var0.getBlockZ()) * var4) <= 2.25;
    }

    public PathfinderGoalTarget setUnseenMemoryTicks(int var0) {
        this.unseenMemoryTicks = var0;
        return this;
    }
}

