/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorNearestLivingEntities;
import net.minecraft.world.entity.monster.breeze.Breeze;

public class BreezeAttackEntitySensor
extends SensorNearestLivingEntities<Breeze> {
    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.copyOf((Iterable)Iterables.concat(super.requires(), List.of(MemoryModuleType.NEAREST_ATTACKABLE)));
    }

    @Override
    protected void doTick(WorldServer var0, Breeze var12) {
        super.doTick(var0, var12);
        var12.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).stream().flatMap(Collection::stream).filter(IEntitySelector.NO_CREATIVE_OR_SPECTATOR).filter(var2 -> Sensor.isEntityAttackable(var0, var12, var2)).findFirst().ifPresentOrElse(var1 -> var12.getBrain().setMemory(MemoryModuleType.NEAREST_ATTACKABLE, var1), () -> var12.getBrain().eraseMemory(MemoryModuleType.NEAREST_ATTACKABLE));
    }
}

