/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;

public abstract class AgeableWaterCreature
extends EntityAgeable {
    protected AgeableWaterCreature(EntityTypes<? extends AgeableWaterCreature> var0, World var1) {
        super((EntityTypes<? extends EntityAgeable>)var0, var1);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    @Override
    public boolean checkSpawnObstruction(IWorldReader var0) {
        return var0.isUnobstructed(this);
    }

    @Override
    public int getAmbientSoundInterval() {
        return 120;
    }

    @Override
    public int getBaseExperienceReward(WorldServer var0) {
        return 1 + this.random.nextInt(3);
    }

    protected void handleAirSupply(int var0) {
        if (this.isAlive() && !this.isInWater()) {
            this.setAirSupply(var0 - 1);
            if (this.shouldTakeDrowningDamage()) {
                this.setAirSupply(0);
                this.hurt(this.damageSources().drown(), 2.0f);
            }
        } else {
            this.setAirSupply(300);
        }
    }

    @Override
    public void baseTick() {
        int var0 = this.getAirSupply();
        super.baseTick();
        this.handleAirSupply(var0);
    }

    @Override
    public boolean isPushedByFluid() {
        return false;
    }

    @Override
    public boolean canBeLeashed() {
        return false;
    }

    public static boolean checkSurfaceAgeableWaterCreatureSpawnRules(EntityTypes<? extends AgeableWaterCreature> var0, GeneratorAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        int var5 = var1.getSeaLevel();
        int var6 = var5 - 13;
        return var3.getY() >= var6 && var3.getY() <= var5 && var1.getFluidState(var3.below()).is(TagsFluid.WATER) && var1.getBlockState(var3.above()).is(Blocks.WATER);
    }
}

