/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.bee;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TimeRange;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.debug.DebugBeeInfo;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockFlowers;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class EntityBee
extends EntityAnimal
implements IEntityAngerable,
EntityBird {
    public static final float FLAP_DEGREES_PER_TICK = 120.32113f;
    public static final int TICKS_PER_FLAP = MathHelper.ceil(1.4959966f);
    private static final DataWatcherObject<Byte> DATA_FLAGS_ID = DataWatcher.defineId(EntityBee.class, DataWatcherRegistry.BYTE);
    private static final DataWatcherObject<Long> DATA_ANGER_END_TIME = DataWatcher.defineId(EntityBee.class, DataWatcherRegistry.LONG);
    private static final int FLAG_ROLL = 2;
    private static final int FLAG_HAS_STUNG = 4;
    private static final int FLAG_HAS_NECTAR = 8;
    private static final int STING_DEATH_COUNTDOWN = 1200;
    private static final int TICKS_BEFORE_GOING_TO_KNOWN_FLOWER = 600;
    private static final int TICKS_WITHOUT_NECTAR_BEFORE_GOING_HOME = 3600;
    private static final int MIN_ATTACK_DIST = 4;
    private static final int MAX_CROPS_GROWABLE = 10;
    private static final int POISON_SECONDS_NORMAL = 10;
    private static final int POISON_SECONDS_HARD = 18;
    private static final int TOO_FAR_DISTANCE = 48;
    private static final int HIVE_CLOSE_ENOUGH_DISTANCE = 2;
    private static final int RESTRICTED_WANDER_DISTANCE_REDUCTION = 24;
    private static final int DEFAULT_WANDER_DISTANCE_REDUCTION = 16;
    private static final int PATHFIND_TO_HIVE_WHEN_CLOSER_THAN = 16;
    private static final int HIVE_SEARCH_DISTANCE = 20;
    public static final String TAG_CROPS_GROWN_SINCE_POLLINATION = "CropsGrownSincePollination";
    public static final String TAG_CANNOT_ENTER_HIVE_TICKS = "CannotEnterHiveTicks";
    public static final String TAG_TICKS_SINCE_POLLINATION = "TicksSincePollination";
    public static final String TAG_HAS_STUNG = "HasStung";
    public static final String TAG_HAS_NECTAR = "HasNectar";
    public static final String TAG_FLOWER_POS = "flower_pos";
    public static final String TAG_HIVE_POS = "hive_pos";
    public static final boolean DEFAULT_HAS_NECTAR = false;
    private static final boolean DEFAULT_HAS_STUNG = false;
    private static final int DEFAULT_TICKS_SINCE_POLLINATION = 0;
    private static final int DEFAULT_CANNOT_ENTER_HIVE_TICKS = 0;
    private static final int DEFAULT_CROPS_GROWN_SINCE_POLLINATION = 0;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeRange.rangeOfSeconds(20, 39);
    private @Nullable EntityReference<EntityLiving> persistentAngerTarget;
    private float rollAmount;
    private float rollAmountO;
    private int timeSinceSting;
    int ticksWithoutNectarSinceExitingHive = 0;
    public int stayOutOfHiveCountdown = 0;
    private int numCropsGrownSincePollination = 0;
    private static final int COOLDOWN_BEFORE_LOCATING_NEW_HIVE = 200;
    int remainingCooldownBeforeLocatingNewHive;
    private static final int COOLDOWN_BEFORE_LOCATING_NEW_FLOWER = 200;
    private static final int MIN_FIND_FLOWER_RETRY_COOLDOWN = 20;
    private static final int MAX_FIND_FLOWER_RETRY_COOLDOWN = 60;
    int remainingCooldownBeforeLocatingNewFlower = MathHelper.nextInt(this.random, 20, 60);
    @Nullable BlockPosition savedFlowerPos;
    public @Nullable BlockPosition hivePos;
    k beePollinateGoal;
    e goToHiveGoal;
    private f goToKnownFlowerGoal;
    private int underWaterTicks;

    public EntityBee(EntityTypes<? extends EntityBee> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
        this.moveControl = new ControllerMoveFlying(this, 20, true);
        this.lookControl = new j(this);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_FLAGS_ID, (byte)0);
        var0.define(DATA_ANGER_END_TIME, -1L);
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        if (var1.getBlockState(var0).isAir()) {
            return 10.0f;
        }
        return 0.0f;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new b(this, 1.4f, true));
        this.goalSelector.addGoal(1, new d());
        this.goalSelector.addGoal(2, new PathfinderGoalBreed(this, 1.0));
        this.goalSelector.addGoal(3, new PathfinderGoalTempt(this, 1.25, var0 -> var0.is(TagsItem.BEE_FOOD), false));
        this.goalSelector.addGoal(3, new n());
        this.goalSelector.addGoal(3, new m());
        this.beePollinateGoal = new k();
        this.goalSelector.addGoal(4, this.beePollinateGoal);
        this.goalSelector.addGoal(5, new PathfinderGoalFollowParent(this, 1.25));
        this.goalSelector.addGoal(5, new i());
        this.goToHiveGoal = new e();
        this.goalSelector.addGoal(5, this.goToHiveGoal);
        this.goToKnownFlowerGoal = new f();
        this.goalSelector.addGoal(6, this.goToKnownFlowerGoal);
        this.goalSelector.addGoal(7, new g());
        this.goalSelector.addGoal(8, new l());
        this.goalSelector.addGoal(9, new PathfinderGoalFloat(this));
        this.targetSelector.addGoal(1, new h(this).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, new c(this));
        this.targetSelector.addGoal(3, new PathfinderGoalUniversalAngerReset<EntityBee>(this, true));
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.storeNullable(TAG_HIVE_POS, BlockPosition.CODEC, this.hivePos);
        var0.storeNullable(TAG_FLOWER_POS, BlockPosition.CODEC, this.savedFlowerPos);
        var0.putBoolean(TAG_HAS_NECTAR, this.hasNectar());
        var0.putBoolean(TAG_HAS_STUNG, this.hasStung());
        var0.putInt(TAG_TICKS_SINCE_POLLINATION, this.ticksWithoutNectarSinceExitingHive);
        var0.putInt(TAG_CANNOT_ENTER_HIVE_TICKS, this.stayOutOfHiveCountdown);
        var0.putInt(TAG_CROPS_GROWN_SINCE_POLLINATION, this.numCropsGrownSincePollination);
        this.addPersistentAngerSaveData(var0);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.setHasNectar(var0.getBooleanOr(TAG_HAS_NECTAR, false));
        this.setHasStung(var0.getBooleanOr(TAG_HAS_STUNG, false));
        this.ticksWithoutNectarSinceExitingHive = var0.getIntOr(TAG_TICKS_SINCE_POLLINATION, 0);
        this.stayOutOfHiveCountdown = var0.getIntOr(TAG_CANNOT_ENTER_HIVE_TICKS, 0);
        this.numCropsGrownSincePollination = var0.getIntOr(TAG_CROPS_GROWN_SINCE_POLLINATION, 0);
        this.hivePos = var0.read(TAG_HIVE_POS, BlockPosition.CODEC).orElse(null);
        this.savedFlowerPos = var0.read(TAG_FLOWER_POS, BlockPosition.CODEC).orElse(null);
        this.readPersistentAngerSaveData(this.level(), var0);
    }

    @Override
    public boolean doHurtTarget(WorldServer var0, Entity var1) {
        DamageSource var2 = this.damageSources().sting(this);
        boolean var3 = var1.hurtServer(var0, var2, (int)this.getAttributeValue(GenericAttributes.ATTACK_DAMAGE));
        if (var3) {
            EnchantmentManager.doPostAttackEffects(var0, var1, var2);
            if (var1 instanceof EntityLiving) {
                EntityLiving var4 = (EntityLiving)var1;
                var4.setStingerCount(var4.getStingerCount() + 1);
                int var5 = 0;
                if (this.level().getDifficulty() == EnumDifficulty.NORMAL) {
                    var5 = 10;
                } else if (this.level().getDifficulty() == EnumDifficulty.HARD) {
                    var5 = 18;
                }
                if (var5 > 0) {
                    var4.addEffect(new MobEffect(MobEffects.POISON, var5 * 20, 0), this);
                }
            }
            this.setHasStung(true);
            this.stopBeingAngry();
            this.playSound(SoundEffects.BEE_STING, 1.0f, 1.0f);
        }
        return var3;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.hasNectar() && this.getCropsGrownSincePollination() < 10 && this.random.nextFloat() < 0.05f) {
            for (int var0 = 0; var0 < this.random.nextInt(2) + 1; ++var0) {
                this.spawnFluidParticle(this.level(), this.getX() - (double)0.3f, this.getX() + (double)0.3f, this.getZ() - (double)0.3f, this.getZ() + (double)0.3f, this.getY(0.5), Particles.FALLING_NECTAR);
            }
        }
        this.updateRollAmount();
    }

    private void spawnFluidParticle(World var0, double var1, double var3, double var5, double var7, double var9, ParticleParam var11) {
        var0.addParticle(var11, MathHelper.lerp(var0.random.nextDouble(), var1, var3), var9, MathHelper.lerp(var0.random.nextDouble(), var5, var7), 0.0, 0.0, 0.0);
    }

    void pathfindRandomlyTowards(BlockPosition var0) {
        Vec3D var8;
        Vec3D var1 = Vec3D.atBottomCenterOf(var0);
        int var2 = 0;
        BlockPosition var3 = this.blockPosition();
        int var4 = (int)var1.y - var3.getY();
        if (var4 > 2) {
            var2 = 4;
        } else if (var4 < -2) {
            var2 = -4;
        }
        int var5 = 6;
        int var6 = 8;
        int var7 = var3.distManhattan(var0);
        if (var7 < 15) {
            var5 = var7 / 2;
            var6 = var7 / 2;
        }
        if ((var8 = AirRandomPos.getPosTowards(this, var5, var6, var2, var1, 0.3141592741012573)) == null) {
            return;
        }
        this.navigation.setMaxVisitedNodesMultiplier(0.5f);
        this.navigation.moveTo(var8.x, var8.y, var8.z, 1.0);
    }

    public @Nullable BlockPosition getSavedFlowerPos() {
        return this.savedFlowerPos;
    }

    public boolean hasSavedFlowerPos() {
        return this.savedFlowerPos != null;
    }

    public void setSavedFlowerPos(BlockPosition var0) {
        this.savedFlowerPos = var0;
    }

    @VisibleForDebug
    public int getTravellingTicks() {
        return Math.max(this.goToHiveGoal.travellingTicks, this.goToKnownFlowerGoal.travellingTicks);
    }

    @VisibleForDebug
    public List<BlockPosition> getBlacklistedHives() {
        return this.goToHiveGoal.blacklistedTargets;
    }

    private boolean isTiredOfLookingForNectar() {
        return this.ticksWithoutNectarSinceExitingHive > 3600;
    }

    void dropHive() {
        this.hivePos = null;
        this.remainingCooldownBeforeLocatingNewHive = 200;
    }

    void dropFlower() {
        this.savedFlowerPos = null;
        this.remainingCooldownBeforeLocatingNewFlower = MathHelper.nextInt(this.random, 20, 60);
    }

    boolean wantsToEnterHive() {
        if (this.stayOutOfHiveCountdown > 0 || this.beePollinateGoal.isPollinating() || this.hasStung() || this.getTarget() != null) {
            return false;
        }
        boolean var0 = this.hasNectar() || this.isTiredOfLookingForNectar() || this.level().environmentAttributes().getValue(EnvironmentAttributes.BEES_STAY_IN_HIVE, this.position()) != false;
        return var0 && !this.isHiveNearFire();
    }

    public void setStayOutOfHiveCountdown(int var0) {
        this.stayOutOfHiveCountdown = var0;
    }

    public float getRollAmount(float var0) {
        return MathHelper.lerp(var0, this.rollAmountO, this.rollAmount);
    }

    private void updateRollAmount() {
        this.rollAmountO = this.rollAmount;
        this.rollAmount = this.isRolling() ? Math.min(1.0f, this.rollAmount + 0.2f) : Math.max(0.0f, this.rollAmount - 0.24f);
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        boolean var1 = this.hasStung();
        this.underWaterTicks = this.isInWater() ? ++this.underWaterTicks : 0;
        if (this.underWaterTicks > 20) {
            this.hurtServer(var0, this.damageSources().drown(), 1.0f);
        }
        if (var1) {
            ++this.timeSinceSting;
            if (this.timeSinceSting % 5 == 0 && this.random.nextInt(MathHelper.clamp(1200 - this.timeSinceSting, 1, 1200)) == 0) {
                this.hurtServer(var0, this.damageSources().generic(), this.getHealth());
            }
        }
        if (!this.hasNectar()) {
            ++this.ticksWithoutNectarSinceExitingHive;
        }
        this.updatePersistentAnger(var0, false);
    }

    public void resetTicksWithoutNectarSinceExitingHive() {
        this.ticksWithoutNectarSinceExitingHive = 0;
    }

    private boolean isHiveNearFire() {
        TileEntityBeehive var0 = this.getBeehiveBlockEntity();
        return var0 != null && var0.isFireNearby();
    }

    @Override
    public long getPersistentAngerEndTime() {
        return this.entityData.get(DATA_ANGER_END_TIME);
    }

    @Override
    public void setPersistentAngerEndTime(long var0) {
        this.entityData.set(DATA_ANGER_END_TIME, var0);
    }

    @Override
    public @Nullable EntityReference<EntityLiving> getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    @Override
    public void setPersistentAngerTarget(@Nullable EntityReference<EntityLiving> var0) {
        this.persistentAngerTarget = var0;
    }

    @Override
    public void startPersistentAngerTimer() {
        this.setTimeToRemainAngry(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    private boolean doesHiveHaveSpace(BlockPosition var0) {
        TileEntity var1 = this.level().getBlockEntity(var0);
        if (var1 instanceof TileEntityBeehive) {
            return !((TileEntityBeehive)var1).isFull();
        }
        return false;
    }

    @VisibleForDebug
    public boolean hasHive() {
        return this.hivePos != null;
    }

    @VisibleForDebug
    public @Nullable BlockPosition getHivePos() {
        return this.hivePos;
    }

    @VisibleForDebug
    public PathfinderGoalSelector getGoalSelector() {
        return this.goalSelector;
    }

    int getCropsGrownSincePollination() {
        return this.numCropsGrownSincePollination;
    }

    private void resetNumCropsGrownSincePollination() {
        this.numCropsGrownSincePollination = 0;
    }

    void incrementNumCropsGrownSincePollination() {
        ++this.numCropsGrownSincePollination;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide()) {
            if (this.stayOutOfHiveCountdown > 0) {
                --this.stayOutOfHiveCountdown;
            }
            if (this.remainingCooldownBeforeLocatingNewHive > 0) {
                --this.remainingCooldownBeforeLocatingNewHive;
            }
            if (this.remainingCooldownBeforeLocatingNewFlower > 0) {
                --this.remainingCooldownBeforeLocatingNewFlower;
            }
            boolean var0 = this.isAngry() && !this.hasStung() && this.getTarget() != null && this.getTarget().distanceToSqr(this) < 4.0;
            this.setRolling(var0);
            if (this.tickCount % 20 == 0 && !this.isHiveValid()) {
                this.hivePos = null;
            }
        }
    }

    @Nullable TileEntityBeehive getBeehiveBlockEntity() {
        if (this.hivePos == null) {
            return null;
        }
        if (this.isTooFarAway(this.hivePos)) {
            return null;
        }
        return this.level().getBlockEntity(this.hivePos, TileEntityTypes.BEEHIVE).orElse(null);
    }

    boolean isHiveValid() {
        return this.getBeehiveBlockEntity() != null;
    }

    public boolean hasNectar() {
        return this.getFlag(8);
    }

    public void setHasNectar(boolean var0) {
        if (var0) {
            this.resetTicksWithoutNectarSinceExitingHive();
        }
        this.setFlag(8, var0);
    }

    public boolean hasStung() {
        return this.getFlag(4);
    }

    public void setHasStung(boolean var0) {
        this.setFlag(4, var0);
    }

    private boolean isRolling() {
        return this.getFlag(2);
    }

    private void setRolling(boolean var0) {
        this.setFlag(2, var0);
    }

    boolean isTooFarAway(BlockPosition var0) {
        return !this.closerThan(var0, 48);
    }

    private void setFlag(int var0, boolean var1) {
        if (var1) {
            this.entityData.set(DATA_FLAGS_ID, (byte)(this.entityData.get(DATA_FLAGS_ID) | var0));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (byte)(this.entityData.get(DATA_FLAGS_ID) & ~var0));
        }
    }

    private boolean getFlag(int var0) {
        return (this.entityData.get(DATA_FLAGS_ID) & var0) != 0;
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityAnimal.createAnimalAttributes().add(GenericAttributes.MAX_HEALTH, 10.0).add(GenericAttributes.FLYING_SPEED, 0.6f).add(GenericAttributes.MOVEMENT_SPEED, 0.3f).add(GenericAttributes.ATTACK_DAMAGE, 2.0);
    }

    @Override
    protected NavigationAbstract createNavigation(World var0) {
        NavigationFlying var1 = new NavigationFlying(this, var0){

            @Override
            public boolean isStableDestination(BlockPosition var0) {
                return !this.level.getBlockState(var0.below()).isAir();
            }

            @Override
            public void tick() {
                if (EntityBee.this.beePollinateGoal.isPollinating()) {
                    return;
                }
                super.tick();
            }
        };
        var1.setCanOpenDoors(false);
        var1.setCanFloat(false);
        var1.setRequiredPathLength(48.0f);
        return var1;
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        BlockFlowers var4;
        MobEffect var5;
        ItemBlock var3;
        IMaterial iMaterial;
        ItemStack var2 = var0.getItemInHand(var1);
        if (this.isFood(var2) && (iMaterial = var2.getItem()) instanceof ItemBlock && (iMaterial = (var3 = (ItemBlock)iMaterial).getBlock()) instanceof BlockFlowers && (var5 = (var4 = (BlockFlowers)iMaterial).getBeeInteractionEffect()) != null) {
            this.usePlayerItem(var0, var1, var2);
            if (!this.level().isClientSide()) {
                this.addEffect(var5);
            }
            return EnumInteractionResult.SUCCESS;
        }
        return super.mobInteract(var0, var1);
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(TagsItem.BEE_FOOD);
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return null;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.BEE_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.BEE_DEATH;
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    public @Nullable EntityBee getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return EntityTypes.BEE.create(var0, EntitySpawnReason.BREEDING);
    }

    @Override
    protected void checkFallDamage(double var0, boolean var2, IBlockData var3, BlockPosition var4) {
    }

    @Override
    public boolean isFlapping() {
        return this.isFlying() && this.tickCount % TICKS_PER_FLAP == 0;
    }

    @Override
    public boolean isFlying() {
        return !this.onGround();
    }

    public void dropOffNectar() {
        this.setHasNectar(false);
        this.resetNumCropsGrownSincePollination();
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        if (this.isInvulnerableTo(var0, var1)) {
            return false;
        }
        this.beePollinateGoal.stopPollinating();
        return super.hurtServer(var0, var1, var2);
    }

    @Override
    protected void jumpInLiquid(TagKey<FluidType> var0) {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.01, 0.0));
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, 0.5f * this.getEyeHeight(), this.getBbWidth() * 0.2f);
    }

    boolean closerThan(BlockPosition var0, int var1) {
        return var0.closerThan(this.blockPosition(), var1);
    }

    public void setHivePos(BlockPosition var0) {
        this.hivePos = var0;
    }

    public static boolean attractsBees(IBlockData var0) {
        if (var0.is(TagsBlock.BEE_ATTRACTIVE)) {
            if (var0.getValueOrElse(BlockProperties.WATERLOGGED, false).booleanValue()) {
                return false;
            }
            if (var0.is(Blocks.SUNFLOWER)) {
                return var0.getValue(BlockTallPlant.HALF) == BlockPropertyDoubleBlockHalf.UPPER;
            }
            return true;
        }
        return false;
    }

    @Override
    public void registerDebugValues(WorldServer var0, DebugValueSource.a var1) {
        super.registerDebugValues(var0, var1);
        var1.register(DebugSubscriptions.BEES, () -> new DebugBeeInfo(Optional.ofNullable(this.getHivePos()), Optional.ofNullable(this.getSavedFlowerPos()), this.getTravellingTicks(), this.getBlacklistedHives()));
    }

    @Override
    public /* synthetic */ @Nullable EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }

    class j
    extends ControllerLook {
        j(EntityInsentient var1) {
            super(var1);
        }

        @Override
        public void tick() {
            if (EntityBee.this.isAngry()) {
                return;
            }
            super.tick();
        }

        @Override
        protected boolean resetXRotOnTick() {
            return !EntityBee.this.beePollinateGoal.isPollinating();
        }
    }

    class b
    extends PathfinderGoalMeleeAttack {
        b(EntityCreature var1, double var2, boolean var4) {
            super(var1, var2, var4);
        }

        @Override
        public boolean canUse() {
            return super.canUse() && EntityBee.this.isAngry() && !EntityBee.this.hasStung();
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && EntityBee.this.isAngry() && !EntityBee.this.hasStung();
        }
    }

    class d
    extends a {
        d() {
        }

        @Override
        public boolean canBeeUse() {
            TileEntityBeehive var0;
            if (EntityBee.this.hivePos != null && EntityBee.this.wantsToEnterHive() && EntityBee.this.hivePos.closerToCenterThan(EntityBee.this.position(), 2.0) && (var0 = EntityBee.this.getBeehiveBlockEntity()) != null) {
                if (var0.isFull()) {
                    EntityBee.this.hivePos = null;
                } else {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean canBeeContinueToUse() {
            return false;
        }

        @Override
        public void start() {
            TileEntityBeehive var0 = EntityBee.this.getBeehiveBlockEntity();
            if (var0 != null) {
                var0.addOccupant(EntityBee.this);
            }
        }
    }

    class n
    extends a {
        private final int VALIDATE_HIVE_COOLDOWN;
        private long lastValidateTick;

        n() {
            this.VALIDATE_HIVE_COOLDOWN = MathHelper.nextInt(EntityBee.this.random, 20, 40);
            this.lastValidateTick = -1L;
        }

        @Override
        public void start() {
            if (EntityBee.this.hivePos != null && EntityBee.this.level().isLoaded(EntityBee.this.hivePos) && !EntityBee.this.isHiveValid()) {
                EntityBee.this.dropHive();
            }
            this.lastValidateTick = EntityBee.this.level().getGameTime();
        }

        @Override
        public boolean canBeeUse() {
            return EntityBee.this.level().getGameTime() > this.lastValidateTick + (long)this.VALIDATE_HIVE_COOLDOWN;
        }

        @Override
        public boolean canBeeContinueToUse() {
            return false;
        }
    }

    class m
    extends a {
        private final int validateFlowerCooldown;
        private long lastValidateTick;

        m() {
            this.validateFlowerCooldown = MathHelper.nextInt(EntityBee.this.random, 20, 40);
            this.lastValidateTick = -1L;
        }

        @Override
        public void start() {
            if (EntityBee.this.savedFlowerPos != null && EntityBee.this.level().isLoaded(EntityBee.this.savedFlowerPos) && !this.isFlower(EntityBee.this.savedFlowerPos)) {
                EntityBee.this.dropFlower();
            }
            this.lastValidateTick = EntityBee.this.level().getGameTime();
        }

        @Override
        public boolean canBeeUse() {
            return EntityBee.this.level().getGameTime() > this.lastValidateTick + (long)this.validateFlowerCooldown;
        }

        @Override
        public boolean canBeeContinueToUse() {
            return false;
        }

        private boolean isFlower(BlockPosition var0) {
            return EntityBee.attractsBees(EntityBee.this.level().getBlockState(var0));
        }
    }

    class k
    extends a {
        private static final int MIN_POLLINATION_TICKS = 400;
        private static final double ARRIVAL_THRESHOLD = 0.1;
        private static final int POSITION_CHANGE_CHANCE = 25;
        private static final float SPEED_MODIFIER = 0.35f;
        private static final float HOVER_HEIGHT_WITHIN_FLOWER = 0.6f;
        private static final float HOVER_POS_OFFSET = 0.33333334f;
        private static final int FLOWER_SEARCH_RADIUS = 5;
        private int successfulPollinatingTicks;
        private int lastSoundPlayedTick;
        private boolean pollinating;
        private @Nullable Vec3D hoverPos;
        private int pollinatingTicks;
        private static final int MAX_POLLINATING_TICKS = 600;
        private Long2LongOpenHashMap unreachableFlowerCache;

        k() {
            this.unreachableFlowerCache = new Long2LongOpenHashMap();
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canBeeUse() {
            if (EntityBee.this.remainingCooldownBeforeLocatingNewFlower > 0) {
                return false;
            }
            if (EntityBee.this.hasNectar()) {
                return false;
            }
            if (EntityBee.this.level().isRaining()) {
                return false;
            }
            Optional<BlockPosition> var0 = this.findNearbyFlower();
            if (var0.isPresent()) {
                EntityBee.this.savedFlowerPos = var0.get();
                EntityBee.this.navigation.moveTo((double)EntityBee.this.savedFlowerPos.getX() + 0.5, (double)EntityBee.this.savedFlowerPos.getY() + 0.5, (double)EntityBee.this.savedFlowerPos.getZ() + 0.5, 1.2f);
                return true;
            }
            EntityBee.this.remainingCooldownBeforeLocatingNewFlower = MathHelper.nextInt(EntityBee.this.random, 20, 60);
            return false;
        }

        @Override
        public boolean canBeeContinueToUse() {
            if (!this.pollinating) {
                return false;
            }
            if (!EntityBee.this.hasSavedFlowerPos()) {
                return false;
            }
            if (EntityBee.this.level().isRaining()) {
                return false;
            }
            if (this.hasPollinatedLongEnough()) {
                return EntityBee.this.random.nextFloat() < 0.2f;
            }
            return true;
        }

        private boolean hasPollinatedLongEnough() {
            return this.successfulPollinatingTicks > 400;
        }

        boolean isPollinating() {
            return this.pollinating;
        }

        void stopPollinating() {
            this.pollinating = false;
        }

        @Override
        public void start() {
            this.successfulPollinatingTicks = 0;
            this.pollinatingTicks = 0;
            this.lastSoundPlayedTick = 0;
            this.pollinating = true;
            EntityBee.this.resetTicksWithoutNectarSinceExitingHive();
        }

        @Override
        public void stop() {
            if (this.hasPollinatedLongEnough()) {
                EntityBee.this.setHasNectar(true);
            }
            this.pollinating = false;
            EntityBee.this.navigation.stop();
            EntityBee.this.remainingCooldownBeforeLocatingNewFlower = 200;
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            if (!EntityBee.this.hasSavedFlowerPos()) {
                return;
            }
            ++this.pollinatingTicks;
            if (this.pollinatingTicks > 600) {
                EntityBee.this.dropFlower();
                this.pollinating = false;
                EntityBee.this.remainingCooldownBeforeLocatingNewFlower = 200;
                return;
            }
            Vec3D var0 = Vec3D.atBottomCenterOf(EntityBee.this.savedFlowerPos).add(0.0, 0.6f, 0.0);
            if (var0.distanceTo(EntityBee.this.position()) > 1.0) {
                this.hoverPos = var0;
                this.setWantedPos();
                return;
            }
            if (this.hoverPos == null) {
                this.hoverPos = var0;
            }
            boolean var1 = EntityBee.this.position().distanceTo(this.hoverPos) <= 0.1;
            boolean var2 = true;
            if (!var1 && this.pollinatingTicks > 600) {
                EntityBee.this.dropFlower();
                return;
            }
            if (var1) {
                boolean var3;
                boolean bl = var3 = EntityBee.this.random.nextInt(25) == 0;
                if (var3) {
                    this.hoverPos = new Vec3D(var0.x() + (double)this.getOffset(), var0.y(), var0.z() + (double)this.getOffset());
                    EntityBee.this.navigation.stop();
                } else {
                    var2 = false;
                }
                EntityBee.this.getLookControl().setLookAt(var0.x(), var0.y(), var0.z());
            }
            if (var2) {
                this.setWantedPos();
            }
            ++this.successfulPollinatingTicks;
            if (EntityBee.this.random.nextFloat() < 0.05f && this.successfulPollinatingTicks > this.lastSoundPlayedTick + 60) {
                this.lastSoundPlayedTick = this.successfulPollinatingTicks;
                EntityBee.this.playSound(SoundEffects.BEE_POLLINATE, 1.0f, 1.0f);
            }
        }

        private void setWantedPos() {
            EntityBee.this.getMoveControl().setWantedPosition(this.hoverPos.x(), this.hoverPos.y(), this.hoverPos.z(), 0.35f);
        }

        private float getOffset() {
            return (EntityBee.this.random.nextFloat() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<BlockPosition> findNearbyFlower() {
            Iterable<BlockPosition> var0 = BlockPosition.withinManhattan(EntityBee.this.blockPosition(), 5, 5, 5);
            Long2LongOpenHashMap var1 = new Long2LongOpenHashMap();
            for (BlockPosition var3 : var0) {
                long var4 = this.unreachableFlowerCache.getOrDefault(var3.asLong(), Long.MIN_VALUE);
                if (EntityBee.this.level().getGameTime() < var4) {
                    var1.put(var3.asLong(), var4);
                    continue;
                }
                if (!EntityBee.attractsBees(EntityBee.this.level().getBlockState(var3))) continue;
                PathEntity var6 = EntityBee.this.navigation.createPath(var3, 1);
                if (var6 != null && var6.canReach()) {
                    return Optional.of(var3);
                }
                var1.put(var3.asLong(), EntityBee.this.level().getGameTime() + 600L);
            }
            this.unreachableFlowerCache = var1;
            return Optional.empty();
        }
    }

    class i
    extends a {
        i() {
        }

        @Override
        public boolean canBeeUse() {
            return EntityBee.this.remainingCooldownBeforeLocatingNewHive == 0 && !EntityBee.this.hasHive() && EntityBee.this.wantsToEnterHive();
        }

        @Override
        public boolean canBeeContinueToUse() {
            return false;
        }

        @Override
        public void start() {
            EntityBee.this.remainingCooldownBeforeLocatingNewHive = 200;
            List<BlockPosition> var0 = this.findNearbyHivesWithSpace();
            if (var0.isEmpty()) {
                return;
            }
            for (BlockPosition var2 : var0) {
                if (EntityBee.this.goToHiveGoal.isTargetBlacklisted(var2)) continue;
                EntityBee.this.hivePos = var2;
                return;
            }
            EntityBee.this.goToHiveGoal.clearBlacklist();
            EntityBee.this.hivePos = var0.get(0);
        }

        private List<BlockPosition> findNearbyHivesWithSpace() {
            BlockPosition var02 = EntityBee.this.blockPosition();
            VillagePlace var12 = ((WorldServer)EntityBee.this.level()).getPoiManager();
            Stream<VillagePlaceRecord> var2 = var12.getInRange(var0 -> var0.is(PoiTypeTags.BEE_HOME), var02, 20, VillagePlace.Occupancy.ANY);
            return var2.map(VillagePlaceRecord::getPos).filter(EntityBee.this::doesHiveHaveSpace).sorted(Comparator.comparingDouble(var1 -> var1.distSqr(var02))).collect(Collectors.toList());
        }
    }

    @VisibleForDebug
    public class e
    extends a {
        public static final int MAX_TRAVELLING_TICKS = 2400;
        int travellingTicks;
        private static final int MAX_BLACKLISTED_TARGETS = 3;
        final List<BlockPosition> blacklistedTargets;
        private @Nullable PathEntity lastPath;
        private static final int TICKS_BEFORE_HIVE_DROP = 60;
        private int ticksStuck;

        e() {
            this.blacklistedTargets = Lists.newArrayList();
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canBeeUse() {
            return EntityBee.this.hivePos != null && !EntityBee.this.isTooFarAway(EntityBee.this.hivePos) && !EntityBee.this.hasHome() && EntityBee.this.wantsToEnterHive() && !this.hasReachedTarget(EntityBee.this.hivePos) && EntityBee.this.level().getBlockState(EntityBee.this.hivePos).is(TagsBlock.BEEHIVES);
        }

        @Override
        public boolean canBeeContinueToUse() {
            return this.canBeeUse();
        }

        @Override
        public void start() {
            this.travellingTicks = 0;
            this.ticksStuck = 0;
            super.start();
        }

        @Override
        public void stop() {
            this.travellingTicks = 0;
            this.ticksStuck = 0;
            EntityBee.this.navigation.stop();
            EntityBee.this.navigation.resetMaxVisitedNodesMultiplier();
        }

        @Override
        public void tick() {
            if (EntityBee.this.hivePos == null) {
                return;
            }
            ++this.travellingTicks;
            if (this.travellingTicks > this.adjustedTickDelay(2400)) {
                this.dropAndBlacklistHive();
                return;
            }
            if (EntityBee.this.navigation.isInProgress()) {
                return;
            }
            if (EntityBee.this.closerThan(EntityBee.this.hivePos, 16)) {
                boolean var0 = this.pathfindDirectlyTowards(EntityBee.this.hivePos);
                if (!var0) {
                    this.dropAndBlacklistHive();
                } else if (this.lastPath != null && EntityBee.this.navigation.getPath().sameAs(this.lastPath)) {
                    ++this.ticksStuck;
                    if (this.ticksStuck > 60) {
                        EntityBee.this.dropHive();
                        this.ticksStuck = 0;
                    }
                } else {
                    this.lastPath = EntityBee.this.navigation.getPath();
                }
                return;
            }
            if (EntityBee.this.isTooFarAway(EntityBee.this.hivePos)) {
                EntityBee.this.dropHive();
                return;
            }
            EntityBee.this.pathfindRandomlyTowards(EntityBee.this.hivePos);
        }

        private boolean pathfindDirectlyTowards(BlockPosition var0) {
            int var1 = EntityBee.this.closerThan(var0, 3) ? 1 : 2;
            EntityBee.this.navigation.setMaxVisitedNodesMultiplier(10.0f);
            EntityBee.this.navigation.moveTo(var0.getX(), var0.getY(), var0.getZ(), var1, 1.0);
            return EntityBee.this.navigation.getPath() != null && EntityBee.this.navigation.getPath().canReach();
        }

        boolean isTargetBlacklisted(BlockPosition var0) {
            return this.blacklistedTargets.contains(var0);
        }

        private void blacklistTarget(BlockPosition var0) {
            this.blacklistedTargets.add(var0);
            while (this.blacklistedTargets.size() > 3) {
                this.blacklistedTargets.remove(0);
            }
        }

        void clearBlacklist() {
            this.blacklistedTargets.clear();
        }

        private void dropAndBlacklistHive() {
            if (EntityBee.this.hivePos != null) {
                this.blacklistTarget(EntityBee.this.hivePos);
            }
            EntityBee.this.dropHive();
        }

        private boolean hasReachedTarget(BlockPosition var0) {
            if (EntityBee.this.closerThan(var0, 2)) {
                return true;
            }
            PathEntity var1 = EntityBee.this.navigation.getPath();
            return var1 != null && var1.getTarget().equals(var0) && var1.canReach() && var1.isDone();
        }
    }

    public class f
    extends a {
        private static final int MAX_TRAVELLING_TICKS = 2400;
        int travellingTicks;

        f() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canBeeUse() {
            return EntityBee.this.savedFlowerPos != null && !EntityBee.this.hasHome() && this.wantsToGoToKnownFlower() && !EntityBee.this.closerThan(EntityBee.this.savedFlowerPos, 2);
        }

        @Override
        public boolean canBeeContinueToUse() {
            return this.canBeeUse();
        }

        @Override
        public void start() {
            this.travellingTicks = 0;
            super.start();
        }

        @Override
        public void stop() {
            this.travellingTicks = 0;
            EntityBee.this.navigation.stop();
            EntityBee.this.navigation.resetMaxVisitedNodesMultiplier();
        }

        @Override
        public void tick() {
            if (EntityBee.this.savedFlowerPos == null) {
                return;
            }
            ++this.travellingTicks;
            if (this.travellingTicks > this.adjustedTickDelay(2400)) {
                EntityBee.this.dropFlower();
                return;
            }
            if (EntityBee.this.navigation.isInProgress()) {
                return;
            }
            if (EntityBee.this.isTooFarAway(EntityBee.this.savedFlowerPos)) {
                EntityBee.this.dropFlower();
                return;
            }
            EntityBee.this.pathfindRandomlyTowards(EntityBee.this.savedFlowerPos);
        }

        private boolean wantsToGoToKnownFlower() {
            return EntityBee.this.ticksWithoutNectarSinceExitingHive > 600;
        }
    }

    class g
    extends a {
        static final int GROW_CHANCE = 30;

        g() {
        }

        @Override
        public boolean canBeeUse() {
            if (EntityBee.this.getCropsGrownSincePollination() >= 10) {
                return false;
            }
            if (EntityBee.this.random.nextFloat() < 0.3f) {
                return false;
            }
            return EntityBee.this.hasNectar() && EntityBee.this.isHiveValid();
        }

        @Override
        public boolean canBeeContinueToUse() {
            return this.canBeeUse();
        }

        @Override
        public void tick() {
            if (EntityBee.this.random.nextInt(this.adjustedTickDelay(30)) != 0) {
                return;
            }
            for (int var0 = 1; var0 <= 2; ++var0) {
                IBlockFragilePlantElement var6;
                BlockPosition var1 = EntityBee.this.blockPosition().below(var0);
                IBlockData var2 = EntityBee.this.level().getBlockState(var1);
                Block var3 = var2.getBlock();
                IBlockData var4 = null;
                if (!var2.is(TagsBlock.BEE_GROWABLES)) continue;
                if (var3 instanceof BlockCrops) {
                    BlockCrops var5 = (BlockCrops)var3;
                    if (!var5.isMaxAge(var2)) {
                        var4 = var5.getStateForAge(var5.getAge(var2) + 1);
                    }
                } else if (var3 instanceof BlockStem) {
                    int var62 = var2.getValue(BlockStem.AGE);
                    if (var62 < 7) {
                        var4 = (IBlockData)var2.setValue(BlockStem.AGE, var62 + 1);
                    }
                } else if (var2.is(Blocks.SWEET_BERRY_BUSH)) {
                    int var63 = var2.getValue(BlockSweetBerryBush.AGE);
                    if (var63 < 3) {
                        var4 = (IBlockData)var2.setValue(BlockSweetBerryBush.AGE, var63 + 1);
                    }
                } else if ((var2.is(Blocks.CAVE_VINES) || var2.is(Blocks.CAVE_VINES_PLANT)) && (var6 = (IBlockFragilePlantElement)((Object)var2.getBlock())).isValidBonemealTarget(EntityBee.this.level(), var1, var2)) {
                    var6.performBonemeal((WorldServer)EntityBee.this.level(), EntityBee.this.random, var1, var2);
                    var4 = EntityBee.this.level().getBlockState(var1);
                }
                if (var4 == null) continue;
                EntityBee.this.level().levelEvent(2011, var1, 15);
                EntityBee.this.level().setBlockAndUpdate(var1, var4);
                EntityBee.this.incrementNumCropsGrownSincePollination();
            }
        }
    }

    class l
    extends PathfinderGoal {
        l() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            return EntityBee.this.navigation.isDone() && EntityBee.this.random.nextInt(10) == 0;
        }

        @Override
        public boolean canContinueToUse() {
            return EntityBee.this.navigation.isInProgress();
        }

        @Override
        public void start() {
            Vec3D var0 = this.findPos();
            if (var0 != null) {
                EntityBee.this.navigation.moveTo(EntityBee.this.navigation.createPath(BlockPosition.containing(var0), 1), 1.0);
            }
        }

        private @Nullable Vec3D findPos() {
            Vec3D var0;
            if (EntityBee.this.isHiveValid() && !EntityBee.this.closerThan(EntityBee.this.hivePos, this.getWanderThreshold())) {
                Vec3D var1 = Vec3D.atCenterOf(EntityBee.this.hivePos);
                var0 = var1.subtract(EntityBee.this.position()).normalize();
            } else {
                var0 = EntityBee.this.getViewVector(0.0f);
            }
            int var1 = 8;
            Vec3D var2 = HoverRandomPos.getPos(EntityBee.this, 8, 7, var0.x, var0.z, 1.5707964f, 3, 1);
            if (var2 != null) {
                return var2;
            }
            return AirAndWaterRandomPos.getPos(EntityBee.this, 8, 4, -2, var0.x, var0.z, 1.5707963705062866);
        }

        private int getWanderThreshold() {
            int var0 = EntityBee.this.hasHive() || EntityBee.this.hasSavedFlowerPos() ? 24 : 16;
            return 48 - var0;
        }
    }

    class h
    extends PathfinderGoalHurtByTarget {
        h(EntityBee var1) {
            super(var1, new Class[0]);
        }

        @Override
        public boolean canContinueToUse() {
            return EntityBee.this.isAngry() && super.canContinueToUse();
        }

        @Override
        protected void alertOther(EntityInsentient var0, EntityLiving var1) {
            if (var0 instanceof EntityBee && this.mob.hasLineOfSight(var1)) {
                var0.setTarget(var1);
            }
        }
    }

    static class c
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        c(EntityBee var0) {
            super(var0, EntityHuman.class, 10, true, false, var0::isAngryAt);
        }

        @Override
        public boolean canUse() {
            return this.beeCanTarget() && super.canUse();
        }

        @Override
        public boolean canContinueToUse() {
            boolean var0 = this.beeCanTarget();
            if (!var0 || this.mob.getTarget() == null) {
                this.targetMob = null;
                return false;
            }
            return super.canContinueToUse();
        }

        private boolean beeCanTarget() {
            EntityBee var0 = (EntityBee)this.mob;
            return var0.isAngry() && !var0.hasStung();
        }
    }

    abstract class a
    extends PathfinderGoal {
        a() {
        }

        public abstract boolean canBeeUse();

        public abstract boolean canBeeContinueToUse();

        @Override
        public boolean canUse() {
            return this.canBeeUse() && !EntityBee.this.isAngry();
        }

        @Override
        public boolean canContinueToUse() {
            return this.canBeeContinueToUse() && !EntityBee.this.isAngry();
        }
    }
}

