/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.camel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorFollowAdult;
import net.minecraft.world.entity.ai.behavior.BehaviorGateSingle;
import net.minecraft.world.entity.ai.behavior.BehaviorLook;
import net.minecraft.world.entity.ai.behavior.BehaviorLookWalk;
import net.minecraft.world.entity.ai.behavior.BehaviorMakeLoveAnimal;
import net.minecraft.world.entity.ai.behavior.BehaviorNop;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollRandomUnconstrained;
import net.minecraft.world.entity.ai.behavior.BehaviorSwim;
import net.minecraft.world.entity.ai.behavior.BehavorMove;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.schedule.Activity;

public class CamelAi {
    private static final float SPEED_MULTIPLIER_WHEN_PANICKING = 4.0f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 2.0f;
    private static final float SPEED_MULTIPLIER_WHEN_TEMPTED = 2.5f;
    private static final float SPEED_MULTIPLIER_WHEN_FOLLOWING_ADULT = 2.5f;
    private static final float SPEED_MULTIPLIER_WHEN_MAKING_LOVE = 1.0f;
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of(5, 16);
    private static final ImmutableList<SensorType<? extends Sensor<? super Camel>>> SENSOR_TYPES = ImmutableList.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.HURT_BY, SensorType.FOOD_TEMPTATIONS, SensorType.NEAREST_ADULT);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of(MemoryModuleType.IS_PANICKING, MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.WALK_TARGET, MemoryModuleType.LOOK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.PATH, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.GAZE_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, (Object[])new MemoryModuleType[]{MemoryModuleType.BREED_TARGET, MemoryModuleType.NEAREST_VISIBLE_ADULT});

    protected static void initMemories(Camel var0, RandomSource var1) {
    }

    public static BehaviorController.b<Camel> brainProvider() {
        return BehaviorController.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected static BehaviorController<?> makeBrain(BehaviorController<Camel> var0) {
        CamelAi.initCoreActivity(var0);
        CamelAi.initIdleActivity(var0);
        var0.setCoreActivities((Set<Activity>)ImmutableSet.of((Object)Activity.CORE));
        var0.setDefaultActivity(Activity.IDLE);
        var0.useDefaultActivity();
        return var0;
    }

    private static void initCoreActivity(BehaviorController<Camel> var0) {
        var0.addActivity(Activity.CORE, 0, (ImmutableList<BehaviorControl<Camel>>)ImmutableList.of(new BehaviorSwim(0.8f), (Object)new a(4.0f), (Object)new BehaviorLook(45, 90), (Object)new BehavorMove(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.GAZE_COOLDOWN_TICKS)));
    }

    private static void initIdleActivity(BehaviorController<Camel> var02) {
        var02.addActivity(Activity.IDLE, (ImmutableList<Pair<Integer, BehaviorControl<Camel>>>)ImmutableList.of((Object)Pair.of((Object)0, SetEntityLookTargetSometimes.create(EntityTypes.PLAYER, 6.0f, UniformInt.of(30, 60))), (Object)Pair.of((Object)1, (Object)new BehaviorMakeLoveAnimal(EntityTypes.CAMEL)), (Object)Pair.of((Object)2, new BehaviorGateSingle(ImmutableList.of((Object)Pair.of((Object)new FollowTemptation(var0 -> Float.valueOf(2.5f), var0 -> var0.isBaby() ? 2.5 : 3.5), (Object)1), (Object)Pair.of(BehaviorBuilder.triggerIf(Predicate.not(Camel::refuseToMove), BehaviorFollowAdult.create(ADULT_FOLLOW_RANGE, 2.5f)), (Object)1)))), (Object)Pair.of((Object)3, (Object)new RandomLookAround(UniformInt.of(150, 250), 30.0f, 0.0f, 0.0f)), (Object)Pair.of((Object)4, new BehaviorGateSingle((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)), ImmutableList.of((Object)Pair.of(BehaviorBuilder.triggerIf(Predicate.not(Camel::refuseToMove), BehaviorStrollRandomUnconstrained.stroll(2.0f)), (Object)1), (Object)Pair.of(BehaviorBuilder.triggerIf(Predicate.not(Camel::refuseToMove), BehaviorLookWalk.create(2.0f, 3)), (Object)1), (Object)Pair.of((Object)new b(20), (Object)1), (Object)Pair.of((Object)new BehaviorNop(30, 60), (Object)1))))));
    }

    public static void updateActivity(Camel var0) {
        var0.getBrain().setActiveActivityToFirstValid((List<Activity>)ImmutableList.of((Object)Activity.IDLE));
    }

    public static class a
    extends AnimalPanic<Camel> {
        public a(float var0) {
            super(var0);
        }

        @Override
        protected boolean checkExtraStartConditions(WorldServer var0, Camel var1) {
            return super.checkExtraStartConditions(var0, var1) && !var1.isMobControlled();
        }

        @Override
        protected void start(WorldServer var0, Camel var1, long var2) {
            var1.standUpInstantly();
            super.start(var0, var1, var2);
        }

        @Override
        protected /* synthetic */ void start(WorldServer worldServer, EntityCreature entityCreature, long l2) {
            this.start(worldServer, (Camel)entityCreature, l2);
        }

        @Override
        protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
            this.start(worldServer, (Camel)entityLiving, l2);
        }
    }

    public static class b
    extends Behavior<Camel> {
        private final int minimalPoseTicks;

        public b(int var0) {
            super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of());
            this.minimalPoseTicks = var0 * 20;
        }

        @Override
        protected boolean checkExtraStartConditions(WorldServer var0, Camel var1) {
            return !var1.isInWater() && var1.getPoseTime() >= (long)this.minimalPoseTicks && !var1.isLeashed() && var1.onGround() && !var1.hasControllingPassenger() && var1.canCamelChangePose();
        }

        @Override
        protected void start(WorldServer var0, Camel var1, long var2) {
            if (var1.isCamelSitting()) {
                var1.standUp();
            } else if (!var1.isPanicking()) {
                var1.sitDown();
            }
        }

        @Override
        protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
            this.start(worldServer, (Camel)entityLiving, l2);
        }
    }
}

