/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.chicken;

import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.chicken.ChickenVariant;
import net.minecraft.world.entity.animal.chicken.ChickenVariants;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class EntityChicken
extends EntityAnimal {
    private static final EntitySize BABY_DIMENSIONS = EntityTypes.CHICKEN.getDimensions().scale(0.5f).withEyeHeight(0.2975f);
    private static final DataWatcherObject<Holder<ChickenVariant>> DATA_VARIANT_ID = DataWatcher.defineId(EntityChicken.class, DataWatcherRegistry.CHICKEN_VARIANT);
    private static final boolean DEFAULT_CHICKEN_JOCKEY = false;
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    private float nextFlap = 1.0f;
    public int eggTime = this.random.nextInt(6000) + 6000;
    public boolean isChickenJockey = false;

    public EntityChicken(EntityTypes<? extends EntityChicken> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(1, new PathfinderGoalPanic(this, 1.4));
        this.goalSelector.addGoal(2, new PathfinderGoalBreed(this, 1.0));
        this.goalSelector.addGoal(3, new PathfinderGoalTempt(this, 1.0, var0 -> var0.is(TagsItem.CHICKEN_FOOD), false));
        this.goalSelector.addGoal(4, new PathfinderGoalFollowParent(this, 1.1));
        this.goalSelector.addGoal(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.goalSelector.addGoal(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.addGoal(7, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose var0) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(var0);
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityAnimal.createAnimalAttributes().add(GenericAttributes.MAX_HEALTH, 4.0).add(GenericAttributes.MOVEMENT_SPEED, 0.25);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (this.onGround() ? -1.0f : 4.0f) * 0.3f;
        this.flapSpeed = MathHelper.clamp(this.flapSpeed, 0.0f, 1.0f);
        if (!this.onGround() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3D var0 = this.getDeltaMovement();
        if (!this.onGround() && var0.y < 0.0) {
            this.setDeltaMovement(var0.multiply(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            if (this.isAlive() && !this.isBaby() && !this.isChickenJockey() && --this.eggTime <= 0) {
                if (this.dropFromGiftLootTable(var1, LootTables.CHICKEN_LAY, this::spawnAtLocation)) {
                    this.playSound(SoundEffects.CHICKEN_EGG, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                    this.gameEvent(GameEvent.ENTITY_PLACE);
                }
                this.eggTime = this.random.nextInt(6000) + 6000;
            }
        }
    }

    @Override
    protected boolean isFlapping() {
        return this.flyDist > this.nextFlap;
    }

    @Override
    protected void onFlap() {
        this.nextFlap = this.flyDist + this.flapSpeed / 2.0f;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.CHICKEN_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.CHICKEN_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.CHICKEN_DEATH;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.CHICKEN_STEP, 0.15f, 1.0f);
    }

    @Override
    public @Nullable EntityChicken getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        EntityChicken var2 = EntityTypes.CHICKEN.create(var0, EntitySpawnReason.BREEDING);
        if (var2 != null && var1 instanceof EntityChicken) {
            EntityChicken var3 = (EntityChicken)var1;
            var2.setVariant(this.random.nextBoolean() ? this.getVariant() : var3.getVariant());
        }
        return var2;
    }

    @Override
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        VariantUtils.selectVariantToSpawn(SpawnContext.create(var0, this.blockPosition()), Registries.CHICKEN_VARIANT).ifPresent(this::setVariant);
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(TagsItem.CHICKEN_FOOD);
    }

    @Override
    protected int getBaseExperienceReward(WorldServer var0) {
        if (this.isChickenJockey()) {
            return 10;
        }
        return super.getBaseExperienceReward(var0);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_VARIANT_ID, VariantUtils.getDefaultOrAny(this.registryAccess(), ChickenVariants.TEMPERATE));
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var02) {
        super.readAdditionalSaveData(var02);
        this.isChickenJockey = var02.getBooleanOr("IsChickenJockey", false);
        var02.getInt("EggLayTime").ifPresent(var0 -> {
            this.eggTime = var0;
        });
        VariantUtils.readVariant(var02, Registries.CHICKEN_VARIANT).ifPresent(this::setVariant);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean("IsChickenJockey", this.isChickenJockey);
        var0.putInt("EggLayTime", this.eggTime);
        VariantUtils.writeVariant(var0, this.getVariant());
    }

    public void setVariant(Holder<ChickenVariant> var0) {
        this.entityData.set(DATA_VARIANT_ID, var0);
    }

    public Holder<ChickenVariant> getVariant() {
        return this.entityData.get(DATA_VARIANT_ID);
    }

    @Override
    public <T> @Nullable T get(DataComponentType<? extends T> var0) {
        if (var0 == DataComponents.CHICKEN_VARIANT) {
            return EntityChicken.castComponentValue(var0, new EitherHolder<ChickenVariant>(this.getVariant()));
        }
        return super.get(var0);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        this.applyImplicitComponentIfPresent(var0, DataComponents.CHICKEN_VARIANT);
        super.applyImplicitComponents(var0);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> var0, T var1) {
        if (var0 == DataComponents.CHICKEN_VARIANT) {
            Optional<Holder<ChickenVariant>> var2 = EntityChicken.castComponentValue(DataComponents.CHICKEN_VARIANT, var1).unwrap(this.registryAccess());
            if (var2.isPresent()) {
                this.setVariant(var2.get());
                return true;
            }
            return false;
        }
        return super.applyImplicitComponent(var0, var1);
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return this.isChickenJockey();
    }

    @Override
    protected void positionRider(Entity var0, Entity.MoveFunction var1) {
        super.positionRider(var0, var1);
        if (var0 instanceof EntityLiving) {
            ((EntityLiving)var0).yBodyRot = this.yBodyRot;
        }
    }

    public boolean isChickenJockey() {
        return this.isChickenJockey;
    }

    public void setChickenJockey(boolean var0) {
        this.isChickenJockey = var0;
    }

    @Override
    public /* synthetic */ @Nullable EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }
}

