/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.equine;

import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.equine.EntityHorseAbstract;
import net.minecraft.world.entity.animal.equine.EntityHorseDonkey;
import net.minecraft.world.entity.animal.equine.EntityHorseMule;
import net.minecraft.world.entity.animal.equine.HorseColor;
import net.minecraft.world.entity.animal.equine.HorseStyle;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public class EntityHorse
extends EntityHorseAbstract {
    private static final DataWatcherObject<Integer> DATA_ID_TYPE_VARIANT = DataWatcher.defineId(EntityHorse.class, DataWatcherRegistry.INT);
    private static final EntitySize BABY_DIMENSIONS = EntityTypes.HORSE.getDimensions().withAttachments(EntityAttachments.builder().attach(EntityAttachment.PASSENGER, 0.0f, EntityTypes.HORSE.getHeight() + 0.125f, 0.0f)).scale(0.5f);
    private static final int DEFAULT_VARIANT = 0;

    public EntityHorse(EntityTypes<? extends EntityHorse> var0, World var1) {
        super((EntityTypes<? extends EntityHorseAbstract>)var0, var1);
        this.setPathfindingMalus(PathType.DANGER_OTHER, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, -1.0f);
    }

    @Override
    protected void randomizeAttributes(RandomSource var0) {
        this.getAttribute(GenericAttributes.MAX_HEALTH).setBaseValue(EntityHorse.generateMaxHealth(var0::nextInt));
        this.getAttribute(GenericAttributes.MOVEMENT_SPEED).setBaseValue(EntityHorse.generateSpeed(var0::nextDouble));
        this.getAttribute(GenericAttributes.JUMP_STRENGTH).setBaseValue(EntityHorse.generateJumpStrength(var0::nextDouble));
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_ID_TYPE_VARIANT, 0);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("Variant", this.getTypeVariant());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.setTypeVariant(var0.getIntOr("Variant", 0));
    }

    private void setTypeVariant(int var0) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, var0);
    }

    private int getTypeVariant() {
        return this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    public void setVariantAndMarkings(HorseColor var0, HorseStyle var1) {
        this.setTypeVariant(var0.getId() & 0xFF | var1.getId() << 8 & 0xFF00);
    }

    public HorseColor getVariant() {
        return HorseColor.byId(this.getTypeVariant() & 0xFF);
    }

    private void setVariant(HorseColor var0) {
        this.setTypeVariant(var0.getId() & 0xFF | this.getTypeVariant() & 0xFFFFFF00);
    }

    @Override
    public <T> @Nullable T get(DataComponentType<? extends T> var0) {
        if (var0 == DataComponents.HORSE_VARIANT) {
            return EntityHorse.castComponentValue(var0, this.getVariant());
        }
        return super.get(var0);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        this.applyImplicitComponentIfPresent(var0, DataComponents.HORSE_VARIANT);
        super.applyImplicitComponents(var0);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> var0, T var1) {
        if (var0 == DataComponents.HORSE_VARIANT) {
            this.setVariant(EntityHorse.castComponentValue(DataComponents.HORSE_VARIANT, var1));
            return true;
        }
        return super.applyImplicitComponent(var0, var1);
    }

    public HorseStyle getMarkings() {
        return HorseStyle.byId((this.getTypeVariant() & 0xFF00) >> 8);
    }

    @Override
    protected void playGallopSound(SoundEffectType var0) {
        super.playGallopSound(var0);
        if (this.random.nextInt(10) == 0) {
            this.playSound(SoundEffects.HORSE_BREATHE, var0.getVolume() * 0.6f, var0.getPitch());
        }
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.HORSE_AMBIENT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.HORSE_DEATH;
    }

    @Override
    protected SoundEffect getEatingSound() {
        return SoundEffects.HORSE_EAT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.HORSE_HURT;
    }

    @Override
    protected SoundEffect getAngrySound() {
        return SoundEffects.HORSE_ANGRY;
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        boolean var2;
        boolean bl = var2 = !this.isBaby() && this.isTamed() && var0.isSecondaryUseActive();
        if (this.isVehicle() || var2) {
            return super.mobInteract(var0, var1);
        }
        ItemStack var3 = var0.getItemInHand(var1);
        if (!var3.isEmpty()) {
            if (this.isFood(var3)) {
                return this.fedFood(var0, var3);
            }
            if (!this.isTamed()) {
                this.makeMad();
                return EnumInteractionResult.SUCCESS;
            }
        }
        return super.mobInteract(var0, var1);
    }

    @Override
    public boolean canMate(EntityAnimal var0) {
        if (var0 == this) {
            return false;
        }
        if (var0 instanceof EntityHorseDonkey || var0 instanceof EntityHorse) {
            return this.canParent() && ((EntityHorseAbstract)var0).canParent();
        }
        return false;
    }

    @Override
    public @Nullable EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        if (var1 instanceof EntityHorseDonkey) {
            EntityHorseMule var2 = EntityTypes.MULE.create(var0, EntitySpawnReason.BREEDING);
            if (var2 != null) {
                this.setOffspringAttributes(var1, var2);
            }
            return var2;
        }
        EntityHorse var2 = (EntityHorse)var1;
        EntityHorse var3 = EntityTypes.HORSE.create(var0, EntitySpawnReason.BREEDING);
        if (var3 != null) {
            int var5 = this.random.nextInt(9);
            HorseColor var4 = var5 < 4 ? this.getVariant() : (var5 < 8 ? var2.getVariant() : SystemUtils.getRandom(HorseColor.values(), this.random));
            int var7 = this.random.nextInt(5);
            HorseStyle var6 = var7 < 2 ? this.getMarkings() : (var7 < 4 ? var2.getMarkings() : SystemUtils.getRandom(HorseStyle.values(), this.random));
            var3.setVariantAndMarkings(var4, var6);
            this.setOffspringAttributes(var1, var3);
        }
        return var3;
    }

    @Override
    public boolean canUseSlot(EnumItemSlot var0) {
        return true;
    }

    @Override
    protected void hurtArmor(DamageSource var0, float var1) {
        this.doHurtEquipment(var0, var1, EnumItemSlot.BODY);
    }

    @Override
    public @Nullable GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        HorseColor var5;
        RandomSource var4 = var0.getRandom();
        if (var3 instanceof a) {
            var5 = ((a)var3).variant;
        } else {
            var5 = SystemUtils.getRandom(HorseColor.values(), var4);
            var3 = new a(var5);
        }
        this.setVariantAndMarkings(var5, SystemUtils.getRandom(HorseStyle.values(), var4));
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose var0) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(var0);
    }

    public static class a
    extends EntityAgeable.a {
        public final HorseColor variant;

        public a(HorseColor var0) {
            super(true);
            this.variant = var0;
        }
    }
}

