/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.nautilus;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.nautilus.NautilusAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.inventory.AbstractMountInventoryMenu;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public abstract class AbstractNautilus
extends EntityTameableAnimal
implements HasCustomInventoryScreen,
IJumpable {
    public static final int INVENTORY_SLOT_OFFSET = 500;
    public static final int INVENTORY_ROWS = 3;
    public static final int SMALL_RESTRICTION_RADIUS = 16;
    public static final int LARGE_RESTRICTION_RADIUS = 32;
    public static final int RESTRICTION_RADIUS_BUFFER = 8;
    private static final int EFFECT_DURATION = 60;
    private static final int EFFECT_REFRESH_RATE = 40;
    private static final double NAUTILUS_WATER_RESISTANCE = 0.9;
    private static final float IN_WATER_SPEED_MODIFIER = 0.011f;
    private static final float RIDDEN_SPEED_MODIFIER_IN_WATER = 0.0325f;
    private static final float RIDDEN_SPEED_MODIFIER_ON_LAND = 0.02f;
    private static final DataWatcherObject<Boolean> DASH = DataWatcher.defineId(AbstractNautilus.class, DataWatcherRegistry.BOOLEAN);
    private static final int DASH_COOLDOWN_TICKS = 40;
    private static final int DASH_MINIMUM_DURATION_TICKS = 5;
    private static final float DASH_MOMENTUM_IN_WATER = 1.2f;
    private static final float DASH_MOMENTUM_ON_LAND = 0.5f;
    private int dashCooldown = 0;
    protected float playerJumpPendingScale;
    protected InventorySubcontainer inventory;
    private static final double BUBBLE_SPREAD_FACTOR = 0.8;
    private static final double BUBBLE_DIRECTION_SCALE = 1.1;
    private static final double BUBBLE_Y_OFFSET = 0.25;
    private static final double BUBBLE_PROBABILITY_MULTIPLIER = 2.0;
    private static final float BUBBLE_PROBABILITY_MIN = 0.15f;
    private static final float BUBBLE_PROBABILITY_MAX = 1.0f;

    protected AbstractNautilus(EntityTypes<? extends AbstractNautilus> var0, World var1) {
        super((EntityTypes<? extends EntityTameableAnimal>)var0, var1);
        this.moveControl = new SmoothSwimmingMoveControl(this, 85, 10, 0.011f, 0.0f, true);
        this.lookControl = new SmoothSwimmingLookControl(this, 10);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.createInventory();
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return this.isTame() || this.isBaby() ? var0.is(TagsItem.NAUTILUS_FOOD) : var0.is(TagsItem.NAUTILUS_TAMING_ITEMS);
    }

    @Override
    protected void usePlayerItem(EntityHuman var0, EnumHand var1, ItemStack var2) {
        if (var2.is(TagsItem.NAUTILUS_BUCKET_FOOD)) {
            var0.setItemInHand(var1, ItemLiquidUtil.createFilledResult(var2, var0, new ItemStack(Items.WATER_BUCKET)));
        } else {
            super.usePlayerItem(var0, var1, var2);
        }
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityAnimal.createAnimalAttributes().add(GenericAttributes.MAX_HEALTH, 15.0).add(GenericAttributes.MOVEMENT_SPEED, 1.0).add(GenericAttributes.ATTACK_DAMAGE, 3.0).add(GenericAttributes.KNOCKBACK_RESISTANCE, 0.3f);
    }

    @Override
    public boolean isPushedByFluid() {
        return false;
    }

    @Override
    protected NavigationAbstract createNavigation(World var0) {
        return new NavigationGuardian(this, var0);
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        return 0.0f;
    }

    public static boolean checkNautilusSpawnRules(EntityTypes<? extends AbstractNautilus> var0, GeneratorAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        int var5 = var1.getSeaLevel();
        int var6 = var5 - 25;
        return var3.getY() >= var6 && var3.getY() <= var5 - 5 && var1.getFluidState(var3.below()).is(TagsFluid.WATER) && var1.getBlockState(var3.above()).is(Blocks.WATER);
    }

    @Override
    public boolean checkSpawnObstruction(IWorldReader var0) {
        return var0.isUnobstructed(this);
    }

    @Override
    public boolean canUseSlot(EnumItemSlot var0) {
        if (var0 == EnumItemSlot.SADDLE || var0 == EnumItemSlot.BODY) {
            return this.isAlive() && !this.isBaby() && this.isTame();
        }
        return super.canUseSlot(var0);
    }

    @Override
    protected boolean canDispenserEquipIntoSlot(EnumItemSlot var0) {
        return var0 == EnumItemSlot.BODY || var0 == EnumItemSlot.SADDLE || super.canDispenserEquipIntoSlot(var0);
    }

    @Override
    protected boolean canAddPassenger(Entity var0) {
        return !this.isVehicle();
    }

    @Override
    public @Nullable EntityLiving getControllingPassenger() {
        Entity var0 = this.getFirstPassenger();
        if (this.isSaddled() && var0 instanceof EntityHuman) {
            EntityHuman var1 = (EntityHuman)var0;
            return var1;
        }
        return super.getControllingPassenger();
    }

    @Override
    protected Vec3D getRiddenInput(EntityHuman var0, Vec3D var1) {
        float var2 = var0.xxa;
        float var3 = 0.0f;
        float var4 = 0.0f;
        if (var0.zza != 0.0f) {
            float var5 = MathHelper.cos(var0.getXRot() * ((float)Math.PI / 180));
            float var6 = -MathHelper.sin(var0.getXRot() * ((float)Math.PI / 180));
            if (var0.zza < 0.0f) {
                var5 *= -0.5f;
                var6 *= -0.5f;
            }
            var4 = var6;
            var3 = var5;
        }
        return new Vec3D(var2, var4, var3);
    }

    protected Vec2F getRiddenRotation(EntityLiving var0) {
        return new Vec2F(var0.getXRot() * 0.5f, var0.getYRot());
    }

    @Override
    protected void tickRidden(EntityHuman var0, Vec3D var1) {
        super.tickRidden(var0, var1);
        Vec2F var2 = this.getRiddenRotation(var0);
        float var3 = this.getYRot();
        float var4 = MathHelper.wrapDegrees(var2.y - var3);
        float var5 = 0.5f;
        this.setRot(var3 += var4 * 0.5f, var2.x);
        this.yBodyRot = this.yHeadRot = var3;
        this.yRotO = this.yHeadRot;
        if (this.isLocalInstanceAuthoritative()) {
            if (this.playerJumpPendingScale > 0.0f && !this.isJumping()) {
                this.executeRidersJump(this.playerJumpPendingScale, var0);
            }
            this.playerJumpPendingScale = 0.0f;
        }
    }

    @Override
    protected void travelInWater(Vec3D var0, double var1, boolean var3, double var4) {
        float var6 = this.getSpeed();
        this.moveRelative(var6, var0);
        this.move(EnumMoveType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
    }

    @Override
    protected float getRiddenSpeed(EntityHuman var0) {
        return this.isInWater() ? 0.0325f * (float)this.getAttributeValue(GenericAttributes.MOVEMENT_SPEED) : 0.02f * (float)this.getAttributeValue(GenericAttributes.MOVEMENT_SPEED);
    }

    protected void doPlayerRide(EntityHuman var0) {
        if (!this.level().isClientSide()) {
            var0.startRiding(this);
            if (!this.isVehicle()) {
                this.clearHome();
            }
        }
    }

    private int getNautilusRestrictionRadius() {
        if (!this.isBaby() && this.getItemBySlot(EnumItemSlot.SADDLE).isEmpty()) {
            return 32;
        }
        return 16;
    }

    protected void checkRestriction() {
        if (this.isLeashed() || this.isVehicle() || !this.isTame()) {
            return;
        }
        int var0 = this.getNautilusRestrictionRadius();
        if (this.hasHome() && this.getHomePosition().closerThan(this.blockPosition(), var0 + 8) && var0 == this.getHomeRadius()) {
            return;
        }
        this.setHomeTo(this.blockPosition(), var0);
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        this.checkRestriction();
        super.customServerAiStep(var0);
    }

    private void applyEffects(World var0) {
        Entity var1 = this.getFirstPassenger();
        if (var1 instanceof EntityHuman) {
            boolean var4;
            EntityHuman var2 = (EntityHuman)var1;
            boolean var3 = var2.hasEffect(MobEffects.BREATH_OF_THE_NAUTILUS);
            boolean bl = var4 = var0.getGameTime() % 40L == 0L;
            if (!var3 || var4) {
                var2.addEffect(new MobEffect(MobEffects.BREATH_OF_THE_NAUTILUS, 60, 0, true, true, true));
            }
        }
    }

    private void spawnBubbles() {
        double var0 = this.getDeltaMovement().length();
        double var2 = MathHelper.clamp(var0 * 2.0, (double)0.15f, 1.0);
        if ((double)this.random.nextFloat() < var2) {
            float var4 = this.getYRot();
            float var5 = MathHelper.clamp(this.getXRot(), -10.0f, 10.0f);
            Vec3D var6 = this.calculateViewVector(var5, var4);
            double var7 = this.random.nextDouble() * 0.8 * (1.0 + var0);
            double var9 = ((double)this.random.nextFloat() - 0.5) * var7;
            double var11 = ((double)this.random.nextFloat() - 0.5) * var7;
            double var13 = ((double)this.random.nextFloat() - 0.5) * var7;
            this.level().addParticle(Particles.BUBBLE, this.getX() - var6.x * 1.1, this.getY() - var6.y + 0.25, this.getZ() - var6.z * 1.1, var9, var11, var13);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            this.applyEffects(this.level());
        }
        if (this.isDashing() && this.dashCooldown < 35) {
            this.setDashing(false);
        }
        if (this.dashCooldown > 0) {
            --this.dashCooldown;
            if (this.dashCooldown == 0) {
                this.makeSound(this.getDashReadySound());
            }
        }
        if (this.isInWater()) {
            this.spawnBubbles();
        }
    }

    @Override
    public boolean canJump() {
        return this.isSaddled();
    }

    @Override
    public void onPlayerJump(int var0) {
        if (!this.isSaddled() || this.dashCooldown > 0) {
            return;
        }
        this.playerJumpPendingScale = this.getPlayerJumpPendingScale(var0);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DASH, false);
    }

    public boolean isDashing() {
        return this.entityData.get(DASH);
    }

    public void setDashing(boolean var0) {
        this.entityData.set(DASH, var0);
    }

    protected void executeRidersJump(float var0, EntityHuman var1) {
        this.addDeltaMovement(var1.getLookAngle().scale((double)((this.isInWater() ? 1.2f : 0.5f) * var0) * this.getAttributeValue(GenericAttributes.MOVEMENT_SPEED) * (double)this.getBlockSpeedFactor()));
        this.dashCooldown = 40;
        this.setDashing(true);
        this.needsSync = true;
    }

    @Override
    public void handleStartJump(int var0) {
        this.makeSound(this.getDashSound());
        this.gameEvent(GameEvent.ENTITY_ACTION);
        this.setDashing(true);
    }

    @Override
    public int getJumpCooldown() {
        return this.dashCooldown;
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (!this.firstTick && DASH.equals(var0)) {
            this.dashCooldown = this.dashCooldown == 0 ? 40 : this.dashCooldown;
        }
        super.onSyncedDataUpdated(var0);
    }

    @Override
    public void handleStopJump() {
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
    }

    protected @Nullable SoundEffect getDashSound() {
        return null;
    }

    protected @Nullable SoundEffect getDashReadySound() {
        return null;
    }

    @Override
    public EnumInteractionResult interact(EntityHuman var0, EnumHand var1) {
        this.setPersistenceRequired();
        return super.interact(var0, var1);
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (this.isBaby()) {
            return super.mobInteract(var0, var1);
        }
        if (this.isTame() && var0.isSecondaryUseActive()) {
            this.openCustomInventoryScreen(var0);
            return EnumInteractionResult.SUCCESS;
        }
        if (!var2.isEmpty()) {
            if (!this.level().isClientSide() && !this.isTame() && this.isFood(var2)) {
                this.usePlayerItem(var0, var1, var2);
                this.tryToTame(var0);
                return EnumInteractionResult.SUCCESS_SERVER;
            }
            if (this.isFood(var2) && this.getHealth() < this.getMaxHealth()) {
                FoodInfo var3 = var2.get(DataComponents.FOOD);
                this.heal(var3 != null ? (float)(2 * var3.nutrition()) : 1.0f);
                this.usePlayerItem(var0, var1, var2);
                this.playEatingSound();
                return EnumInteractionResult.SUCCESS;
            }
            EnumInteractionResult var3 = var2.interactLivingEntity(var0, this, var1);
            if (var3.consumesAction()) {
                return var3;
            }
        }
        if (this.isTame() && !var0.isSecondaryUseActive() && !this.isFood(var2)) {
            this.doPlayerRide(var0);
            return EnumInteractionResult.SUCCESS;
        }
        return super.mobInteract(var0, var1);
    }

    private void tryToTame(EntityHuman var0) {
        if (this.random.nextInt(3) == 0) {
            this.tame(var0);
            this.navigation.stop();
            this.level().broadcastEntityEvent(this, (byte)7);
        } else {
            this.level().broadcastEntityEvent(this, (byte)6);
        }
        this.playEatingSound();
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return true;
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        Entity entity;
        boolean var3 = super.hurtServer(var0, var1, var2);
        if (var3 && (entity = var1.getEntity()) instanceof EntityLiving) {
            EntityLiving var4 = (EntityLiving)entity;
            NautilusAi.setAngerTarget(var0, this, var4);
        }
        return var3;
    }

    @Override
    public boolean canBeAffected(MobEffect var0) {
        if (var0.getEffect() == MobEffects.POISON) {
            return false;
        }
        return super.canBeAffected(var0);
    }

    @Override
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        RandomSource var4 = var0.getRandom();
        NautilusAi.initMemories(this, var4);
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    protected Holder<SoundEffect> getEquipSound(EnumItemSlot var0, ItemStack var1, Equippable var2) {
        if (var0 == EnumItemSlot.SADDLE && this.isUnderWater()) {
            return SoundEffects.NAUTILUS_SADDLE_UNDERWATER_EQUIP;
        }
        if (var0 == EnumItemSlot.SADDLE) {
            return SoundEffects.NAUTILUS_SADDLE_EQUIP;
        }
        return super.getEquipSound(var0, var1, var2);
    }

    public final int getInventorySize() {
        return AbstractMountInventoryMenu.getInventorySize(this.getInventoryColumns());
    }

    protected void createInventory() {
        InventorySubcontainer var0 = this.inventory;
        this.inventory = new InventorySubcontainer(this.getInventorySize());
        if (var0 != null) {
            int var1 = Math.min(var0.getContainerSize(), this.inventory.getContainerSize());
            for (int var2 = 0; var2 < var1; ++var2) {
                ItemStack var3 = var0.getItem(var2);
                if (var3.isEmpty()) continue;
                this.inventory.setItem(var2, var3.copy());
            }
        }
    }

    @Override
    public void openCustomInventoryScreen(EntityHuman var0) {
        if (!this.level().isClientSide() && (!this.isVehicle() || this.hasPassenger(var0)) && this.isTame()) {
            var0.openNautilusInventory(this, this.inventory);
        }
    }

    @Override
    public @Nullable SlotAccess getSlot(int var0) {
        int var1 = var0 - 500;
        if (var1 >= 0 && var1 < this.inventory.getContainerSize()) {
            return this.inventory.getSlot(var1);
        }
        return super.getSlot(var0);
    }

    public boolean hasInventoryChanged(IInventory var0) {
        return this.inventory != var0;
    }

    public int getInventoryColumns() {
        return 0;
    }

    protected boolean isMobControlled() {
        return this.getFirstPassenger() instanceof EntityInsentient;
    }

    protected boolean isAggravated() {
        return this.getBrain().hasMemoryValue(MemoryModuleType.ANGRY_AT) || this.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET);
    }
}

