/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sheep;

import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.biome.BiomeBase;

public class SheepColorSpawnRules {
    private static final b TEMPERATE_SPAWN_CONFIGURATION = new b(SheepColorSpawnRules.weighted(SheepColorSpawnRules.builder().add(SheepColorSpawnRules.single(EnumColor.BLACK), 5).add(SheepColorSpawnRules.single(EnumColor.GRAY), 5).add(SheepColorSpawnRules.single(EnumColor.LIGHT_GRAY), 5).add(SheepColorSpawnRules.single(EnumColor.BROWN), 3).add(SheepColorSpawnRules.commonColors(EnumColor.WHITE), 82).build()));
    private static final b WARM_SPAWN_CONFIGURATION = new b(SheepColorSpawnRules.weighted(SheepColorSpawnRules.builder().add(SheepColorSpawnRules.single(EnumColor.GRAY), 5).add(SheepColorSpawnRules.single(EnumColor.LIGHT_GRAY), 5).add(SheepColorSpawnRules.single(EnumColor.WHITE), 5).add(SheepColorSpawnRules.single(EnumColor.BLACK), 3).add(SheepColorSpawnRules.commonColors(EnumColor.BROWN), 82).build()));
    private static final b COLD_SPAWN_CONFIGURATION = new b(SheepColorSpawnRules.weighted(SheepColorSpawnRules.builder().add(SheepColorSpawnRules.single(EnumColor.LIGHT_GRAY), 5).add(SheepColorSpawnRules.single(EnumColor.GRAY), 5).add(SheepColorSpawnRules.single(EnumColor.WHITE), 5).add(SheepColorSpawnRules.single(EnumColor.BROWN), 3).add(SheepColorSpawnRules.commonColors(EnumColor.BLACK), 82).build()));

    private static a commonColors(EnumColor var0) {
        return SheepColorSpawnRules.weighted(SheepColorSpawnRules.builder().add(SheepColorSpawnRules.single(var0), 499).add(SheepColorSpawnRules.single(EnumColor.PINK), 1).build());
    }

    public static EnumColor getSheepColor(Holder<BiomeBase> var0, RandomSource var1) {
        b var2 = SheepColorSpawnRules.getSheepColorConfiguration(var0);
        return var2.colors().get(var1);
    }

    private static b getSheepColorConfiguration(Holder<BiomeBase> var0) {
        if (var0.is(BiomeTags.SPAWNS_WARM_VARIANT_FARM_ANIMALS)) {
            return WARM_SPAWN_CONFIGURATION;
        }
        if (var0.is(BiomeTags.SPAWNS_COLD_VARIANT_FARM_ANIMALS)) {
            return COLD_SPAWN_CONFIGURATION;
        }
        return TEMPERATE_SPAWN_CONFIGURATION;
    }

    private static a weighted(WeightedList<a> var0) {
        if (var0.isEmpty()) {
            throw new IllegalArgumentException("List must be non-empty");
        }
        return var1 -> ((a)var0.getRandomOrThrow(var1)).get(var1);
    }

    private static a single(EnumColor var0) {
        return var1 -> var0;
    }

    private static WeightedList.a<a> builder() {
        return WeightedList.builder();
    }

    @FunctionalInterface
    static interface a {
        public EnumColor get(RandomSource var1);
    }

    record b(a colors) {
    }
}

