/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public class EntityEnderCrystal
extends Entity {
    private static final DataWatcherObject<Optional<BlockPosition>> DATA_BEAM_TARGET = DataWatcher.defineId(EntityEnderCrystal.class, DataWatcherRegistry.OPTIONAL_BLOCK_POS);
    private static final DataWatcherObject<Boolean> DATA_SHOW_BOTTOM = DataWatcher.defineId(EntityEnderCrystal.class, DataWatcherRegistry.BOOLEAN);
    private static final boolean DEFAULT_SHOW_BOTTOM = true;
    public int time;

    public EntityEnderCrystal(EntityTypes<? extends EntityEnderCrystal> var0, World var1) {
        super(var0, var1);
        this.blocksBuilding = true;
        this.time = this.random.nextInt(100000);
    }

    public EntityEnderCrystal(World var0, double var1, double var3, double var5) {
        this((EntityTypes<? extends EntityEnderCrystal>)EntityTypes.END_CRYSTAL, var0);
        this.setPos(var1, var3, var5);
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_BEAM_TARGET, Optional.empty());
        var0.define(DATA_SHOW_BOTTOM, true);
    }

    @Override
    public void tick() {
        ++this.time;
        this.applyEffectsFromBlocks();
        this.handlePortal();
        if (this.level() instanceof WorldServer) {
            BlockPosition var0 = this.blockPosition();
            if (((WorldServer)this.level()).getDragonFight() != null && this.level().getBlockState(var0).isAir()) {
                this.level().setBlockAndUpdate(var0, BlockFireAbstract.getState(this.level(), var0));
            }
        }
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        var0.storeNullable("beam_target", BlockPosition.CODEC, this.getBeamTarget());
        var0.putBoolean("ShowBottom", this.showsBottom());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        this.setBeamTarget(var0.read("beam_target", BlockPosition.CODEC).orElse(null));
        this.setShowBottom(var0.getBooleanOr("ShowBottom", true));
    }

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public final boolean hurtClient(DamageSource var0) {
        if (this.isInvulnerableToBase(var0)) {
            return false;
        }
        return !(var0.getEntity() instanceof EntityEnderDragon);
    }

    @Override
    public final boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        if (this.isInvulnerableToBase(var1)) {
            return false;
        }
        if (var1.getEntity() instanceof EntityEnderDragon) {
            return false;
        }
        if (!this.isRemoved()) {
            this.remove(Entity.RemovalReason.KILLED);
            if (!var1.is(DamageTypeTags.IS_EXPLOSION)) {
                DamageSource var3 = var1.getEntity() != null ? this.damageSources().explosion(this, var1.getEntity()) : null;
                var0.explode(this, var3, null, this.getX(), this.getY(), this.getZ(), 6.0f, false, World.a.BLOCK);
            }
            this.onDestroyedBy(var0, var1);
        }
        return true;
    }

    @Override
    public void kill(WorldServer var0) {
        this.onDestroyedBy(var0, this.damageSources().generic());
        super.kill(var0);
    }

    private void onDestroyedBy(WorldServer var0, DamageSource var1) {
        EnderDragonBattle var2 = var0.getDragonFight();
        if (var2 != null) {
            var2.onCrystalDestroyed(this, var1);
        }
    }

    public void setBeamTarget(@Nullable BlockPosition var0) {
        this.getEntityData().set(DATA_BEAM_TARGET, Optional.ofNullable(var0));
    }

    public @Nullable BlockPosition getBeamTarget() {
        return this.getEntityData().get(DATA_BEAM_TARGET).orElse(null);
    }

    public void setShowBottom(boolean var0) {
        this.getEntityData().set(DATA_SHOW_BOTTOM, var0);
    }

    public boolean showsBottom() {
        return this.getEntityData().get(DATA_SHOW_BOTTOM);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        return super.shouldRenderAtSqrDistance(var0) || this.getBeamTarget() != null;
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.END_CRYSTAL);
    }
}

