/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon.phases;

import com.mojang.logging.LogUtils;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonController;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class DragonControllerCharge
extends AbstractDragonController {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int CHARGE_RECOVERY_TIME = 10;
    private @Nullable Vec3D targetLocation;
    private int timeSinceCharge;

    public DragonControllerCharge(EntityEnderDragon var0) {
        super(var0);
    }

    @Override
    public void doServerTick(WorldServer var0) {
        if (this.targetLocation == null) {
            LOGGER.warn("Aborting charge player as no target was set.");
            this.dragon.getPhaseManager().setPhase(DragonControllerPhase.HOLDING_PATTERN);
            return;
        }
        if (this.timeSinceCharge > 0 && this.timeSinceCharge++ >= 10) {
            this.dragon.getPhaseManager().setPhase(DragonControllerPhase.HOLDING_PATTERN);
            return;
        }
        double var1 = this.targetLocation.distanceToSqr(this.dragon.getX(), this.dragon.getY(), this.dragon.getZ());
        if (var1 < 100.0 || var1 > 22500.0 || this.dragon.horizontalCollision || this.dragon.verticalCollision) {
            ++this.timeSinceCharge;
        }
    }

    @Override
    public void begin() {
        this.targetLocation = null;
        this.timeSinceCharge = 0;
    }

    public void setTarget(Vec3D var0) {
        this.targetLocation = var0;
    }

    @Override
    public float getFlySpeed() {
        return 3.0f;
    }

    @Override
    public @Nullable Vec3D getFlyTargetLocation() {
        return this.targetLocation;
    }

    public DragonControllerPhase<DragonControllerCharge> getPhase() {
        return DragonControllerPhase.CHARGING_PLAYER;
    }
}

