/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon.phases;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerCharge;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerDying;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerFly;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerHold;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerHover;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerLandedAttack;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerLandedFlame;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerLandedSearch;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerLanding;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerLandingFly;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerStrafe;
import net.minecraft.world.entity.boss.enderdragon.phases.IDragonController;

public class DragonControllerPhase<T extends IDragonController> {
    private static DragonControllerPhase<?>[] phases = new DragonControllerPhase[0];
    public static final DragonControllerPhase<DragonControllerHold> HOLDING_PATTERN = DragonControllerPhase.create(DragonControllerHold.class, "HoldingPattern");
    public static final DragonControllerPhase<DragonControllerStrafe> STRAFE_PLAYER = DragonControllerPhase.create(DragonControllerStrafe.class, "StrafePlayer");
    public static final DragonControllerPhase<DragonControllerLandingFly> LANDING_APPROACH = DragonControllerPhase.create(DragonControllerLandingFly.class, "LandingApproach");
    public static final DragonControllerPhase<DragonControllerLanding> LANDING = DragonControllerPhase.create(DragonControllerLanding.class, "Landing");
    public static final DragonControllerPhase<DragonControllerFly> TAKEOFF = DragonControllerPhase.create(DragonControllerFly.class, "Takeoff");
    public static final DragonControllerPhase<DragonControllerLandedFlame> SITTING_FLAMING = DragonControllerPhase.create(DragonControllerLandedFlame.class, "SittingFlaming");
    public static final DragonControllerPhase<DragonControllerLandedSearch> SITTING_SCANNING = DragonControllerPhase.create(DragonControllerLandedSearch.class, "SittingScanning");
    public static final DragonControllerPhase<DragonControllerLandedAttack> SITTING_ATTACKING = DragonControllerPhase.create(DragonControllerLandedAttack.class, "SittingAttacking");
    public static final DragonControllerPhase<DragonControllerCharge> CHARGING_PLAYER = DragonControllerPhase.create(DragonControllerCharge.class, "ChargingPlayer");
    public static final DragonControllerPhase<DragonControllerDying> DYING = DragonControllerPhase.create(DragonControllerDying.class, "Dying");
    public static final DragonControllerPhase<DragonControllerHover> HOVERING = DragonControllerPhase.create(DragonControllerHover.class, "Hover");
    private final Class<? extends IDragonController> instanceClass;
    private final int id;
    private final String name;

    private DragonControllerPhase(int var0, Class<? extends IDragonController> var1, String var2) {
        this.id = var0;
        this.instanceClass = var1;
        this.name = var2;
    }

    public IDragonController createInstance(EntityEnderDragon var0) {
        try {
            Constructor<IDragonController> var1 = this.getConstructor();
            return var1.newInstance(var0);
        }
        catch (Exception var1) {
            throw new Error(var1);
        }
    }

    protected Constructor<? extends IDragonController> getConstructor() throws NoSuchMethodException {
        return this.instanceClass.getConstructor(EntityEnderDragon.class);
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.name + " (#" + this.id + ")";
    }

    public static DragonControllerPhase<?> getById(int var0) {
        if (var0 < 0 || var0 >= phases.length) {
            return HOLDING_PATTERN;
        }
        return phases[var0];
    }

    public static int getCount() {
        return phases.length;
    }

    private static <T extends IDragonController> DragonControllerPhase<T> create(Class<T> var0, String var1) {
        DragonControllerPhase<T> var2 = new DragonControllerPhase<T>(phases.length, var0, var1);
        phases = Arrays.copyOf(phases, phases.length + 1);
        DragonControllerPhase.phases[var2.getId()] = var2;
        return var2;
    }
}

