/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.illager;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreakDoor;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.entity.animal.golem.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.monster.illager.EntityIllagerAbstract;
import net.minecraft.world.entity.npc.villager.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public class EntityVindicator
extends EntityIllagerAbstract {
    private static final String TAG_JOHNNY = "Johnny";
    static final Predicate<EnumDifficulty> DOOR_BREAKING_PREDICATE = var0 -> var0 == EnumDifficulty.NORMAL || var0 == EnumDifficulty.HARD;
    private static final boolean DEFAULT_JOHNNY = false;
    public boolean isJohnny = false;

    public EntityVindicator(EntityTypes<? extends EntityVindicator> var0, World var1) {
        super((EntityTypes<? extends EntityIllagerAbstract>)var0, var1);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(1, new PathfinderGoalAvoidTarget<Creaking>(this, Creaking.class, 8.0f, 1.0, 1.2));
        this.goalSelector.addGoal(2, new a(this));
        this.goalSelector.addGoal(3, new EntityIllagerAbstract.b(this));
        this.goalSelector.addGoal(4, new EntityRaider.a(this, 10.0f));
        this.goalSelector.addGoal(5, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, true));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.targetSelector.addGoal(4, new b(this));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.goalSelector.addGoal(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        if (!this.isNoAi() && PathfinderGoalUtil.hasGroundPathNavigation(this)) {
            boolean var1 = var0.isRaided(this.blockPosition());
            this.getNavigation().setCanOpenDoors(var1);
        }
        super.customServerAiStep(var0);
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.35f).add(GenericAttributes.FOLLOW_RANGE, 12.0).add(GenericAttributes.MAX_HEALTH, 24.0).add(GenericAttributes.ATTACK_DAMAGE, 5.0);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        if (this.isJohnny) {
            var0.putBoolean(TAG_JOHNNY, true);
        }
    }

    @Override
    public EntityIllagerAbstract.a getArmPose() {
        if (this.isAggressive()) {
            return EntityIllagerAbstract.a.ATTACKING;
        }
        if (this.isCelebrating()) {
            return EntityIllagerAbstract.a.CELEBRATING;
        }
        return EntityIllagerAbstract.a.CROSSED;
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.isJohnny = var0.getBooleanOr(TAG_JOHNNY, false);
    }

    @Override
    public SoundEffect getCelebrateSound() {
        return SoundEffects.VINDICATOR_CELEBRATE;
    }

    @Override
    public @Nullable GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        GroupDataEntity var4 = super.finalizeSpawn(var0, var1, var2, var3);
        this.getNavigation().setCanOpenDoors(true);
        RandomSource var5 = var0.getRandom();
        this.populateDefaultEquipmentSlots(var5, var1);
        this.populateDefaultEquipmentEnchantments(var0, var5, var1);
        return var4;
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource var0, DifficultyDamageScaler var1) {
        if (this.getCurrentRaid() == null) {
            this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.IRON_AXE));
        }
    }

    @Override
    public void setCustomName(@Nullable IChatBaseComponent var0) {
        super.setCustomName(var0);
        if (!this.isJohnny && var0 != null && var0.getString().equals(TAG_JOHNNY)) {
            this.isJohnny = true;
        }
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.VINDICATOR_AMBIENT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.VINDICATOR_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.VINDICATOR_HURT;
    }

    @Override
    public void applyRaidBuffs(WorldServer var0, int var1, boolean var2) {
        boolean var5;
        ItemStack var3 = new ItemStack(Items.IRON_AXE);
        Raid var4 = this.getCurrentRaid();
        boolean bl = var5 = this.random.nextFloat() <= var4.getEnchantOdds();
        if (var5) {
            ResourceKey<EnchantmentProvider> var6 = var1 > var4.getNumGroups(EnumDifficulty.NORMAL) ? VanillaEnchantmentProviders.RAID_VINDICATOR_POST_WAVE_5 : VanillaEnchantmentProviders.RAID_VINDICATOR;
            EnchantmentManager.enchantItemFromProvider(var3, var0.registryAccess(), var6, var0.getCurrentDifficultyAt(this.blockPosition()), this.random);
        }
        this.setItemSlot(EnumItemSlot.MAINHAND, var3);
    }

    static class a
    extends PathfinderGoalBreakDoor {
        public a(EntityInsentient var0) {
            super(var0, 6, DOOR_BREAKING_PREDICATE);
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canContinueToUse() {
            EntityVindicator var0 = (EntityVindicator)this.mob;
            return var0.hasActiveRaid() && super.canContinueToUse();
        }

        @Override
        public boolean canUse() {
            EntityVindicator var0 = (EntityVindicator)this.mob;
            return var0.hasActiveRaid() && var0.random.nextInt(a.reducedTickDelay(10)) == 0 && super.canUse();
        }

        @Override
        public void start() {
            super.start();
            this.mob.setNoActionTime(0);
        }
    }

    static class b
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        public b(EntityVindicator var02) {
            super(var02, EntityLiving.class, 0, true, true, (var0, var1) -> var0.attackable());
        }

        @Override
        public boolean canUse() {
            return ((EntityVindicator)this.mob).isJohnny && super.canUse();
        }

        @Override
        public void start() {
            super.start();
            this.mob.setNoActionTime(0);
        }
    }
}

