/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.skeleton;

import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.skeleton.EntitySkeletonAbstract;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import org.jspecify.annotations.Nullable;

public class EntitySkeletonWither
extends EntitySkeletonAbstract {
    public EntitySkeletonWither(EntityTypes<? extends EntitySkeletonWither> var0, World var1) {
        super((EntityTypes<? extends EntitySkeletonAbstract>)var0, var1);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
    }

    @Override
    protected void registerGoals() {
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityPiglinAbstract>((EntityInsentient)this, EntityPiglinAbstract.class, true));
        super.registerGoals();
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.WITHER_SKELETON_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.WITHER_SKELETON_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.WITHER_SKELETON_DEATH;
    }

    @Override
    SoundEffect getStepSound() {
        return SoundEffects.WITHER_SKELETON_STEP;
    }

    @Override
    public TagKey<Item> getPreferredWeaponType() {
        return null;
    }

    @Override
    public boolean canHoldItem(ItemStack var0) {
        return !var0.is(TagsItem.WITHER_SKELETON_DISLIKED_WEAPONS) && super.canHoldItem(var0);
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource var0, DifficultyDamageScaler var1) {
        this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.STONE_SWORD));
    }

    @Override
    protected void populateDefaultEquipmentEnchantments(WorldAccess var0, RandomSource var1, DifficultyDamageScaler var2) {
    }

    @Override
    public @Nullable GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        GroupDataEntity var4 = super.finalizeSpawn(var0, var1, var2, var3);
        this.getAttribute(GenericAttributes.ATTACK_DAMAGE).setBaseValue(4.0);
        this.reassessWeaponGoal();
        return var4;
    }

    @Override
    public boolean doHurtTarget(WorldServer var0, Entity var1) {
        if (!super.doHurtTarget(var0, var1)) {
            return false;
        }
        if (var1 instanceof EntityLiving) {
            ((EntityLiving)var1).addEffect(new MobEffect(MobEffects.WITHER, 200), this);
        }
        return true;
    }

    @Override
    protected EntityArrow getArrow(ItemStack var0, float var1, @Nullable ItemStack var2) {
        EntityArrow var3 = super.getArrow(var0, var1, var2);
        var3.igniteForSeconds(100.0f);
        return var3;
    }

    @Override
    public boolean canBeAffected(MobEffect var0) {
        if (var0.is(MobEffects.WITHER)) {
            return false;
        }
        return super.canBeAffected(var0);
    }
}

