/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.arrow;

import net.minecraft.core.particles.Particles;
import net.minecraft.core.particles.SpellParticleOption;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public class EntitySpectralArrow
extends EntityArrow {
    private static final int DEFAULT_DURATION = 200;
    public int duration = 200;

    public EntitySpectralArrow(EntityTypes<? extends EntitySpectralArrow> var0, World var1) {
        super((EntityTypes<? extends EntityArrow>)var0, var1);
    }

    public EntitySpectralArrow(World var0, EntityLiving var1, ItemStack var2, @Nullable ItemStack var3) {
        super(EntityTypes.SPECTRAL_ARROW, var1, var0, var2, var3);
    }

    public EntitySpectralArrow(World var0, double var1, double var3, double var5, ItemStack var7, @Nullable ItemStack var8) {
        super(EntityTypes.SPECTRAL_ARROW, var1, var3, var5, var0, var7, var8);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide() && !this.isInGround()) {
            this.level().addParticle(SpellParticleOption.create(Particles.EFFECT, -1, 1.0f), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void doPostHurtEffects(EntityLiving var0) {
        super.doPostHurtEffects(var0);
        MobEffect var1 = new MobEffect(MobEffects.GLOWING, this.duration, 0);
        var0.addEffect(var1, this.getEffectSource());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.duration = var0.getIntOr("Duration", 200);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("Duration", this.duration);
    }

    @Override
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack(Items.SPECTRAL_ARROW);
    }
}

