/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public interface ContainerEntity
extends IInventory,
ITileInventory {
    public Vec3D position();

    public AxisAlignedBB getBoundingBox();

    public @Nullable ResourceKey<LootTable> getContainerLootTable();

    public void setContainerLootTable(@Nullable ResourceKey<LootTable> var1);

    public long getContainerLootTableSeed();

    public void setContainerLootTableSeed(long var1);

    public NonNullList<ItemStack> getItemStacks();

    public void clearItemStacks();

    public World level();

    public boolean isRemoved();

    @Override
    default public boolean isEmpty() {
        return this.isChestVehicleEmpty();
    }

    default public void addChestVehicleSaveData(ValueOutput var0) {
        if (this.getContainerLootTable() != null) {
            var0.putString("LootTable", this.getContainerLootTable().identifier().toString());
            if (this.getContainerLootTableSeed() != 0L) {
                var0.putLong("LootTableSeed", this.getContainerLootTableSeed());
            }
        } else {
            ContainerUtil.saveAllItems(var0, this.getItemStacks());
        }
    }

    default public void readChestVehicleSaveData(ValueInput var0) {
        this.clearItemStacks();
        ResourceKey var1 = var0.read("LootTable", LootTable.KEY_CODEC).orElse(null);
        this.setContainerLootTable(var1);
        this.setContainerLootTableSeed(var0.getLongOr("LootTableSeed", 0L));
        if (var1 == null) {
            ContainerUtil.loadAllItems(var0, this.getItemStacks());
        }
    }

    default public void chestVehicleDestroyed(DamageSource var0, WorldServer var1, Entity var2) {
        if (!var1.getGameRules().get(GameRules.ENTITY_DROPS).booleanValue()) {
            return;
        }
        InventoryUtils.dropContents((World)var1, var2, (IInventory)this);
        Entity var3 = var0.getDirectEntity();
        if (var3 != null && var3.getType() == EntityTypes.PLAYER) {
            PiglinAI.angerNearbyPiglins(var1, (EntityHuman)var3, true);
        }
    }

    default public EnumInteractionResult interactWithContainerVehicle(EntityHuman var0) {
        var0.openMenu(this);
        return EnumInteractionResult.SUCCESS;
    }

    default public void unpackChestVehicleLootTable(@Nullable EntityHuman var0) {
        MinecraftServer var1 = this.level().getServer();
        if (this.getContainerLootTable() != null && var1 != null) {
            LootTable var2 = var1.reloadableRegistries().getLootTable(this.getContainerLootTable());
            if (var0 != null) {
                CriterionTriggers.GENERATE_LOOT.trigger((EntityPlayer)var0, this.getContainerLootTable());
            }
            this.setContainerLootTable(null);
            LootParams.a var3 = new LootParams.a((WorldServer)this.level()).withParameter(LootContextParameters.ORIGIN, this.position());
            if (var0 != null) {
                var3.withLuck(var0.getLuck()).withParameter(LootContextParameters.THIS_ENTITY, var0);
            }
            var2.fill(this, var3.create(LootContextParameterSets.CHEST), this.getContainerLootTableSeed());
        }
    }

    default public void clearChestVehicleContent() {
        this.unpackChestVehicleLootTable(null);
        this.getItemStacks().clear();
    }

    default public boolean isChestVehicleEmpty() {
        for (ItemStack var1 : this.getItemStacks()) {
            if (var1.isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack removeChestVehicleItemNoUpdate(int var0) {
        this.unpackChestVehicleLootTable(null);
        ItemStack var1 = this.getItemStacks().get(var0);
        if (var1.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.getItemStacks().set(var0, ItemStack.EMPTY);
        return var1;
    }

    default public ItemStack getChestVehicleItem(int var0) {
        this.unpackChestVehicleLootTable(null);
        return this.getItemStacks().get(var0);
    }

    default public ItemStack removeChestVehicleItem(int var0, int var1) {
        this.unpackChestVehicleLootTable(null);
        return ContainerUtil.removeItem(this.getItemStacks(), var0, var1);
    }

    default public void setChestVehicleItem(int var0, ItemStack var1) {
        this.unpackChestVehicleLootTable(null);
        this.getItemStacks().set(var0, var1);
        var1.limitSize(this.getMaxStackSize(var1));
    }

    default public @Nullable SlotAccess getChestVehicleSlot(final int var0) {
        if (var0 >= 0 && var0 < this.getContainerSize()) {
            return new SlotAccess(){

                @Override
                public ItemStack get() {
                    return ContainerEntity.this.getChestVehicleItem(var0);
                }

                @Override
                public boolean set(ItemStack var02) {
                    ContainerEntity.this.setChestVehicleItem(var0, var02);
                    return true;
                }
            };
        }
        return null;
    }

    default public boolean isChestVehicleStillValid(EntityHuman var0) {
        return !this.isRemoved() && var0.isWithinEntityInteractionRange(this.getBoundingBox(), 4.0);
    }
}

