/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.IInventory;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractMountInventoryMenu
extends Container {
    protected final IInventory mountContainer;
    protected final EntityLiving mount;
    protected final int SLOT_SADDLE = 0;
    protected final int SLOT_BODY_ARMOR = 1;
    protected final int SLOT_INVENTORY_START = 2;
    protected static final int INVENTORY_ROWS = 3;

    protected AbstractMountInventoryMenu(int var0, PlayerInventory var1, IInventory var2, EntityLiving var3) {
        super(null, var0);
        this.mountContainer = var2;
        this.mount = var3;
        var2.startOpen(var1.player);
    }

    protected abstract boolean hasInventoryChanged(IInventory var1);

    @Override
    public boolean stillValid(EntityHuman var0) {
        return !this.hasInventoryChanged(this.mountContainer) && this.mountContainer.stillValid(var0) && this.mount.isAlive() && var0.isWithinEntityInteractionRange(this.mount, 4.0);
    }

    @Override
    public void removed(EntityHuman var0) {
        super.removed(var0);
        this.mountContainer.stopOpen(var0);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            int var5 = 2 + this.mountContainer.getContainerSize();
            if (var1 < var5) {
                if (!this.moveItemStackTo(var4, var5, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(1).mayPlace(var4) && !this.getSlot(1).hasItem()) {
                if (!this.moveItemStackTo(var4, 1, 2, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(0).mayPlace(var4) && !this.getSlot(0).hasItem()) {
                if (!this.moveItemStackTo(var4, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.mountContainer.getContainerSize() == 0 || !this.moveItemStackTo(var4, 2, var5, false)) {
                int var6;
                int var7 = var6 = var5 + 27;
                int var8 = var7 + 9;
                if (var1 >= var7 && var1 < var8 ? !this.moveItemStackTo(var4, var5, var6, false) : (var1 >= var5 && var1 < var6 ? !this.moveItemStackTo(var4, var7, var8, false) : !this.moveItemStackTo(var4, var7, var6, false))) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.setByPlayer(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
        }
        return var2;
    }

    public static int getInventorySize(int var0) {
        return var0 * 3;
    }
}

