/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.HashedStack;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.RemoteSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class Container {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int SLOT_CLICKED_OUTSIDE = -999;
    public static final int QUICKCRAFT_TYPE_CHARITABLE = 0;
    public static final int QUICKCRAFT_TYPE_GREEDY = 1;
    public static final int QUICKCRAFT_TYPE_CLONE = 2;
    public static final int QUICKCRAFT_HEADER_START = 0;
    public static final int QUICKCRAFT_HEADER_CONTINUE = 1;
    public static final int QUICKCRAFT_HEADER_END = 2;
    public static final int CARRIED_SLOT_SIZE = Integer.MAX_VALUE;
    public static final int SLOTS_PER_ROW = 9;
    public static final int SLOT_SIZE = 18;
    public NonNullList<ItemStack> lastSlots = NonNullList.create();
    public NonNullList<Slot> slots = NonNullList.create();
    private final List<ContainerProperty> dataSlots = Lists.newArrayList();
    private ItemStack carried = ItemStack.EMPTY;
    public NonNullList<RemoteSlot> remoteSlots = NonNullList.create();
    private final IntList remoteDataSlots = new IntArrayList();
    private RemoteSlot remoteCarried = RemoteSlot.PLACEHOLDER;
    private int stateId;
    private final @Nullable Containers<?> menuType;
    public final int containerId;
    private int quickcraftType = -1;
    public int quickcraftStatus;
    private final Set<Slot> quickcraftSlots = Sets.newHashSet();
    private final List<ICrafting> containerListeners = Lists.newArrayList();
    private @Nullable ContainerSynchronizer synchronizer;
    private boolean suppressRemoteUpdates;

    protected Container(@Nullable Containers<?> var0, int var1) {
        this.menuType = var0;
        this.containerId = var1;
    }

    protected void addInventoryHotbarSlots(IInventory var0, int var1, int var2) {
        for (int var3 = 0; var3 < 9; ++var3) {
            this.addSlot(new Slot(var0, var3, var1 + var3 * 18, var2));
        }
    }

    protected void addInventoryExtendedSlots(IInventory var0, int var1, int var2) {
        for (int var3 = 0; var3 < 3; ++var3) {
            for (int var4 = 0; var4 < 9; ++var4) {
                this.addSlot(new Slot(var0, var4 + (var3 + 1) * 9, var1 + var4 * 18, var2 + var3 * 18));
            }
        }
    }

    protected void addStandardInventorySlots(IInventory var0, int var1, int var2) {
        this.addInventoryExtendedSlots(var0, var1, var2);
        int var3 = 4;
        int var4 = 58;
        this.addInventoryHotbarSlots(var0, var1, var2 + 58);
    }

    protected static boolean stillValid(ContainerAccess var0, EntityHuman var1, Block var22) {
        return var0.evaluate((var2, var3) -> {
            if (!var2.getBlockState((BlockPosition)var3).is(var22)) {
                return false;
            }
            return var1.isWithinBlockInteractionRange((BlockPosition)var3, 4.0);
        }, true);
    }

    public Containers<?> getType() {
        if (this.menuType == null) {
            throw new UnsupportedOperationException("Unable to construct this menu by type");
        }
        return this.menuType;
    }

    protected static void checkContainerSize(IInventory var0, int var1) {
        int var2 = var0.getContainerSize();
        if (var2 < var1) {
            throw new IllegalArgumentException("Container size " + var2 + " is smaller than expected " + var1);
        }
    }

    protected static void checkContainerDataCount(IContainerProperties var0, int var1) {
        int var2 = var0.getCount();
        if (var2 < var1) {
            throw new IllegalArgumentException("Container data count " + var2 + " is smaller than expected " + var1);
        }
    }

    public boolean isValidSlotIndex(int var0) {
        return var0 == -1 || var0 == -999 || var0 < this.slots.size();
    }

    protected Slot addSlot(Slot var0) {
        var0.index = this.slots.size();
        this.slots.add(var0);
        this.lastSlots.add(ItemStack.EMPTY);
        this.remoteSlots.add(this.synchronizer != null ? this.synchronizer.createSlot() : RemoteSlot.PLACEHOLDER);
        return var0;
    }

    protected ContainerProperty addDataSlot(ContainerProperty var0) {
        this.dataSlots.add(var0);
        this.remoteDataSlots.add(0);
        return var0;
    }

    protected void addDataSlots(IContainerProperties var0) {
        for (int var1 = 0; var1 < var0.getCount(); ++var1) {
            this.addDataSlot(ContainerProperty.forContainer(var0, var1));
        }
    }

    public void addSlotListener(ICrafting var0) {
        if (this.containerListeners.contains(var0)) {
            return;
        }
        this.containerListeners.add(var0);
        this.broadcastChanges();
    }

    public void setSynchronizer(ContainerSynchronizer var0) {
        this.synchronizer = var0;
        this.remoteCarried = var0.createSlot();
        this.remoteSlots.replaceAll(var1 -> var0.createSlot());
        this.sendAllDataToRemote();
    }

    public void sendAllDataToRemote() {
        ArrayList<ItemStack> var0 = new ArrayList<ItemStack>(this.slots.size());
        int var2 = this.slots.size();
        for (int var1 = 0; var1 < var2; ++var1) {
            ItemStack var3 = this.slots.get(var1).getItem();
            var0.add(var3.copy());
            this.remoteSlots.get(var1).force(var3);
        }
        ItemStack var1 = this.getCarried();
        this.remoteCarried.force(var1);
        int var3 = this.dataSlots.size();
        for (var2 = 0; var2 < var3; ++var2) {
            this.remoteDataSlots.set(var2, this.dataSlots.get(var2).get());
        }
        if (this.synchronizer != null) {
            this.synchronizer.sendInitialData(this, var0, var1.copy(), this.remoteDataSlots.toIntArray());
        }
    }

    public void removeSlotListener(ICrafting var0) {
        this.containerListeners.remove(var0);
    }

    public NonNullList<ItemStack> getItems() {
        NonNullList<ItemStack> var0 = NonNullList.create();
        for (Slot var2 : this.slots) {
            var0.add(var2.getItem());
        }
        return var0;
    }

    public void broadcastChanges() {
        Object var1;
        int var0;
        for (var0 = 0; var0 < this.slots.size(); ++var0) {
            var1 = this.slots.get(var0).getItem();
            com.google.common.base.Supplier var2 = Suppliers.memoize(((ItemStack)var1)::copy);
            this.triggerSlotListeners(var0, (ItemStack)var1, (Supplier<ItemStack>)var2);
            this.synchronizeSlotToRemote(var0, (ItemStack)var1, (Supplier<ItemStack>)var2);
        }
        this.synchronizeCarriedToRemote();
        for (var0 = 0; var0 < this.dataSlots.size(); ++var0) {
            var1 = this.dataSlots.get(var0);
            int var2 = ((ContainerProperty)var1).get();
            if (((ContainerProperty)var1).checkAndClearUpdateFlag()) {
                this.updateDataSlotListeners(var0, var2);
            }
            this.synchronizeDataSlotToRemote(var0, var2);
        }
    }

    public void broadcastFullState() {
        Object var1;
        int var0;
        for (var0 = 0; var0 < this.slots.size(); ++var0) {
            var1 = this.slots.get(var0).getItem();
            this.triggerSlotListeners(var0, (ItemStack)var1, ((ItemStack)var1)::copy);
        }
        for (var0 = 0; var0 < this.dataSlots.size(); ++var0) {
            var1 = this.dataSlots.get(var0);
            if (!((ContainerProperty)var1).checkAndClearUpdateFlag()) continue;
            this.updateDataSlotListeners(var0, ((ContainerProperty)var1).get());
        }
        this.sendAllDataToRemote();
    }

    private void updateDataSlotListeners(int var0, int var1) {
        for (ICrafting var3 : this.containerListeners) {
            var3.dataChanged(this, var0, var1);
        }
    }

    private void triggerSlotListeners(int var0, ItemStack var1, Supplier<ItemStack> var2) {
        ItemStack var3 = this.lastSlots.get(var0);
        if (!ItemStack.matches(var3, var1)) {
            ItemStack var4 = var2.get();
            this.lastSlots.set(var0, var4);
            for (ICrafting var6 : this.containerListeners) {
                var6.slotChanged(this, var0, var4);
            }
        }
    }

    private void synchronizeSlotToRemote(int var0, ItemStack var1, Supplier<ItemStack> var2) {
        if (this.suppressRemoteUpdates) {
            return;
        }
        RemoteSlot var3 = this.remoteSlots.get(var0);
        if (!var3.matches(var1)) {
            var3.force(var1);
            if (this.synchronizer != null) {
                this.synchronizer.sendSlotChange(this, var0, var2.get());
            }
        }
    }

    private void synchronizeDataSlotToRemote(int var0, int var1) {
        if (this.suppressRemoteUpdates) {
            return;
        }
        int var2 = this.remoteDataSlots.getInt(var0);
        if (var2 != var1) {
            this.remoteDataSlots.set(var0, var1);
            if (this.synchronizer != null) {
                this.synchronizer.sendDataChange(this, var0, var1);
            }
        }
    }

    private void synchronizeCarriedToRemote() {
        if (this.suppressRemoteUpdates) {
            return;
        }
        ItemStack var0 = this.getCarried();
        if (!this.remoteCarried.matches(var0)) {
            this.remoteCarried.force(var0);
            if (this.synchronizer != null) {
                this.synchronizer.sendCarriedChange(this, var0.copy());
            }
        }
    }

    public void setRemoteSlot(int var0, ItemStack var1) {
        this.remoteSlots.get(var0).force(var1);
    }

    public void setRemoteSlotUnsafe(int var0, HashedStack var1) {
        if (var0 < 0 || var0 >= this.remoteSlots.size()) {
            LOGGER.debug("Incorrect slot index: {} available slots: {}", (Object)var0, (Object)this.remoteSlots.size());
            return;
        }
        this.remoteSlots.get(var0).receive(var1);
    }

    public void setRemoteCarried(HashedStack var0) {
        this.remoteCarried.receive(var0);
    }

    public boolean clickMenuButton(EntityHuman var0, int var1) {
        return false;
    }

    public Slot getSlot(int var0) {
        return this.slots.get(var0);
    }

    public abstract ItemStack quickMoveStack(EntityHuman var1, int var2);

    public void setSelectedBundleItemIndex(int var0, int var1) {
        if (var0 >= 0 && var0 < this.slots.size()) {
            ItemStack var2 = this.slots.get(var0).getItem();
            BundleItem.toggleSelectedItem(var2, var1);
        }
    }

    public void clicked(int var0, int var1, InventoryClickType var2, EntityHuman var3) {
        try {
            this.doClick(var0, var1, var2, var3);
        }
        catch (Exception var4) {
            CrashReport var5 = CrashReport.forThrowable(var4, "Container click");
            CrashReportSystemDetails var6 = var5.addCategory("Click info");
            var6.setDetail("Menu Type", () -> this.menuType != null ? BuiltInRegistries.MENU.getKey(this.menuType).toString() : "<no type>");
            var6.setDetail("Menu Class", () -> this.getClass().getCanonicalName());
            var6.setDetail("Slot Count", this.slots.size());
            var6.setDetail("Slot", var0);
            var6.setDetail("Button", var1);
            var6.setDetail("Type", (Object)var2);
            throw new ReportedException(var5);
        }
    }

    private void doClick(int var0, int var1, InventoryClickType var22, EntityHuman var32) {
        block40: {
            block52: {
                int var6;
                block51: {
                    block47: {
                        ItemStack var7;
                        Slot var62;
                        ItemStack var5;
                        PlayerInventory var4;
                        block50: {
                            block49: {
                                block48: {
                                    block45: {
                                        ClickAction var52;
                                        block46: {
                                            block44: {
                                                block38: {
                                                    block43: {
                                                        ItemStack var72;
                                                        block42: {
                                                            block41: {
                                                                block39: {
                                                                    var4 = var32.getInventory();
                                                                    if (var22 != InventoryClickType.QUICK_CRAFT) break block38;
                                                                    int var53 = this.quickcraftStatus;
                                                                    this.quickcraftStatus = Container.getQuickcraftHeader(var1);
                                                                    if (var53 == 1 && this.quickcraftStatus == 2 || var53 == this.quickcraftStatus) break block39;
                                                                    this.resetQuickCraft();
                                                                    break block40;
                                                                }
                                                                if (!this.getCarried().isEmpty()) break block41;
                                                                this.resetQuickCraft();
                                                                break block40;
                                                            }
                                                            if (this.quickcraftStatus != 0) break block42;
                                                            this.quickcraftType = Container.getQuickcraftType(var1);
                                                            if (Container.isValidQuickcraftType(this.quickcraftType, var32)) {
                                                                this.quickcraftStatus = 1;
                                                                this.quickcraftSlots.clear();
                                                            } else {
                                                                this.resetQuickCraft();
                                                            }
                                                            break block40;
                                                        }
                                                        if (this.quickcraftStatus != 1) break block43;
                                                        Slot var63 = this.slots.get(var0);
                                                        if (!Container.canItemQuickReplace(var63, var72 = this.getCarried(), true) || !var63.mayPlace(var72) || this.quickcraftType != 2 && var72.getCount() <= this.quickcraftSlots.size() || !this.canDragTo(var63)) break block40;
                                                        this.quickcraftSlots.add(var63);
                                                        break block40;
                                                    }
                                                    if (this.quickcraftStatus == 2) {
                                                        if (!this.quickcraftSlots.isEmpty()) {
                                                            if (this.quickcraftSlots.size() == 1) {
                                                                int var64 = this.quickcraftSlots.iterator().next().index;
                                                                this.resetQuickCraft();
                                                                this.doClick(var64, this.quickcraftType, InventoryClickType.PICKUP, var32);
                                                                return;
                                                            }
                                                            ItemStack var65 = this.getCarried().copy();
                                                            if (var65.isEmpty()) {
                                                                this.resetQuickCraft();
                                                                return;
                                                            }
                                                            int var73 = this.getCarried().getCount();
                                                            for (Slot var9 : this.quickcraftSlots) {
                                                                ItemStack var10 = this.getCarried();
                                                                if (var9 == null || !Container.canItemQuickReplace(var9, var10, true) || !var9.mayPlace(var10) || this.quickcraftType != 2 && var10.getCount() < this.quickcraftSlots.size() || !this.canDragTo(var9)) continue;
                                                                int var11 = var9.hasItem() ? var9.getItem().getCount() : 0;
                                                                int var12 = Math.min(var65.getMaxStackSize(), var9.getMaxStackSize(var65));
                                                                int var13 = Math.min(Container.getQuickCraftPlaceCount(this.quickcraftSlots, this.quickcraftType, var65) + var11, var12);
                                                                var73 -= var13 - var11;
                                                                var9.setByPlayer(var65.copyWithCount(var13));
                                                            }
                                                            var65.setCount(var73);
                                                            this.setCarried(var65);
                                                        }
                                                        this.resetQuickCraft();
                                                    } else {
                                                        this.resetQuickCraft();
                                                    }
                                                    break block40;
                                                }
                                                if (this.quickcraftStatus == 0) break block44;
                                                this.resetQuickCraft();
                                                break block40;
                                            }
                                            if (var22 != InventoryClickType.PICKUP && var22 != InventoryClickType.QUICK_MOVE || var1 != 0 && var1 != 1) break block45;
                                            ClickAction clickAction = var52 = var1 == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
                                            if (var0 != -999) break block46;
                                            if (this.getCarried().isEmpty()) break block40;
                                            if (var52 == ClickAction.PRIMARY) {
                                                var32.drop(this.getCarried(), true);
                                                this.setCarried(ItemStack.EMPTY);
                                            } else {
                                                var32.drop(this.getCarried().split(1), true);
                                            }
                                            break block40;
                                        }
                                        if (var22 == InventoryClickType.QUICK_MOVE) {
                                            if (var0 < 0) {
                                                return;
                                            }
                                            Slot var66 = this.slots.get(var0);
                                            if (!var66.mayPickup(var32)) {
                                                return;
                                            }
                                            ItemStack var74 = this.quickMoveStack(var32, var0);
                                            while (!var74.isEmpty() && ItemStack.isSameItem(var66.getItem(), var74)) {
                                                var74 = this.quickMoveStack(var32, var0);
                                            }
                                        } else {
                                            if (var0 < 0) {
                                                return;
                                            }
                                            Slot var67 = this.slots.get(var0);
                                            ItemStack var75 = var67.getItem();
                                            ItemStack var8 = this.getCarried();
                                            var32.updateTutorialInventoryAction(var8, var67.getItem(), var52);
                                            if (!this.tryItemClickBehaviourOverride(var32, var52, var67, var75, var8)) {
                                                if (var75.isEmpty()) {
                                                    if (!var8.isEmpty()) {
                                                        int var9 = var52 == ClickAction.PRIMARY ? var8.getCount() : 1;
                                                        this.setCarried(var67.safeInsert(var8, var9));
                                                    }
                                                } else if (var67.mayPickup(var32)) {
                                                    if (var8.isEmpty()) {
                                                        int var9 = var52 == ClickAction.PRIMARY ? var75.getCount() : (var75.getCount() + 1) / 2;
                                                        Optional<ItemStack> var10 = var67.tryRemove(var9, Integer.MAX_VALUE, var32);
                                                        var10.ifPresent(var2 -> {
                                                            this.setCarried((ItemStack)var2);
                                                            var67.onTake(var32, (ItemStack)var2);
                                                        });
                                                    } else if (var67.mayPlace(var8)) {
                                                        if (ItemStack.isSameItemSameComponents(var75, var8)) {
                                                            int var9 = var52 == ClickAction.PRIMARY ? var8.getCount() : 1;
                                                            this.setCarried(var67.safeInsert(var8, var9));
                                                        } else if (var8.getCount() <= var67.getMaxStackSize(var8)) {
                                                            this.setCarried(var75);
                                                            var67.setByPlayer(var8);
                                                        }
                                                    } else if (ItemStack.isSameItemSameComponents(var75, var8)) {
                                                        Optional<ItemStack> var9 = var67.tryRemove(var75.getCount(), var8.getMaxStackSize() - var8.getCount(), var32);
                                                        var9.ifPresent(var3 -> {
                                                            var8.grow(var3.getCount());
                                                            var67.onTake(var32, (ItemStack)var3);
                                                        });
                                                    }
                                                }
                                            }
                                            var67.setChanged();
                                        }
                                        break block40;
                                    }
                                    if (var22 != InventoryClickType.SWAP || (var1 < 0 || var1 >= 9) && var1 != 40) break block47;
                                    var5 = var4.getItem(var1);
                                    var62 = this.slots.get(var0);
                                    var7 = var62.getItem();
                                    if (var5.isEmpty() && var7.isEmpty()) break block40;
                                    if (!var5.isEmpty()) break block48;
                                    if (!var62.mayPickup(var32)) break block40;
                                    var4.setItem(var1, var7);
                                    var62.onSwapCraft(var7.getCount());
                                    var62.setByPlayer(ItemStack.EMPTY);
                                    var62.onTake(var32, var7);
                                    break block40;
                                }
                                if (!var7.isEmpty()) break block49;
                                if (!var62.mayPlace(var5)) break block40;
                                int var8 = var62.getMaxStackSize(var5);
                                if (var5.getCount() > var8) {
                                    var62.setByPlayer(var5.split(var8));
                                } else {
                                    var4.setItem(var1, ItemStack.EMPTY);
                                    var62.setByPlayer(var5);
                                }
                                break block40;
                            }
                            if (!var62.mayPickup(var32) || !var62.mayPlace(var5)) break block40;
                            int var8 = var62.getMaxStackSize(var5);
                            if (var5.getCount() <= var8) break block50;
                            var62.setByPlayer(var5.split(var8));
                            var62.onTake(var32, var7);
                            if (var4.add(var7)) break block40;
                            var32.drop(var7, true);
                            break block40;
                        }
                        var4.setItem(var1, var7);
                        var62.setByPlayer(var5);
                        var62.onTake(var32, var7);
                        break block40;
                    }
                    if (var22 != InventoryClickType.CLONE || !var32.hasInfiniteMaterials() || !this.getCarried().isEmpty() || var0 < 0) break block51;
                    Slot var5 = this.slots.get(var0);
                    if (!var5.hasItem()) break block40;
                    ItemStack var68 = var5.getItem();
                    this.setCarried(var68.copyWithCount(var68.getMaxStackSize()));
                    break block40;
                }
                if (var22 != InventoryClickType.THROW || !this.getCarried().isEmpty() || var0 < 0) break block52;
                Slot var5 = this.slots.get(var0);
                int n2 = var6 = var1 == 0 ? 1 : var5.getItem().getCount();
                if (!var32.canDropItems()) {
                    return;
                }
                ItemStack var7 = var5.safeTake(var6, Integer.MAX_VALUE, var32);
                var32.drop(var7, true);
                var32.handleCreativeModeItemDrop(var7);
                if (var1 != 1) break block40;
                while (!var7.isEmpty() && ItemStack.isSameItem(var5.getItem(), var7)) {
                    if (!var32.canDropItems()) {
                        return;
                    }
                    var7 = var5.safeTake(var6, Integer.MAX_VALUE, var32);
                    var32.drop(var7, true);
                    var32.handleCreativeModeItemDrop(var7);
                }
                break block40;
            }
            if (var22 == InventoryClickType.PICKUP_ALL && var0 >= 0) {
                Slot var5 = this.slots.get(var0);
                ItemStack var6 = this.getCarried();
                if (!(var6.isEmpty() || var5.hasItem() && var5.mayPickup(var32))) {
                    int var7 = var1 == 0 ? 0 : this.slots.size() - 1;
                    int var8 = var1 == 0 ? 1 : -1;
                    for (int var9 = 0; var9 < 2; ++var9) {
                        for (int var10 = var7; var10 >= 0 && var10 < this.slots.size() && var6.getCount() < var6.getMaxStackSize(); var10 += var8) {
                            Slot var11 = this.slots.get(var10);
                            if (!var11.hasItem() || !Container.canItemQuickReplace(var11, var6, true) || !var11.mayPickup(var32) || !this.canTakeItemForPickAll(var6, var11)) continue;
                            ItemStack var12 = var11.getItem();
                            if (var9 == 0 && var12.getCount() == var12.getMaxStackSize()) continue;
                            ItemStack var13 = var11.safeTake(var12.getCount(), var6.getMaxStackSize() - var6.getCount(), var32);
                            var6.grow(var13.getCount());
                        }
                    }
                }
            }
        }
    }

    private boolean tryItemClickBehaviourOverride(EntityHuman var0, ClickAction var1, Slot var2, ItemStack var3, ItemStack var4) {
        FeatureFlagSet var5 = var0.level().enabledFeatures();
        if (var4.isItemEnabled(var5) && var4.overrideStackedOnOther(var2, var1, var0)) {
            return true;
        }
        return var3.isItemEnabled(var5) && var3.overrideOtherStackedOnMe(var4, var2, var1, var0, this.createCarriedSlotAccess());
    }

    private SlotAccess createCarriedSlotAccess() {
        return new SlotAccess(){

            @Override
            public ItemStack get() {
                return Container.this.getCarried();
            }

            @Override
            public boolean set(ItemStack var0) {
                Container.this.setCarried(var0);
                return true;
            }
        };
    }

    public boolean canTakeItemForPickAll(ItemStack var0, Slot var1) {
        return true;
    }

    public void removed(EntityHuman var0) {
        if (!(var0 instanceof EntityPlayer)) {
            return;
        }
        ItemStack var1 = this.getCarried();
        if (!var1.isEmpty()) {
            Container.dropOrPlaceInInventory(var0, var1);
            this.setCarried(ItemStack.EMPTY);
        }
    }

    private static void dropOrPlaceInInventory(EntityHuman var0, ItemStack var1) {
        EntityPlayer var4;
        boolean var3;
        boolean var2 = var0.isRemoved() && var0.getRemovalReason() != Entity.RemovalReason.CHANGED_DIMENSION;
        boolean bl = var3 = var0 instanceof EntityPlayer && (var4 = (EntityPlayer)var0).hasDisconnected();
        if (var2 || var3) {
            var0.drop(var1, false);
        } else if (var0 instanceof EntityPlayer) {
            var0.getInventory().placeItemBackInInventory(var1);
        }
    }

    protected void clearContainer(EntityHuman var0, IInventory var1) {
        for (int var2 = 0; var2 < var1.getContainerSize(); ++var2) {
            Container.dropOrPlaceInInventory(var0, var1.removeItemNoUpdate(var2));
        }
    }

    public void slotsChanged(IInventory var0) {
        this.broadcastChanges();
    }

    public void setItem(int var0, int var1, ItemStack var2) {
        this.getSlot(var0).set(var2);
        this.stateId = var1;
    }

    public void initializeContents(int var0, List<ItemStack> var1, ItemStack var2) {
        for (int var3 = 0; var3 < var1.size(); ++var3) {
            this.getSlot(var3).set(var1.get(var3));
        }
        this.carried = var2;
        this.stateId = var0;
    }

    public void setData(int var0, int var1) {
        this.dataSlots.get(var0).set(var1);
    }

    public abstract boolean stillValid(EntityHuman var1);

    protected boolean moveItemStackTo(ItemStack var0, int var1, int var2, boolean var3) {
        int var8;
        ItemStack var7;
        Slot var6;
        boolean var4 = false;
        int var5 = var1;
        if (var3) {
            var5 = var2 - 1;
        }
        if (var0.isStackable()) {
            while (!var0.isEmpty() && (var3 ? var5 >= var1 : var5 < var2)) {
                var6 = this.slots.get(var5);
                var7 = var6.getItem();
                if (!var7.isEmpty() && ItemStack.isSameItemSameComponents(var0, var7)) {
                    int var9;
                    var8 = var7.getCount() + var0.getCount();
                    if (var8 <= (var9 = var6.getMaxStackSize(var7))) {
                        var0.setCount(0);
                        var7.setCount(var8);
                        var6.setChanged();
                        var4 = true;
                    } else if (var7.getCount() < var9) {
                        var0.shrink(var9 - var7.getCount());
                        var7.setCount(var9);
                        var6.setChanged();
                        var4 = true;
                    }
                }
                if (var3) {
                    --var5;
                    continue;
                }
                ++var5;
            }
        }
        if (!var0.isEmpty()) {
            var5 = var3 ? var2 - 1 : var1;
            while (var3 ? var5 >= var1 : var5 < var2) {
                var6 = this.slots.get(var5);
                var7 = var6.getItem();
                if (var7.isEmpty() && var6.mayPlace(var0)) {
                    var8 = var6.getMaxStackSize(var0);
                    var6.setByPlayer(var0.split(Math.min(var0.getCount(), var8)));
                    var6.setChanged();
                    var4 = true;
                    break;
                }
                if (var3) {
                    --var5;
                    continue;
                }
                ++var5;
            }
        }
        return var4;
    }

    public static int getQuickcraftType(int var0) {
        return var0 >> 2 & 3;
    }

    public static int getQuickcraftHeader(int var0) {
        return var0 & 3;
    }

    public static int getQuickcraftMask(int var0, int var1) {
        return var0 & 3 | (var1 & 3) << 2;
    }

    public static boolean isValidQuickcraftType(int var0, EntityHuman var1) {
        if (var0 == 0) {
            return true;
        }
        if (var0 == 1) {
            return true;
        }
        return var0 == 2 && var1.hasInfiniteMaterials();
    }

    protected void resetQuickCraft() {
        this.quickcraftStatus = 0;
        this.quickcraftSlots.clear();
    }

    public static boolean canItemQuickReplace(@Nullable Slot var0, ItemStack var1, boolean var2) {
        boolean var3;
        boolean bl = var3 = var0 == null || !var0.hasItem();
        if (!var3 && ItemStack.isSameItemSameComponents(var1, var0.getItem())) {
            return var0.getItem().getCount() + (var2 ? 0 : var1.getCount()) <= var1.getMaxStackSize();
        }
        return var3;
    }

    public static int getQuickCraftPlaceCount(Set<Slot> var0, int var1, ItemStack var2) {
        return switch (var1) {
            case 0 -> MathHelper.floor((float)var2.getCount() / (float)var0.size());
            case 1 -> 1;
            case 2 -> var2.getMaxStackSize();
            default -> var2.getCount();
        };
    }

    public boolean canDragTo(Slot var0) {
        return true;
    }

    public static int getRedstoneSignalFromBlockEntity(@Nullable TileEntity var0) {
        if (var0 instanceof IInventory) {
            return Container.getRedstoneSignalFromContainer((IInventory)((Object)var0));
        }
        return 0;
    }

    public static int getRedstoneSignalFromContainer(@Nullable IInventory var0) {
        if (var0 == null) {
            return 0;
        }
        float var1 = 0.0f;
        for (int var2 = 0; var2 < var0.getContainerSize(); ++var2) {
            ItemStack var3 = var0.getItem(var2);
            if (var3.isEmpty()) continue;
            var1 += (float)var3.getCount() / (float)var0.getMaxStackSize(var3);
        }
        return MathHelper.lerpDiscrete(var1 /= (float)var0.getContainerSize(), 0, 15);
    }

    public void setCarried(ItemStack var0) {
        this.carried = var0;
    }

    public ItemStack getCarried() {
        return this.carried;
    }

    public void suppressRemoteUpdates() {
        this.suppressRemoteUpdates = true;
    }

    public void resumeRemoteUpdates() {
        this.suppressRemoteUpdates = false;
    }

    public void transferState(Container var0) {
        Slot var3;
        int var2;
        HashBasedTable var1 = HashBasedTable.create();
        for (var2 = 0; var2 < var0.slots.size(); ++var2) {
            var3 = var0.slots.get(var2);
            var1.put((Object)var3.container, (Object)var3.getContainerSlot(), (Object)var2);
        }
        for (var2 = 0; var2 < this.slots.size(); ++var2) {
            var3 = this.slots.get(var2);
            Integer var4 = (Integer)var1.get((Object)var3.container, (Object)var3.getContainerSlot());
            if (var4 == null) continue;
            this.lastSlots.set(var2, var0.lastSlots.get(var4));
            RemoteSlot var5 = var0.remoteSlots.get(var4);
            RemoteSlot var6 = this.remoteSlots.get(var2);
            if (!(var5 instanceof RemoteSlot.a)) continue;
            RemoteSlot.a var7 = (RemoteSlot.a)var5;
            if (!(var6 instanceof RemoteSlot.a)) continue;
            RemoteSlot.a var8 = (RemoteSlot.a)var6;
            var8.copyFrom(var7);
        }
    }

    public OptionalInt findSlot(IInventory var0, int var1) {
        for (int var2 = 0; var2 < this.slots.size(); ++var2) {
            Slot var3 = this.slots.get(var2);
            if (var3.container != var0 || var1 != var3.getContainerSlot()) continue;
            return OptionalInt.of(var2);
        }
        return OptionalInt.empty();
    }

    public int getStateId() {
        return this.stateId;
    }

    public int incrementStateId() {
        this.stateId = this.stateId + 1 & Short.MAX_VALUE;
        return this.stateId;
    }
}

