/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvilAbstract;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class ContainerSmithing
extends ContainerAnvilAbstract {
    public static final int TEMPLATE_SLOT = 0;
    public static final int BASE_SLOT = 1;
    public static final int ADDITIONAL_SLOT = 2;
    public static final int RESULT_SLOT = 3;
    public static final int TEMPLATE_SLOT_X_PLACEMENT = 8;
    public static final int BASE_SLOT_X_PLACEMENT = 26;
    public static final int ADDITIONAL_SLOT_X_PLACEMENT = 44;
    private static final int RESULT_SLOT_X_PLACEMENT = 98;
    public static final int SLOT_Y_PLACEMENT = 48;
    private final World level;
    private final RecipePropertySet baseItemTest;
    private final RecipePropertySet templateItemTest;
    private final RecipePropertySet additionItemTest;
    private final ContainerProperty hasRecipeError = ContainerProperty.standalone();

    public ContainerSmithing(int var0, PlayerInventory var1) {
        this(var0, var1, ContainerAccess.NULL);
    }

    public ContainerSmithing(int var0, PlayerInventory var1, ContainerAccess var2) {
        this(var0, var1, var2, var1.player.level());
    }

    private ContainerSmithing(int var0, PlayerInventory var1, ContainerAccess var2, World var3) {
        super(Containers.SMITHING, var0, var1, var2, ContainerSmithing.createInputSlotDefinitions(var3.recipeAccess()));
        this.level = var3;
        this.baseItemTest = var3.recipeAccess().propertySet(RecipePropertySet.SMITHING_BASE);
        this.templateItemTest = var3.recipeAccess().propertySet(RecipePropertySet.SMITHING_TEMPLATE);
        this.additionItemTest = var3.recipeAccess().propertySet(RecipePropertySet.SMITHING_ADDITION);
        this.addDataSlot(this.hasRecipeError).set(0);
    }

    private static ItemCombinerMenuSlotDefinition createInputSlotDefinitions(RecipeAccess var0) {
        RecipePropertySet var1 = var0.propertySet(RecipePropertySet.SMITHING_BASE);
        RecipePropertySet var2 = var0.propertySet(RecipePropertySet.SMITHING_TEMPLATE);
        RecipePropertySet var3 = var0.propertySet(RecipePropertySet.SMITHING_ADDITION);
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 8, 48, var2::test).withSlot(1, 26, 48, var1::test).withSlot(2, 44, 48, var3::test).withResultSlot(3, 98, 48).build();
    }

    @Override
    protected boolean isValidBlock(IBlockData var0) {
        return var0.is(Blocks.SMITHING_TABLE);
    }

    @Override
    protected void onTake(EntityHuman var02, ItemStack var12) {
        var12.onCraftedBy(var02, var12.getCount());
        this.resultSlots.awardUsedRecipes(var02, this.getRelevantItems());
        this.shrinkStackInSlot(0);
        this.shrinkStackInSlot(1);
        this.shrinkStackInSlot(2);
        this.access.execute((var0, var1) -> var0.levelEvent(1044, (BlockPosition)var1, 0));
    }

    private List<ItemStack> getRelevantItems() {
        return List.of(this.inputSlots.getItem(0), this.inputSlots.getItem(1), this.inputSlots.getItem(2));
    }

    private SmithingRecipeInput createRecipeInput() {
        return new SmithingRecipeInput(this.inputSlots.getItem(0), this.inputSlots.getItem(1), this.inputSlots.getItem(2));
    }

    private void shrinkStackInSlot(int var0) {
        ItemStack var1 = this.inputSlots.getItem(var0);
        if (!var1.isEmpty()) {
            var1.shrink(1);
            this.inputSlots.setItem(var0, var1);
        }
    }

    @Override
    public void slotsChanged(IInventory var0) {
        super.slotsChanged(var0);
        if (this.level instanceof WorldServer) {
            boolean var1 = this.getSlot(0).hasItem() && this.getSlot(1).hasItem() && this.getSlot(2).hasItem() && !this.getSlot(this.getResultSlot()).hasItem();
            this.hasRecipeError.set(var1 ? 1 : 0);
        }
    }

    @Override
    public void createResult() {
        Optional<RecipeHolder<Object>> var12;
        SmithingRecipeInput var0 = this.createRecipeInput();
        World world = this.level;
        if (world instanceof WorldServer) {
            WorldServer var2 = (WorldServer)world;
            var12 = var2.recipeAccess().getRecipeFor(Recipes.SMITHING, var0, var2);
        } else {
            var12 = Optional.empty();
        }
        var12.ifPresentOrElse(var1 -> {
            ItemStack var2 = ((SmithingRecipe)var1.value()).assemble(var0, this.level.registryAccess());
            this.resultSlots.setRecipeUsed((RecipeHolder<?>)var1);
            this.resultSlots.setItem(0, var2);
        }, () -> {
            this.resultSlots.setRecipeUsed(null);
            this.resultSlots.setItem(0, ItemStack.EMPTY);
        });
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack var0, Slot var1) {
        return var1.container != this.resultSlots && super.canTakeItemForPickAll(var0, var1);
    }

    @Override
    public boolean canMoveIntoInputSlots(ItemStack var0) {
        if (this.templateItemTest.test(var0) && !this.getSlot(0).hasItem()) {
            return true;
        }
        if (this.baseItemTest.test(var0) && !this.getSlot(1).hasItem()) {
            return true;
        }
        return this.additionItemTest.test(var0) && !this.getSlot(2).hasItem();
    }

    public boolean hasRecipeError() {
        return this.hasRecipeError.get() > 0;
    }
}

