/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.INamable;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.inventory.SlotRange;
import org.jspecify.annotations.Nullable;

public class SlotRanges {
    private static final List<SlotRange> SLOTS = SystemUtils.make(new ArrayList(), var0 -> {
        SlotRanges.addSingleSlot(var0, "contents", 0);
        SlotRanges.addSlotRange(var0, "container.", 0, 54);
        SlotRanges.addSlotRange(var0, "hotbar.", 0, 9);
        SlotRanges.addSlotRange(var0, "inventory.", 9, 27);
        SlotRanges.addSlotRange(var0, "enderchest.", 200, 27);
        SlotRanges.addSlotRange(var0, "villager.", 300, 8);
        SlotRanges.addSlotRange(var0, "horse.", 500, 15);
        int var1 = EnumItemSlot.MAINHAND.getIndex(98);
        int var2 = EnumItemSlot.OFFHAND.getIndex(98);
        SlotRanges.addSingleSlot(var0, "weapon", var1);
        SlotRanges.addSingleSlot(var0, "weapon.mainhand", var1);
        SlotRanges.addSingleSlot(var0, "weapon.offhand", var2);
        SlotRanges.addSlots(var0, "weapon.*", var1, var2);
        var1 = EnumItemSlot.HEAD.getIndex(100);
        var2 = EnumItemSlot.CHEST.getIndex(100);
        int var3 = EnumItemSlot.LEGS.getIndex(100);
        int var4 = EnumItemSlot.FEET.getIndex(100);
        int var5 = EnumItemSlot.BODY.getIndex(105);
        SlotRanges.addSingleSlot(var0, "armor.head", var1);
        SlotRanges.addSingleSlot(var0, "armor.chest", var2);
        SlotRanges.addSingleSlot(var0, "armor.legs", var3);
        SlotRanges.addSingleSlot(var0, "armor.feet", var4);
        SlotRanges.addSingleSlot(var0, "armor.body", var5);
        SlotRanges.addSlots(var0, "armor.*", var1, var2, var3, var4, var5);
        SlotRanges.addSingleSlot(var0, "saddle", EnumItemSlot.SADDLE.getIndex(106));
        SlotRanges.addSingleSlot(var0, "horse.chest", 499);
        SlotRanges.addSingleSlot(var0, "player.cursor", 499);
        SlotRanges.addSlotRange(var0, "player.crafting.", 500, 4);
    });
    public static final Codec<SlotRange> CODEC = INamable.fromValues(() -> (SlotRange[])SLOTS.toArray(SlotRange[]::new));
    private static final Function<String, @Nullable SlotRange> NAME_LOOKUP = INamable.createNameLookup((INamable[])((SlotRange[])SLOTS.toArray(SlotRange[]::new)));

    private static SlotRange create(String var0, int var1) {
        return SlotRange.of(var0, IntLists.singleton((int)var1));
    }

    private static SlotRange create(String var0, IntList var1) {
        return SlotRange.of(var0, IntLists.unmodifiable((IntList)var1));
    }

    private static SlotRange create(String var0, int ... var1) {
        return SlotRange.of(var0, IntList.of((int[])var1));
    }

    private static void addSingleSlot(List<SlotRange> var0, String var1, int var2) {
        var0.add(SlotRanges.create(var1, var2));
    }

    private static void addSlotRange(List<SlotRange> var0, String var1, int var2, int var3) {
        IntArrayList var4 = new IntArrayList(var3);
        for (int var5 = 0; var5 < var3; ++var5) {
            int var6 = var2 + var5;
            var0.add(SlotRanges.create(var1 + var5, var6));
            var4.add(var6);
        }
        var0.add(SlotRanges.create(var1 + "*", (IntList)var4));
    }

    private static void addSlots(List<SlotRange> var0, String var1, int ... var2) {
        var0.add(SlotRanges.create(var1, var2));
    }

    public static @Nullable SlotRange nameToIds(String var0) {
        return NAME_LOOKUP.apply(var0);
    }

    public static Stream<String> allNames() {
        return SLOTS.stream().map(INamable::getSerializedName);
    }

    public static Stream<String> singleSlotNames() {
        return SLOTS.stream().filter(var0 -> var0.size() == 1).map(INamable::getSerializedName);
    }
}

