/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Iterator;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.minecart.EntityMinecartAbstract;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;

public class ItemMinecart
extends Item {
    private final EntityTypes<? extends EntityMinecartAbstract> type;

    public ItemMinecart(EntityTypes<? extends EntityMinecartAbstract> var0, Item.Info var1) {
        super(var1);
        this.type = var0;
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        Object var10;
        BlockPosition var2;
        World var1 = var0.getLevel();
        IBlockData var3 = var1.getBlockState(var2 = var0.getClickedPos());
        if (!var3.is(TagsBlock.RAILS)) {
            return EnumInteractionResult.FAIL;
        }
        ItemStack var4 = var0.getItemInHand();
        BlockPropertyTrackPosition var5 = var3.getBlock() instanceof BlockMinecartTrackAbstract ? var3.getValue(((BlockMinecartTrackAbstract)var3.getBlock()).getShapeProperty()) : BlockPropertyTrackPosition.NORTH_SOUTH;
        double var6 = 0.0;
        if (var5.isSlope()) {
            var6 = 0.5;
        }
        Vec3D var8 = new Vec3D((double)var2.getX() + 0.5, (double)var2.getY() + 0.0625 + var6, (double)var2.getZ() + 0.5);
        EntityMinecartAbstract var9 = EntityMinecartAbstract.createMinecart(var1, var8.x, var8.y, var8.z, this.type, EntitySpawnReason.DISPENSER, var4, var0.getPlayer());
        if (var9 == null) {
            return EnumInteractionResult.FAIL;
        }
        if (EntityMinecartAbstract.useExperimentalMovement(var1)) {
            var10 = var1.getEntities(null, var9.getBoundingBox());
            Iterator iterator = var10.iterator();
            while (iterator.hasNext()) {
                Entity var12 = (Entity)iterator.next();
                if (!(var12 instanceof EntityMinecartAbstract)) continue;
                return EnumInteractionResult.FAIL;
            }
        }
        if (var1 instanceof WorldServer) {
            var10 = (WorldServer)var1;
            ((WorldServer)var10).addFreshEntity(var9);
            var10.gameEvent(GameEvent.ENTITY_PLACE, var2, GameEvent.a.of(var0.getPlayer(), ((World)var10).getBlockState(var2.below())));
        }
        var4.shrink(1);
        return EnumInteractionResult.SUCCESS;
    }
}

