/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;

public class PotionRegistry
implements FeatureElement {
    public static final Codec<Holder<PotionRegistry>> CODEC = BuiltInRegistries.POTION.holderByNameCodec();
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<PotionRegistry>> STREAM_CODEC = ByteBufCodecs.holderRegistry(Registries.POTION);
    private final String name;
    private final List<MobEffect> effects;
    private FeatureFlagSet requiredFeatures = FeatureFlags.VANILLA_SET;

    public PotionRegistry(String var0, MobEffect ... var1) {
        this.name = var0;
        this.effects = List.of(var1);
    }

    public PotionRegistry requiredFeatures(FeatureFlag ... var0) {
        this.requiredFeatures = FeatureFlags.REGISTRY.subset(var0);
        return this;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.requiredFeatures;
    }

    public List<MobEffect> getEffects() {
        return this.effects;
    }

    public String name() {
        return this.name;
    }

    public boolean hasInstantEffects() {
        for (MobEffect var1 : this.effects) {
            if (!var1.getEffect().value().isInstantenous()) continue;
            return true;
        }
        return false;
    }
}

