/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.item.consume_effects.PlaySoundConsumeEffect;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;

public record Consumable(float consumeSeconds, ItemUseAnimation animation, Holder<SoundEffect> sound, boolean hasConsumeParticles, List<ConsumeEffect> onConsumeEffects) {
    public static final float DEFAULT_CONSUME_SECONDS = 1.6f;
    private static final int CONSUME_EFFECTS_INTERVAL = 4;
    private static final float CONSUME_EFFECTS_START_FRACTION = 0.21875f;
    public static final Codec<Consumable> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.NON_NEGATIVE_FLOAT.optionalFieldOf("consume_seconds", (Object)Float.valueOf(1.6f)).forGetter(Consumable::consumeSeconds), (App)ItemUseAnimation.CODEC.optionalFieldOf("animation", (Object)ItemUseAnimation.EAT).forGetter(Consumable::animation), (App)SoundEffect.CODEC.optionalFieldOf("sound", SoundEffects.GENERIC_EAT).forGetter(Consumable::sound), (App)Codec.BOOL.optionalFieldOf("has_consume_particles", (Object)true).forGetter(Consumable::hasConsumeParticles), (App)ConsumeEffect.CODEC.listOf().optionalFieldOf("on_consume_effects", List.of()).forGetter(Consumable::onConsumeEffects)).apply((Applicative)var0, Consumable::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Consumable> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.FLOAT, Consumable::consumeSeconds, ItemUseAnimation.STREAM_CODEC, Consumable::animation, SoundEffect.STREAM_CODEC, Consumable::sound, ByteBufCodecs.BOOL, Consumable::hasConsumeParticles, ConsumeEffect.STREAM_CODEC.apply(ByteBufCodecs.list()), Consumable::onConsumeEffects, Consumable::new);

    public EnumInteractionResult startConsuming(EntityLiving var0, ItemStack var1, EnumHand var2) {
        boolean var3;
        if (!this.canConsume(var0, var1)) {
            return EnumInteractionResult.FAIL;
        }
        boolean bl = var3 = this.consumeTicks() > 0;
        if (var3) {
            var0.startUsingItem(var2);
            return EnumInteractionResult.CONSUME;
        }
        ItemStack var4 = this.onConsume(var0.level(), var0, var1);
        return EnumInteractionResult.CONSUME.heldItemTransformedTo(var4);
    }

    public ItemStack onConsume(World var0, EntityLiving var1, ItemStack var2) {
        RandomSource var32 = var1.getRandom();
        this.emitParticlesAndSounds(var32, var1, var2, 16);
        if (var1 instanceof EntityPlayer) {
            EntityPlayer var4 = (EntityPlayer)var1;
            var4.awardStat(StatisticList.ITEM_USED.get(var2.getItem()));
            CriterionTriggers.CONSUME_ITEM.trigger(var4, var2);
        }
        var2.getAllOfType(ConsumableListener.class).forEach(var3 -> var3.onConsume(var0, var1, var2, this));
        if (!var0.isClientSide()) {
            this.onConsumeEffects.forEach(var3 -> var3.apply(var0, var2, var1));
        }
        var1.gameEvent(this.animation == ItemUseAnimation.DRINK ? GameEvent.DRINK : GameEvent.EAT);
        var2.consume(1, var1);
        return var2;
    }

    public boolean canConsume(EntityLiving var0, ItemStack var1) {
        FoodInfo var2 = var1.get(DataComponents.FOOD);
        if (var2 != null && var0 instanceof EntityHuman) {
            EntityHuman var3 = (EntityHuman)var0;
            return var3.canEat(var2.canAlwaysEat());
        }
        return true;
    }

    public int consumeTicks() {
        return (int)(this.consumeSeconds * 20.0f);
    }

    public void emitParticlesAndSounds(RandomSource var0, EntityLiving var1, ItemStack var2, int var3) {
        SoundEffect soundEffect;
        float var9;
        float var4 = var0.nextBoolean() ? 0.5f : 1.0f;
        float var5 = var0.triangle(1.0f, 0.2f);
        float var6 = 0.5f;
        float var7 = MathHelper.randomBetween(var0, 0.9f, 1.0f);
        float var8 = this.animation == ItemUseAnimation.DRINK ? 0.5f : var4;
        float f2 = var9 = this.animation == ItemUseAnimation.DRINK ? var7 : var5;
        if (this.hasConsumeParticles) {
            var1.spawnItemParticles(var2, var3);
        }
        if (var1 instanceof b) {
            b var11 = (b)((Object)var1);
            soundEffect = var11.getConsumeSound(var2);
        } else {
            soundEffect = this.sound.value();
        }
        SoundEffect var10 = soundEffect;
        var1.playSound(var10, var8, var9);
    }

    public boolean shouldEmitParticlesAndSounds(int var0) {
        int var2;
        int var1 = this.consumeTicks() - var0;
        boolean var3 = var1 > (var2 = (int)((float)this.consumeTicks() * 0.21875f));
        return var3 && var0 % 4 == 0;
    }

    public static a builder() {
        return new a();
    }

    public static interface b {
        public SoundEffect getConsumeSound(ItemStack var1);
    }

    public static class a {
        private float consumeSeconds = 1.6f;
        private ItemUseAnimation animation = ItemUseAnimation.EAT;
        private Holder<SoundEffect> sound = SoundEffects.GENERIC_EAT;
        private boolean hasConsumeParticles = true;
        private final List<ConsumeEffect> onConsumeEffects = new ArrayList<ConsumeEffect>();

        a() {
        }

        public a consumeSeconds(float var0) {
            this.consumeSeconds = var0;
            return this;
        }

        public a animation(ItemUseAnimation var0) {
            this.animation = var0;
            return this;
        }

        public a sound(Holder<SoundEffect> var0) {
            this.sound = var0;
            return this;
        }

        public a soundAfterConsume(Holder<SoundEffect> var0) {
            return this.onConsume(new PlaySoundConsumeEffect(var0));
        }

        public a hasConsumeParticles(boolean var0) {
            this.hasConsumeParticles = var0;
            return this;
        }

        public a onConsume(ConsumeEffect var0) {
            this.onConsumeEffects.add(var0);
            return this;
        }

        public Consumable build() {
            return new Consumable(this.consumeSeconds, this.animation, this.sound, this.hasConsumeParticles, this.onConsumeEffects);
        }
    }
}

