/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.component.AttackRange;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.phys.MovingObjectPositionEntity;

public record PiercingWeapon(boolean dealsKnockback, boolean dismounts, Optional<Holder<SoundEffect>> sound, Optional<Holder<SoundEffect>> hitSound) {
    public static final Codec<PiercingWeapon> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.BOOL.optionalFieldOf("deals_knockback", (Object)true).forGetter(PiercingWeapon::dealsKnockback), (App)Codec.BOOL.optionalFieldOf("dismounts", (Object)false).forGetter(PiercingWeapon::dismounts), (App)SoundEffect.CODEC.optionalFieldOf("sound").forGetter(PiercingWeapon::sound), (App)SoundEffect.CODEC.optionalFieldOf("hit_sound").forGetter(PiercingWeapon::hitSound)).apply((Applicative)var0, PiercingWeapon::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PiercingWeapon> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.BOOL, PiercingWeapon::dealsKnockback, ByteBufCodecs.BOOL, PiercingWeapon::dismounts, SoundEffect.STREAM_CODEC.apply(ByteBufCodecs::optional), PiercingWeapon::sound, SoundEffect.STREAM_CODEC.apply(ByteBufCodecs::optional), PiercingWeapon::hitSound, PiercingWeapon::new);

    public void makeSound(Entity var0) {
        this.sound.ifPresent(var1 -> var0.level().playSound(var0, var0.getX(), var0.getY(), var0.getZ(), (Holder<SoundEffect>)var1, var0.getSoundSource(), 1.0f, 1.0f));
    }

    public void makeHitSound(Entity var0) {
        this.hitSound.ifPresent(var1 -> var0.level().playSound(null, var0.getX(), var0.getY(), var0.getZ(), (Holder<SoundEffect>)var1, var0.getSoundSource(), 1.0f, 1.0f));
    }

    public static boolean canHitEntity(Entity var0, Entity var1) {
        if (var1.isInvulnerable() || !var1.isAlive()) {
            return false;
        }
        if (var1 instanceof Interaction) {
            return true;
        }
        if (!var1.canBeHitByProjectile()) {
            return false;
        }
        if (var1 instanceof EntityHuman) {
            EntityHuman var3;
            EntityHuman var2 = (EntityHuman)var1;
            if (var0 instanceof EntityHuman && !(var3 = (EntityHuman)var0).canHarmPlayer(var2)) {
                return false;
            }
        }
        return !var0.isPassengerOfSameVehicle(var1);
    }

    public void attack(EntityLiving var02, EnumItemSlot var12) {
        float var2 = (float)var02.getAttributeValue(GenericAttributes.ATTACK_DAMAGE);
        AttackRange var3 = var02.entityAttackRange();
        boolean var4 = false;
        for (MovingObjectPositionEntity var6 : (Collection)ProjectileHelper.getHitEntitiesAlong(var02, var3, var1 -> PiercingWeapon.canHitEntity(var02, var1), RayTrace.BlockCollisionOption.COLLIDER).map(var0 -> List.of(), var0 -> var0)) {
            var4 |= var02.stabAttack(var12, var6.getEntity(), var2, true, this.dealsKnockback, this.dismounts);
        }
        var02.onAttack();
        var02.lungeForwardMaybe();
        if (var4) {
            this.makeHitSound(var02);
        }
        this.makeSound(var02);
        var02.swing(EnumHand.MAIN_HAND, false);
    }
}

