/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.World;

public record SuspiciousStewEffects(List<a> effects) implements ConsumableListener,
TooltipProvider
{
    public static final SuspiciousStewEffects EMPTY = new SuspiciousStewEffects(List.of());
    public static final int DEFAULT_DURATION = 160;
    public static final Codec<SuspiciousStewEffects> CODEC = a.CODEC.listOf().xmap(SuspiciousStewEffects::new, SuspiciousStewEffects::effects);
    public static final StreamCodec<RegistryFriendlyByteBuf, SuspiciousStewEffects> STREAM_CODEC = a.STREAM_CODEC.apply(ByteBufCodecs.list()).map(SuspiciousStewEffects::new, SuspiciousStewEffects::effects);

    public SuspiciousStewEffects withEffectAdded(a var0) {
        return new SuspiciousStewEffects(SystemUtils.copyAndAdd(this.effects, var0));
    }

    @Override
    public void onConsume(World var0, EntityLiving var1, ItemStack var2, Consumable var3) {
        for (a var5 : this.effects) {
            var1.addEffect(var5.createEffectInstance());
        }
    }

    @Override
    public void addToTooltip(Item.b var0, Consumer<IChatBaseComponent> var1, TooltipFlag var2, DataComponentGetter var3) {
        if (var2.isCreative()) {
            ArrayList<MobEffect> var4 = new ArrayList<MobEffect>();
            for (a var6 : this.effects) {
                var4.add(var6.createEffectInstance());
            }
            PotionContents.addPotionTooltip(var4, var1, 1.0f, var0.tickRate());
        }
    }

    public record a(Holder<MobEffectList> effect, int duration) {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)MobEffectList.CODEC.fieldOf("id").forGetter(a::effect), (App)Codec.INT.lenientOptionalFieldOf("duration", (Object)160).forGetter(a::duration)).apply((Applicative)var0, a::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, a> STREAM_CODEC = StreamCodec.composite(MobEffectList.STREAM_CODEC, a::effect, ByteBufCodecs.VAR_INT, a::duration, a::new);

        public MobEffect createEffectInstance() {
            return new MobEffect(this.effect, this.duration);
        }
    }
}

