/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import org.jspecify.annotations.Nullable;

public class RecipeCache {
    private final @Nullable a[] entries;
    private WeakReference<@Nullable CraftingManager> cachedRecipeManager = new WeakReference<Object>(null);

    public RecipeCache(int var0) {
        this.entries = new a[var0];
    }

    public Optional<RecipeHolder<RecipeCrafting>> get(WorldServer var0, CraftingInput var1) {
        if (var1.isEmpty()) {
            return Optional.empty();
        }
        this.validateRecipeManager(var0);
        for (int var2 = 0; var2 < this.entries.length; ++var2) {
            a var3 = this.entries[var2];
            if (var3 == null || !var3.matches(var1)) continue;
            this.moveEntryToFront(var2);
            return Optional.ofNullable(var3.value());
        }
        return this.compute(var1, var0);
    }

    private void validateRecipeManager(WorldServer var0) {
        CraftingManager var1 = var0.recipeAccess();
        if (var1 != this.cachedRecipeManager.get()) {
            this.cachedRecipeManager = new WeakReference<CraftingManager>(var1);
            Arrays.fill(this.entries, null);
        }
    }

    private Optional<RecipeHolder<RecipeCrafting>> compute(CraftingInput var0, WorldServer var1) {
        Optional<RecipeHolder<RecipeCrafting>> var2 = var1.recipeAccess().getRecipeFor(Recipes.CRAFTING, var0, var1);
        this.insert(var0, var2.orElse(null));
        return var2;
    }

    private void moveEntryToFront(int var0) {
        if (var0 > 0) {
            a var1 = this.entries[var0];
            System.arraycopy(this.entries, 0, this.entries, 1, var0);
            this.entries[0] = var1;
        }
    }

    private void insert(CraftingInput var0, @Nullable RecipeHolder<RecipeCrafting> var1) {
        NonNullList<ItemStack> var2 = NonNullList.withSize(var0.size(), ItemStack.EMPTY);
        for (int var3 = 0; var3 < var0.size(); ++var3) {
            var2.set(var3, var0.getItem(var3).copyWithCount(1));
        }
        System.arraycopy(this.entries, 0, this.entries, 1, this.entries.length - 1);
        this.entries[0] = new a(var2, var0.width(), var0.height(), var1);
    }

    record a(NonNullList<ItemStack> key, int width, int height, @Nullable RecipeHolder<RecipeCrafting> value) {
        public boolean matches(CraftingInput var0) {
            if (this.width != var0.width() || this.height != var0.height()) {
                return false;
            }
            for (int var1 = 0; var1 < this.key.size(); ++var1) {
                if (ItemStack.isSameItemSameComponents(this.key.get(var1), var0.getItem(var1))) continue;
                return false;
            }
            return true;
        }
    }
}

