/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.TransmuteResult;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SmithingRecipeDisplay;
import org.jspecify.annotations.Nullable;

public class SmithingTransformRecipe
implements SmithingRecipe {
    final Optional<RecipeItemStack> template;
    final RecipeItemStack base;
    final Optional<RecipeItemStack> addition;
    final TransmuteResult result;
    private @Nullable PlacementInfo placementInfo;

    public SmithingTransformRecipe(Optional<RecipeItemStack> var0, RecipeItemStack var1, Optional<RecipeItemStack> var2, TransmuteResult var3) {
        this.template = var0;
        this.base = var1;
        this.addition = var2;
        this.result = var3;
    }

    @Override
    public ItemStack assemble(SmithingRecipeInput var0, HolderLookup.a var1) {
        return this.result.apply(var0.base());
    }

    @Override
    public Optional<RecipeItemStack> templateIngredient() {
        return this.template;
    }

    @Override
    public RecipeItemStack baseIngredient() {
        return this.base;
    }

    @Override
    public Optional<RecipeItemStack> additionIngredient() {
        return this.addition;
    }

    @Override
    public RecipeSerializer<SmithingTransformRecipe> getSerializer() {
        return RecipeSerializer.SMITHING_TRANSFORM;
    }

    @Override
    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.createFromOptionals(List.of(this.template, Optional.of(this.base), this.addition));
        }
        return this.placementInfo;
    }

    @Override
    public List<RecipeDisplay> display() {
        return List.of(new SmithingRecipeDisplay(RecipeItemStack.optionalIngredientToDisplay(this.template), this.base.display(), RecipeItemStack.optionalIngredientToDisplay(this.addition), this.result.display(), new SlotDisplay.d(Items.SMITHING_TABLE)));
    }

    public static class a
    implements RecipeSerializer<SmithingTransformRecipe> {
        private static final MapCodec<SmithingTransformRecipe> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)RecipeItemStack.CODEC.optionalFieldOf("template").forGetter(var0 -> var0.template), (App)RecipeItemStack.CODEC.fieldOf("base").forGetter(var0 -> var0.base), (App)RecipeItemStack.CODEC.optionalFieldOf("addition").forGetter(var0 -> var0.addition), (App)TransmuteResult.CODEC.fieldOf("result").forGetter(var0 -> var0.result)).apply((Applicative)var02, SmithingTransformRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingTransformRecipe> STREAM_CODEC = StreamCodec.composite(RecipeItemStack.OPTIONAL_CONTENTS_STREAM_CODEC, var0 -> var0.template, RecipeItemStack.CONTENTS_STREAM_CODEC, var0 -> var0.base, RecipeItemStack.OPTIONAL_CONTENTS_STREAM_CODEC, var0 -> var0.addition, TransmuteResult.STREAM_CODEC, var0 -> var0.result, SmithingTransformRecipe::new);

        @Override
        public MapCodec<SmithingTransformRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, SmithingTransformRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

