/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public record ConditionalEffect<T>(T effect, Optional<LootItemCondition> requirements) {
    public static Codec<LootItemCondition> conditionCodec(ContextKeySet var0) {
        return LootItemCondition.DIRECT_CODEC.validate(var1 -> {
            ProblemReporter.a var2 = new ProblemReporter.a();
            LootCollector var3 = new LootCollector(var2, var0);
            var1.validate(var3);
            if (!var2.isEmpty()) {
                return DataResult.error(() -> "Validation error in enchantment effect condition: " + var2.getReport());
            }
            return DataResult.success((Object)var1);
        });
    }

    public static <T> Codec<ConditionalEffect<T>> codec(Codec<T> var0, ContextKeySet var1) {
        return RecordCodecBuilder.create(var2 -> var2.group((App)var0.fieldOf("effect").forGetter(ConditionalEffect::effect), (App)ConditionalEffect.conditionCodec(var1).optionalFieldOf("requirements").forGetter(ConditionalEffect::requirements)).apply((Applicative)var2, ConditionalEffect::new));
    }

    public boolean matches(LootTableInfo var0) {
        if (this.requirements.isEmpty()) {
            return true;
        }
        return this.requirements.get().test(var0);
    }
}

