/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jspecify.annotations.Nullable;

public class ItemEnchantments
implements TooltipProvider {
    public static final ItemEnchantments EMPTY = new ItemEnchantments((Object2IntOpenHashMap<Holder<Enchantment>>)new Object2IntOpenHashMap());
    private static final Codec<Integer> LEVEL_CODEC = Codec.intRange((int)1, (int)255);
    public static final Codec<ItemEnchantments> CODEC = Codec.unboundedMap(Enchantment.CODEC, LEVEL_CODEC).xmap(var0 -> new ItemEnchantments((Object2IntOpenHashMap<Holder<Enchantment>>)new Object2IntOpenHashMap(var0)), var0 -> var0.enchantments);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemEnchantments> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.map(Object2IntOpenHashMap::new, Enchantment.STREAM_CODEC, ByteBufCodecs.VAR_INT), var0 -> var0.enchantments, ItemEnchantments::new);
    final Object2IntOpenHashMap<Holder<Enchantment>> enchantments;

    ItemEnchantments(Object2IntOpenHashMap<Holder<Enchantment>> var0) {
        this.enchantments = var0;
        for (Object2IntMap.Entry var2 : var0.object2IntEntrySet()) {
            int var3 = var2.getIntValue();
            if (var3 >= 0 && var3 <= 255) continue;
            throw new IllegalArgumentException("Enchantment " + String.valueOf(var2.getKey()) + " has invalid level " + var3);
        }
    }

    public int getLevel(Holder<Enchantment> var0) {
        return this.enchantments.getInt(var0);
    }

    @Override
    public void addToTooltip(Item.b var0, Consumer<IChatBaseComponent> var1, TooltipFlag var2, DataComponentGetter var3) {
        HolderLookup.a var4 = var0.registries();
        HolderSet<Enchantment> var5 = ItemEnchantments.getTagOrEmpty(var4, Registries.ENCHANTMENT, EnchantmentTags.TOOLTIP_ORDER);
        for (Holder holder : var5) {
            int var8 = this.enchantments.getInt((Object)holder);
            if (var8 <= 0) continue;
            var1.accept(Enchantment.getFullname(holder, var8));
        }
        for (Object2IntMap.Entry entry : this.enchantments.object2IntEntrySet()) {
            Holder var8 = (Holder)entry.getKey();
            if (var5.contains(var8)) continue;
            var1.accept(Enchantment.getFullname((Holder)entry.getKey(), entry.getIntValue()));
        }
    }

    private static <T> HolderSet<T> getTagOrEmpty(@Nullable HolderLookup.a var0, ResourceKey<IRegistry<T>> var1, TagKey<T> var2) {
        Optional<HolderSet.Named<T>> var3;
        if (var0 != null && (var3 = var0.lookupOrThrow(var1).get(var2)).isPresent()) {
            return var3.get();
        }
        return HolderSet.direct(new Holder[0]);
    }

    public Set<Holder<Enchantment>> keySet() {
        return Collections.unmodifiableSet(this.enchantments.keySet());
    }

    public Set<Object2IntMap.Entry<Holder<Enchantment>>> entrySet() {
        return Collections.unmodifiableSet(this.enchantments.object2IntEntrySet());
    }

    public int size() {
        return this.enchantments.size();
    }

    public boolean isEmpty() {
        return this.enchantments.isEmpty();
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof ItemEnchantments) {
            ItemEnchantments var1 = (ItemEnchantments)var0;
            return this.enchantments.equals(var1.enchantments);
        }
        return false;
    }

    public int hashCode() {
        return this.enchantments.hashCode();
    }

    public String toString() {
        return "ItemEnchantments{enchantments=" + String.valueOf(this.enchantments) + "}";
    }

    public static class a {
        private final Object2IntOpenHashMap<Holder<Enchantment>> enchantments = new Object2IntOpenHashMap();

        public a(ItemEnchantments var0) {
            this.enchantments.putAll(var0.enchantments);
        }

        public void set(Holder<Enchantment> var0, int var1) {
            if (var1 <= 0) {
                this.enchantments.removeInt(var0);
            } else {
                this.enchantments.put(var0, Math.min(var1, 255));
            }
        }

        public void upgrade(Holder<Enchantment> var0, int var1) {
            if (var1 > 0) {
                this.enchantments.merge(var0, Math.min(var1, 255), Integer::max);
            }
        }

        public void removeIf(Predicate<Holder<Enchantment>> var0) {
            this.enchantments.keySet().removeIf(var0);
        }

        public int getLevel(Holder<Enchantment> var0) {
            return this.enchantments.getOrDefault(var0, 0);
        }

        public Set<Holder<Enchantment>> keySet() {
            return this.enchantments.keySet();
        }

        public ItemEnchantments toImmutable() {
            return new ItemEnchantments(this.enchantments);
        }
    }
}

