/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public record TargetedConditionalEffect<T>(EnchantmentTarget enchanted, EnchantmentTarget affected, T effect, Optional<LootItemCondition> requirements) {
    public static <S> Codec<TargetedConditionalEffect<S>> codec(Codec<S> var0, ContextKeySet var1) {
        return RecordCodecBuilder.create(var2 -> var2.group((App)EnchantmentTarget.CODEC.fieldOf("enchanted").forGetter(TargetedConditionalEffect::enchanted), (App)EnchantmentTarget.CODEC.fieldOf("affected").forGetter(TargetedConditionalEffect::affected), (App)var0.fieldOf("effect").forGetter(TargetedConditionalEffect::effect), (App)ConditionalEffect.conditionCodec(var1).optionalFieldOf("requirements").forGetter(TargetedConditionalEffect::requirements)).apply((Applicative)var2, TargetedConditionalEffect::new));
    }

    public static <S> Codec<TargetedConditionalEffect<S>> equipmentDropsCodec(Codec<S> var0, ContextKeySet var1) {
        return RecordCodecBuilder.create(var22 -> var22.group((App)EnchantmentTarget.CODEC.validate(var0 -> var0 != EnchantmentTarget.DAMAGING_ENTITY ? DataResult.success((Object)var0) : DataResult.error(() -> "enchanted must be attacker or victim")).fieldOf("enchanted").forGetter(TargetedConditionalEffect::enchanted), (App)var0.fieldOf("effect").forGetter(TargetedConditionalEffect::effect), (App)ConditionalEffect.conditionCodec(var1).optionalFieldOf("requirements").forGetter(TargetedConditionalEffect::requirements)).apply((Applicative)var22, (var0, var1, var2) -> new TargetedConditionalEffect<Object>((EnchantmentTarget)var0, EnchantmentTarget.VICTIM, var1, (Optional<LootItemCondition>)var2)));
    }

    public boolean matches(LootTableInfo var0) {
        if (this.requirements.isEmpty()) {
            return true;
        }
        return this.requirements.get().test(var0);
    }
}

