/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3D;

public record ApplyEntityImpulse(Vec3D direction, Vec3D coordinateScale, LevelBasedValue magnitude) implements EnchantmentEntityEffect
{
    public static final MapCodec<ApplyEntityImpulse> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Vec3D.CODEC.fieldOf("direction").forGetter(ApplyEntityImpulse::direction), (App)Vec3D.CODEC.fieldOf("coordinate_scale").forGetter(ApplyEntityImpulse::coordinateScale), (App)LevelBasedValue.CODEC.fieldOf("magnitude").forGetter(ApplyEntityImpulse::magnitude)).apply((Applicative)var0, ApplyEntityImpulse::new));
    private static final int POST_IMPULSE_CONTEXT_RESET_GRACE_TIME_TICKS = 10;

    @Override
    public void apply(WorldServer var0, int var1, EnchantedItemInUse var2, Entity var3, Vec3D var4) {
        Vec3D var5 = var3.getLookAngle();
        Vec3D var6 = var5.addLocalCoordinates(this.direction).multiply(this.coordinateScale).scale(this.magnitude.calculate(var1));
        var3.addDeltaMovement(var6);
        var3.hurtMarked = true;
        var3.needsSync = true;
        if (var3 instanceof EntityHuman) {
            EntityHuman var7 = (EntityHuman)var3;
            var7.applyPostImpulseGraceTime(10);
        }
    }

    public MapCodec<ApplyEntityImpulse> codec() {
        return CODEC;
    }
}

