/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;

public record RemoveBinomial(LevelBasedValue chance) implements EnchantmentValueEffect
{
    public static final MapCodec<RemoveBinomial> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)LevelBasedValue.CODEC.fieldOf("chance").forGetter(RemoveBinomial::chance)).apply((Applicative)var0, RemoveBinomial::new));

    @Override
    public float process(int var0, RandomSource var1, float var2) {
        float var3 = this.chance.calculate(var0);
        int var4 = 0;
        if (var2 <= 128.0f || var2 * var3 < 20.0f || var2 * (1.0f - var3) < 20.0f) {
            int var5 = 0;
            while ((float)var5 < var2) {
                if (var1.nextFloat() < var3) {
                    ++var4;
                }
                ++var5;
            }
        } else {
            double var5 = Math.floor(var2 * var3);
            double var7 = Math.sqrt(var2 * var3 * (1.0f - var3));
            var4 = (int)Math.round(var5 + var1.nextGaussian() * var7);
            var4 = Math.clamp((long)var4, 0, (int)var2);
        }
        return var2 - (float)var4;
    }

    public MapCodec<RemoveBinomial> codec() {
        return CODEC;
    }
}

