/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.UtilColor;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public abstract class CommandBlockListenerAbstract {
    private static final IChatBaseComponent DEFAULT_NAME = IChatBaseComponent.literal("@");
    private static final int NO_LAST_EXECUTION = -1;
    private long lastExecution = -1L;
    private boolean updateLastExecution = true;
    private int successCount;
    private boolean trackOutput = true;
    @Nullable IChatBaseComponent lastOutput;
    private String command = "";
    private @Nullable IChatBaseComponent customName;

    public int getSuccessCount() {
        return this.successCount;
    }

    public void setSuccessCount(int var0) {
        this.successCount = var0;
    }

    public IChatBaseComponent getLastOutput() {
        return this.lastOutput == null ? CommonComponents.EMPTY : this.lastOutput;
    }

    public void save(ValueOutput var0) {
        var0.putString("Command", this.command);
        var0.putInt("SuccessCount", this.successCount);
        var0.storeNullable("CustomName", ComponentSerialization.CODEC, this.customName);
        var0.putBoolean("TrackOutput", this.trackOutput);
        if (this.trackOutput) {
            var0.storeNullable("LastOutput", ComponentSerialization.CODEC, this.lastOutput);
        }
        var0.putBoolean("UpdateLastExecution", this.updateLastExecution);
        if (this.updateLastExecution && this.lastExecution != -1L) {
            var0.putLong("LastExecution", this.lastExecution);
        }
    }

    public void load(ValueInput var0) {
        this.command = var0.getStringOr("Command", "");
        this.successCount = var0.getIntOr("SuccessCount", 0);
        this.setCustomName(TileEntity.parseCustomNameSafe(var0, "CustomName"));
        this.trackOutput = var0.getBooleanOr("TrackOutput", true);
        this.lastOutput = this.trackOutput ? TileEntity.parseCustomNameSafe(var0, "LastOutput") : null;
        this.updateLastExecution = var0.getBooleanOr("UpdateLastExecution", true);
        this.lastExecution = this.updateLastExecution ? var0.getLongOr("LastExecution", -1L) : -1L;
    }

    public void setCommand(String var0) {
        this.command = var0;
        this.successCount = 0;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean performCommand(WorldServer var02) {
        if (var02.getGameTime() == this.lastExecution) {
            return false;
        }
        if ("Searge".equalsIgnoreCase(this.command)) {
            this.lastOutput = IChatBaseComponent.literal("#itzlipofutzli");
            this.successCount = 1;
            return true;
        }
        this.successCount = 0;
        if (var02.isCommandBlockEnabled() && !UtilColor.isNullOrEmpty(this.command)) {
            try {
                this.lastOutput = null;
                try (CloseableCommandBlockSource var12 = this.createSource(var02);){
                    ICommandListener var2 = Objects.requireNonNullElse(var12, ICommandListener.NULL);
                    CommandListenerWrapper var3 = this.createCommandSourceStack(var02, var2).withCallback((var0, var1) -> {
                        if (var0) {
                            ++this.successCount;
                        }
                    });
                    var02.getServer().getCommands().performPrefixedCommand(var3, this.command);
                }
            }
            catch (Throwable var13) {
                CrashReport var2 = CrashReport.forThrowable(var13, "Executing command block");
                CrashReportSystemDetails var3 = var2.addCategory("Command to be executed");
                var3.setDetail("Command", this::getCommand);
                var3.setDetail("Name", () -> this.getName().getString());
                throw new ReportedException(var2);
            }
        }
        this.lastExecution = this.updateLastExecution ? var02.getGameTime() : -1L;
        return true;
    }

    public @Nullable CloseableCommandBlockSource createSource(WorldServer var0) {
        return this.trackOutput ? new CloseableCommandBlockSource(var0) : null;
    }

    public IChatBaseComponent getName() {
        return this.customName != null ? this.customName : DEFAULT_NAME;
    }

    public @Nullable IChatBaseComponent getCustomName() {
        return this.customName;
    }

    public void setCustomName(@Nullable IChatBaseComponent var0) {
        this.customName = var0;
    }

    public abstract void onUpdated(WorldServer var1);

    public void setLastOutput(@Nullable IChatBaseComponent var0) {
        this.lastOutput = var0;
    }

    public void setTrackOutput(boolean var0) {
        this.trackOutput = var0;
    }

    public boolean isTrackOutput() {
        return this.trackOutput;
    }

    public abstract CommandListenerWrapper createCommandSourceStack(WorldServer var1, ICommandListener var2);

    public abstract boolean isValid();

    protected class CloseableCommandBlockSource
    implements ICommandListener,
    AutoCloseable {
        private final WorldServer level;
        private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ROOT);
        private boolean closed;

        protected CloseableCommandBlockSource(WorldServer var1) {
            this.level = var1;
        }

        @Override
        public boolean acceptsSuccess() {
            return !this.closed && this.level.getGameRules().get(GameRules.SEND_COMMAND_FEEDBACK) != false;
        }

        @Override
        public boolean acceptsFailure() {
            return !this.closed;
        }

        @Override
        public boolean shouldInformAdmins() {
            return !this.closed && this.level.getGameRules().get(GameRules.COMMAND_BLOCK_OUTPUT) != false;
        }

        @Override
        public void sendSystemMessage(IChatBaseComponent var0) {
            if (!this.closed) {
                CommandBlockListenerAbstract.this.lastOutput = IChatBaseComponent.literal("[" + TIME_FORMAT.format(ZonedDateTime.now()) + "] ").append(var0);
                CommandBlockListenerAbstract.this.onUpdated(this.level);
            }
        }

        @Override
        public void close() throws Exception {
            this.closed = true;
        }
    }
}

