/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.jspecify.annotations.Nullable;

public interface IEntityAccess {
    public List<Entity> getEntities(@Nullable Entity var1, AxisAlignedBB var2, Predicate<? super Entity> var3);

    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> var1, AxisAlignedBB var2, Predicate<? super T> var3);

    default public <T extends Entity> List<T> getEntitiesOfClass(Class<T> var0, AxisAlignedBB var1, Predicate<? super T> var2) {
        return this.getEntities(EntityTypeTest.forClass(var0), var1, var2);
    }

    public List<? extends EntityHuman> players();

    default public List<Entity> getEntities(@Nullable Entity var0, AxisAlignedBB var1) {
        return this.getEntities(var0, var1, IEntitySelector.NO_SPECTATORS);
    }

    default public boolean isUnobstructed(@Nullable Entity var0, VoxelShape var1) {
        if (var1.isEmpty()) {
            return true;
        }
        for (Entity var3 : this.getEntities(var0, var1.bounds())) {
            if (var3.isRemoved() || !var3.blocksBuilding || var0 != null && var3.isPassengerOfSameVehicle(var0) || !VoxelShapes.joinIsNotEmpty(var1, VoxelShapes.create(var3.getBoundingBox()), OperatorBoolean.AND)) continue;
            return false;
        }
        return true;
    }

    default public <T extends Entity> List<T> getEntitiesOfClass(Class<T> var0, AxisAlignedBB var1) {
        return this.getEntitiesOfClass(var0, var1, IEntitySelector.NO_SPECTATORS);
    }

    default public List<VoxelShape> getEntityCollisions(@Nullable Entity var0, AxisAlignedBB var1) {
        if (var1.getSize() < 1.0E-7) {
            return List.of();
        }
        Predicate<Entity> var2 = var0 == null ? IEntitySelector.CAN_BE_COLLIDED_WITH : IEntitySelector.NO_SPECTATORS.and(var0::canCollideWith);
        List<Entity> var3 = this.getEntities(var0, var1.inflate(1.0E-7), var2);
        if (var3.isEmpty()) {
            return List.of();
        }
        ImmutableList.Builder var4 = ImmutableList.builderWithExpectedSize((int)var3.size());
        for (Entity var6 : var3) {
            var4.add((Object)VoxelShapes.create(var6.getBoundingBox()));
        }
        return var4.build();
    }

    default public @Nullable EntityHuman getNearestPlayer(double var0, double var2, double var4, double var6, @Nullable Predicate<Entity> var8) {
        double var9 = -1.0;
        EntityHuman var11 = null;
        for (EntityHuman entityHuman : this.players()) {
            if (var8 != null && !var8.test(entityHuman)) continue;
            double var14 = entityHuman.distanceToSqr(var0, var2, var4);
            if (!(var6 < 0.0) && !(var14 < var6 * var6) || var9 != -1.0 && !(var14 < var9)) continue;
            var9 = var14;
            var11 = entityHuman;
        }
        return var11;
    }

    default public @Nullable EntityHuman getNearestPlayer(Entity var0, double var1) {
        return this.getNearestPlayer(var0.getX(), var0.getY(), var0.getZ(), var1, false);
    }

    default public @Nullable EntityHuman getNearestPlayer(double var0, double var2, double var4, double var6, boolean var8) {
        Predicate<Entity> var9 = var8 ? IEntitySelector.NO_CREATIVE_OR_SPECTATOR : IEntitySelector.NO_SPECTATORS;
        return this.getNearestPlayer(var0, var2, var4, var6, var9);
    }

    default public boolean hasNearbyAlivePlayer(double var0, double var2, double var4, double var6) {
        for (EntityHuman entityHuman : this.players()) {
            if (!IEntitySelector.NO_SPECTATORS.test(entityHuman) || !IEntitySelector.LIVING_ENTITY_STILL_ALIVE.test(entityHuman)) continue;
            double var10 = entityHuman.distanceToSqr(var0, var2, var4);
            if (!(var6 < 0.0) && !(var10 < var6 * var6)) continue;
            return true;
        }
        return false;
    }

    default public @Nullable EntityHuman getPlayerByUUID(UUID var0) {
        for (int var1 = 0; var1 < this.players().size(); ++var1) {
            EntityHuman var2 = this.players().get(var1);
            if (!var0.equals(var2.getUUID())) continue;
            return var2;
        }
        return null;
    }
}

