/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityProcessor;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class MobSpawnerAbstract {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String SPAWN_DATA_TAG = "SpawnData";
    private static final int EVENT_SPAWN = 1;
    private static final int DEFAULT_SPAWN_DELAY = 20;
    private static final int DEFAULT_MIN_SPAWN_DELAY = 200;
    private static final int DEFAULT_MAX_SPAWN_DELAY = 800;
    private static final int DEFAULT_SPAWN_COUNT = 4;
    private static final int DEFAULT_MAX_NEARBY_ENTITIES = 6;
    private static final int DEFAULT_REQUIRED_PLAYER_RANGE = 16;
    private static final int DEFAULT_SPAWN_RANGE = 4;
    public int spawnDelay = 20;
    public WeightedList<MobSpawnerData> spawnPotentials = WeightedList.of();
    public @Nullable MobSpawnerData nextSpawnData;
    private double spin;
    private double oSpin;
    public int minSpawnDelay = 200;
    public int maxSpawnDelay = 800;
    public int spawnCount = 4;
    private @Nullable Entity displayEntity;
    public int maxNearbyEntities = 6;
    public int requiredPlayerRange = 16;
    public int spawnRange = 4;

    public void setEntityId(EntityTypes<?> var0, @Nullable World var1, RandomSource var2, BlockPosition var3) {
        this.getOrCreateNextSpawnData(var1, var2, var3).getEntityToSpawn().putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(var0).toString());
    }

    private boolean isNearPlayer(World var0, BlockPosition var1) {
        return var0.hasNearbyAlivePlayer((double)var1.getX() + 0.5, (double)var1.getY() + 0.5, (double)var1.getZ() + 0.5, this.requiredPlayerRange);
    }

    public void clientTick(World var0, BlockPosition var1) {
        if (!this.isNearPlayer(var0, var1)) {
            this.oSpin = this.spin;
        } else if (this.displayEntity != null) {
            RandomSource var2 = var0.getRandom();
            double var3 = (double)var1.getX() + var2.nextDouble();
            double var5 = (double)var1.getY() + var2.nextDouble();
            double var7 = (double)var1.getZ() + var2.nextDouble();
            var0.addParticle(Particles.SMOKE, var3, var5, var7, 0.0, 0.0, 0.0);
            var0.addParticle(Particles.FLAME, var3, var5, var7, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.oSpin = this.spin;
            this.spin = (this.spin + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public void serverTick(WorldServer var0, BlockPosition var12) {
        if (!this.isNearPlayer(var0, var12) || !var0.isSpawnerBlockEnabled()) {
            return;
        }
        if (this.spawnDelay == -1) {
            this.delay(var0, var12);
        }
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
            return;
        }
        boolean var2 = false;
        RandomSource var3 = var0.getRandom();
        MobSpawnerData var4 = this.getOrCreateNextSpawnData(var0, var3, var12);
        for (int var5 = 0; var5 < this.spawnCount; ++var5) {
            try (ProblemReporter.j var6 = new ProblemReporter.j(this::toString, LOGGER);){
                Object var11;
                ValueInput var7 = TagValueInput.create((ProblemReporter)var6, (HolderLookup.a)var0.registryAccess(), var4.getEntityToSpawn());
                Optional<EntityTypes<?>> var8 = EntityTypes.by(var7);
                if (var8.isEmpty()) {
                    this.delay(var0, var12);
                    return;
                }
                Vec3D var9 = var7.read("Pos", Vec3D.CODEC).orElseGet(() -> new Vec3D((double)var12.getX() + (var3.nextDouble() - var3.nextDouble()) * (double)this.spawnRange + 0.5, var12.getY() + var3.nextInt(3) - 1, (double)var12.getZ() + (var3.nextDouble() - var3.nextDouble()) * (double)this.spawnRange + 0.5));
                if (!var0.noCollision(var8.get().getSpawnAABB(var9.x, var9.y, var9.z))) continue;
                BlockPosition var10 = BlockPosition.containing(var9);
                if (var4.getCustomSpawnRules().isPresent()) {
                    if (!var8.get().getCategory().isFriendly() && var0.getDifficulty() == EnumDifficulty.PEACEFUL || !((MobSpawnerData.a)(var11 = var4.getCustomSpawnRules().get())).isValidPosition(var10, var0)) continue;
                } else if (!EntityPositionTypes.checkSpawnRules(var8.get(), var0, EntitySpawnReason.SPAWNER, var10, var0.getRandom())) continue;
                var11 = EntityTypes.loadEntityRecursive(var7, (World)var0, EntitySpawnReason.SPAWNER, var1 -> {
                    var1.snapTo(var0.x, var0.y, var0.z, var1.getYRot(), var1.getXRot());
                    return var1;
                });
                if (var11 == null) {
                    this.delay(var0, var12);
                    return;
                }
                int var122 = var0.getEntities(EntityTypeTest.forExactClass(var11.getClass()), new AxisAlignedBB(var12.getX(), var12.getY(), var12.getZ(), var12.getX() + 1, var12.getY() + 1, var12.getZ() + 1).inflate(this.spawnRange), IEntitySelector.NO_SPECTATORS).size();
                if (var122 >= this.maxNearbyEntities) {
                    this.delay(var0, var12);
                    return;
                }
                ((Entity)var11).snapTo(((Entity)var11).getX(), ((Entity)var11).getY(), ((Entity)var11).getZ(), var3.nextFloat() * 360.0f, 0.0f);
                if (var11 instanceof EntityInsentient) {
                    boolean var14;
                    EntityInsentient var13 = (EntityInsentient)var11;
                    if (var4.getCustomSpawnRules().isEmpty() && !var13.checkSpawnRules(var0, EntitySpawnReason.SPAWNER) || !var13.checkSpawnObstruction(var0)) continue;
                    boolean bl = var14 = var4.getEntityToSpawn().size() == 1 && var4.getEntityToSpawn().getString("id").isPresent();
                    if (var14) {
                        ((EntityInsentient)var11).finalizeSpawn(var0, var0.getCurrentDifficultyAt(((Entity)var11).blockPosition()), EntitySpawnReason.SPAWNER, null);
                    }
                    var4.getEquipment().ifPresent(var13::equip);
                }
                if (!var0.tryAddFreshEntityWithPassengers((Entity)var11)) {
                    this.delay(var0, var12);
                    return;
                }
                var0.levelEvent(2004, var12, 0);
                var0.gameEvent((Entity)var11, GameEvent.ENTITY_PLACE, var10);
                if (var11 instanceof EntityInsentient) {
                    ((EntityInsentient)var11).spawnAnim();
                }
                var2 = true;
                continue;
            }
        }
        if (var2) {
            this.delay(var0, var12);
        }
    }

    private void delay(World var0, BlockPosition var1) {
        RandomSource var22 = var0.random;
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + var22.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.spawnPotentials.getRandom(var22).ifPresent(var2 -> this.setNextSpawnData(var0, var1, (MobSpawnerData)var2));
        this.broadcastEvent(var0, var1, 1);
    }

    public void load(@Nullable World var0, BlockPosition var1, ValueInput var22) {
        this.spawnDelay = var22.getShortOr("Delay", (short)20);
        var22.read(SPAWN_DATA_TAG, MobSpawnerData.CODEC).ifPresent(var2 -> this.setNextSpawnData(var0, var1, (MobSpawnerData)var2));
        this.spawnPotentials = var22.read("SpawnPotentials", MobSpawnerData.LIST_CODEC).orElseGet(() -> WeightedList.of(this.nextSpawnData != null ? this.nextSpawnData : new MobSpawnerData()));
        this.minSpawnDelay = var22.getIntOr("MinSpawnDelay", 200);
        this.maxSpawnDelay = var22.getIntOr("MaxSpawnDelay", 800);
        this.spawnCount = var22.getIntOr("SpawnCount", 4);
        this.maxNearbyEntities = var22.getIntOr("MaxNearbyEntities", 6);
        this.requiredPlayerRange = var22.getIntOr("RequiredPlayerRange", 16);
        this.spawnRange = var22.getIntOr("SpawnRange", 4);
        this.displayEntity = null;
    }

    public void save(ValueOutput var0) {
        var0.putShort("Delay", (short)this.spawnDelay);
        var0.putShort("MinSpawnDelay", (short)this.minSpawnDelay);
        var0.putShort("MaxSpawnDelay", (short)this.maxSpawnDelay);
        var0.putShort("SpawnCount", (short)this.spawnCount);
        var0.putShort("MaxNearbyEntities", (short)this.maxNearbyEntities);
        var0.putShort("RequiredPlayerRange", (short)this.requiredPlayerRange);
        var0.putShort("SpawnRange", (short)this.spawnRange);
        var0.storeNullable(SPAWN_DATA_TAG, MobSpawnerData.CODEC, this.nextSpawnData);
        var0.store("SpawnPotentials", MobSpawnerData.LIST_CODEC, this.spawnPotentials);
    }

    public @Nullable Entity getOrCreateDisplayEntity(World var0, BlockPosition var1) {
        if (this.displayEntity == null) {
            NBTTagCompound var2 = this.getOrCreateNextSpawnData(var0, var0.getRandom(), var1).getEntityToSpawn();
            if (var2.getString("id").isEmpty()) {
                return null;
            }
            this.displayEntity = EntityTypes.loadEntityRecursive(var2, var0, EntitySpawnReason.SPAWNER, EntityProcessor.NOP);
            if (var2.size() != 1 || this.displayEntity instanceof EntityInsentient) {
                // empty if block
            }
        }
        return this.displayEntity;
    }

    public boolean onEventTriggered(World var0, int var1) {
        if (var1 == 1) {
            if (var0.isClientSide()) {
                this.spawnDelay = this.minSpawnDelay;
            }
            return true;
        }
        return false;
    }

    protected void setNextSpawnData(@Nullable World var0, BlockPosition var1, MobSpawnerData var2) {
        this.nextSpawnData = var2;
    }

    private MobSpawnerData getOrCreateNextSpawnData(@Nullable World var0, RandomSource var1, BlockPosition var2) {
        if (this.nextSpawnData != null) {
            return this.nextSpawnData;
        }
        this.setNextSpawnData(var0, var2, this.spawnPotentials.getRandom(var1).orElseGet(MobSpawnerData::new));
        return this.nextSpawnData;
    }

    public abstract void broadcastEvent(World var1, BlockPosition var2, int var3);

    public double getSpin() {
        return this.spin;
    }

    public double getOSpin() {
        return this.oSpin;
    }
}

