/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class AbstractCauldronBlock
extends Block {
    protected static final int FLOOR_LEVEL = 4;
    private static final VoxelShape SHAPE_INSIDE = Block.column(12.0, 4.0, 16.0);
    protected static final VoxelShape SHAPE = SystemUtils.make(() -> {
        int var0 = 4;
        int var1 = 3;
        int var2 = 2;
        return VoxelShapes.join(VoxelShapes.block(), VoxelShapes.or(Block.column(16.0, 8.0, 0.0, 3.0), Block.column(8.0, 16.0, 0.0, 3.0), Block.column(12.0, 0.0, 3.0), SHAPE_INSIDE), OperatorBoolean.ONLY_FIRST);
    });
    protected final CauldronInteraction.a interactions;

    protected abstract MapCodec<? extends AbstractCauldronBlock> codec();

    public AbstractCauldronBlock(BlockBase.Info var0, CauldronInteraction.a var1) {
        super(var0);
        this.interactions = var1;
    }

    protected double getContentHeight(IBlockData var0) {
        return 0.0;
    }

    @Override
    protected EnumInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        CauldronInteraction var7 = this.interactions.map().get(var0.getItem());
        return var7.interact(var1, var2, var3, var4, var5, var0);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    protected VoxelShape getInteractionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return SHAPE_INSIDE;
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }

    public abstract boolean isFull(IBlockData var1);

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        BlockPosition var4 = PointedDripstoneBlock.findStalactiteTipAboveCauldron(var1, var2);
        if (var4 == null) {
            return;
        }
        FluidType var5 = PointedDripstoneBlock.getCauldronFillFluidType(var1, var4);
        if (var5 != FluidTypes.EMPTY && this.canReceiveStalactiteDrip(var5)) {
            this.receiveStalactiteDrip(var0, var1, var2, var5);
        }
    }

    protected boolean canReceiveStalactiteDrip(FluidType var0) {
        return false;
    }

    protected void receiveStalactiteDrip(IBlockData var0, World var1, BlockPosition var2, FluidType var3) {
    }
}

