/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.SharedConstants;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class Block
extends BlockBase
implements IMaterial {
    public static final MapCodec<Block> CODEC = Block.simpleCodec(Block::new);
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Holder.c<Block> builtInRegistryHolder = BuiltInRegistries.BLOCK.createIntrusiveHolder(this);
    public static final RegistryBlockID<IBlockData> BLOCK_STATE_REGISTRY = new RegistryBlockID();
    private static final LoadingCache<VoxelShape, Boolean> SHAPE_FULL_BLOCK_CACHE = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<VoxelShape, Boolean>(){

        public Boolean load(VoxelShape var0) {
            return !VoxelShapes.joinIsNotEmpty(VoxelShapes.block(), var0, OperatorBoolean.NOT_SAME);
        }

        public /* synthetic */ Object load(Object object) throws Exception {
            return this.load((VoxelShape)object);
        }
    });
    public static final int UPDATE_NEIGHBORS = 1;
    public static final int UPDATE_CLIENTS = 2;
    public static final int UPDATE_INVISIBLE = 4;
    public static final int UPDATE_IMMEDIATE = 8;
    public static final int UPDATE_KNOWN_SHAPE = 16;
    public static final int UPDATE_SUPPRESS_DROPS = 32;
    public static final int UPDATE_MOVE_BY_PISTON = 64;
    public static final int UPDATE_SKIP_SHAPE_UPDATE_ON_WIRE = 128;
    public static final int UPDATE_SKIP_BLOCK_ENTITY_SIDEEFFECTS = 256;
    public static final int UPDATE_SKIP_ON_PLACE = 512;
    @b
    public static final int UPDATE_NONE = 260;
    @b
    public static final int UPDATE_ALL = 3;
    @b
    public static final int UPDATE_ALL_IMMEDIATE = 11;
    @b
    public static final int UPDATE_SKIP_ALL_SIDEEFFECTS = 816;
    public static final float INDESTRUCTIBLE = -1.0f;
    public static final float INSTANT = 0.0f;
    public static final int UPDATE_LIMIT = 512;
    protected final BlockStateList<Block, IBlockData> stateDefinition;
    private IBlockData defaultBlockState;
    private @Nullable Item item;
    private static final int CACHE_SIZE = 256;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<a>> OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<a> var0 = new Object2ByteLinkedOpenHashMap<a>(256, 0.25f){

            protected void rehash(int var0) {
            }
        };
        var0.defaultReturnValue((byte)127);
        return var0;
    });

    @Override
    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    public static int getId(@Nullable IBlockData var0) {
        if (var0 == null) {
            return 0;
        }
        int var1 = BLOCK_STATE_REGISTRY.getId(var0);
        return var1 == -1 ? 0 : var1;
    }

    public static IBlockData stateById(int var0) {
        IBlockData var1 = BLOCK_STATE_REGISTRY.byId(var0);
        return var1 == null ? Blocks.AIR.defaultBlockState() : var1;
    }

    public static Block byItem(@Nullable Item var0) {
        if (var0 instanceof ItemBlock) {
            return ((ItemBlock)var0).getBlock();
        }
        return Blocks.AIR;
    }

    public static IBlockData pushEntitiesUp(IBlockData var0, IBlockData var1, GeneratorAccess var2, BlockPosition var3) {
        VoxelShape var4 = VoxelShapes.joinUnoptimized(var0.getCollisionShape(var2, var3), var1.getCollisionShape(var2, var3), OperatorBoolean.ONLY_SECOND).move(var3);
        if (var4.isEmpty()) {
            return var1;
        }
        List<Entity> var5 = var2.getEntities(null, var4.bounds());
        for (Entity var7 : var5) {
            double var8 = VoxelShapes.collide(EnumDirection.EnumAxis.Y, var7.getBoundingBox().move(0.0, 1.0, 0.0), List.of(var4), -1.0);
            var7.teleportRelative(0.0, 1.0 + var8, 0.0);
        }
        return var1;
    }

    public static VoxelShape box(double var0, double var2, double var4, double var6, double var8, double var10) {
        return VoxelShapes.box(var0 / 16.0, var2 / 16.0, var4 / 16.0, var6 / 16.0, var8 / 16.0, var10 / 16.0);
    }

    public static VoxelShape[] boxes(int var0, IntFunction<VoxelShape> var1) {
        return (VoxelShape[])IntStream.rangeClosed(0, var0).mapToObj(var1).toArray(VoxelShape[]::new);
    }

    public static VoxelShape cube(double var0) {
        return Block.cube(var0, var0, var0);
    }

    public static VoxelShape cube(double var0, double var2, double var4) {
        double var6 = var2 / 2.0;
        return Block.column(var0, var4, 8.0 - var6, 8.0 + var6);
    }

    public static VoxelShape column(double var0, double var2, double var4) {
        return Block.column(var0, var0, var2, var4);
    }

    public static VoxelShape column(double var0, double var2, double var4, double var6) {
        double var8 = var0 / 2.0;
        double var10 = var2 / 2.0;
        return Block.box(8.0 - var8, var4, 8.0 - var10, 8.0 + var8, var6, 8.0 + var10);
    }

    public static VoxelShape boxZ(double var0, double var2, double var4) {
        return Block.boxZ(var0, var0, var2, var4);
    }

    public static VoxelShape boxZ(double var0, double var2, double var4, double var6) {
        double var8 = var2 / 2.0;
        return Block.boxZ(var0, 8.0 - var8, 8.0 + var8, var4, var6);
    }

    public static VoxelShape boxZ(double var0, double var2, double var4, double var6, double var8) {
        double var10 = var0 / 2.0;
        return Block.box(8.0 - var10, var2, var6, 8.0 + var10, var4, var8);
    }

    public static IBlockData updateFromNeighbourShapes(IBlockData var0, GeneratorAccess var1, BlockPosition var2) {
        IBlockData var3 = var0;
        BlockPosition.MutableBlockPosition var4 = new BlockPosition.MutableBlockPosition();
        for (EnumDirection var8 : UPDATE_SHAPE_ORDER) {
            var4.setWithOffset((BaseBlockPosition)var2, var8);
            var3 = var3.updateShape(var1, var1, var2, var8, var4, var1.getBlockState(var4), var1.getRandom());
        }
        return var3;
    }

    public static void updateOrDestroy(IBlockData var0, IBlockData var1, GeneratorAccess var2, BlockPosition var3, @b int var4) {
        Block.updateOrDestroy(var0, var1, var2, var3, var4, 512);
    }

    public static void updateOrDestroy(IBlockData var0, IBlockData var1, GeneratorAccess var2, BlockPosition var3, @b int var4, int var5) {
        if (var1 != var0) {
            if (var1.isAir()) {
                if (!var2.isClientSide()) {
                    var2.destroyBlock(var3, (var4 & 0x20) == 0, null, var5);
                }
            } else {
                var2.setBlock(var3, var1, var4 & 0xFFFFFFDF, var5);
            }
        }
    }

    public Block(BlockBase.Info var0) {
        super(var0);
        String var2;
        BlockStateList.a<Block, IBlockData> var1 = new BlockStateList.a<Block, IBlockData>(this);
        this.createBlockStateDefinition(var1);
        this.stateDefinition = var1.create(Block::defaultBlockState, IBlockData::new);
        this.registerDefaultState(this.stateDefinition.any());
        if (SharedConstants.IS_RUNNING_IN_IDE && !(var2 = this.getClass().getSimpleName()).endsWith("Block")) {
            LOGGER.error("Block classes should end with Block and {} doesn't.", (Object)var2);
        }
    }

    public static boolean isExceptionForConnection(IBlockData var0) {
        return var0.getBlock() instanceof BlockLeaves || var0.is(Blocks.BARRIER) || var0.is(Blocks.CARVED_PUMPKIN) || var0.is(Blocks.JACK_O_LANTERN) || var0.is(Blocks.MELON) || var0.is(Blocks.PUMPKIN) || var0.is(TagsBlock.SHULKER_BOXES);
    }

    protected static boolean dropFromBlockInteractLootTable(WorldServer var0, ResourceKey<LootTable> var1, IBlockData var2, @Nullable TileEntity var3, @Nullable ItemStack var42, @Nullable Entity var5, BiConsumer<WorldServer, ItemStack> var6) {
        return Block.dropFromLootTable(var0, var1, var4 -> var4.withParameter(LootContextParameters.BLOCK_STATE, var2).withOptionalParameter(LootContextParameters.BLOCK_ENTITY, var3).withOptionalParameter(LootContextParameters.INTERACTING_ENTITY, var5).withOptionalParameter(LootContextParameters.TOOL, var42).create(LootContextParameterSets.BLOCK_INTERACT), var6);
    }

    protected static boolean dropFromLootTable(WorldServer var0, ResourceKey<LootTable> var1, Function<LootParams.a, LootParams> var22, BiConsumer<WorldServer, ItemStack> var3) {
        LootParams var5;
        LootTable var4 = var0.getServer().reloadableRegistries().getLootTable(var1);
        ObjectArrayList<ItemStack> var6 = var4.getRandomItems(var5 = var22.apply(new LootParams.a(var0)));
        if (!var6.isEmpty()) {
            var6.forEach(var2 -> var3.accept(var0, (ItemStack)var2));
            return true;
        }
        return false;
    }

    public static boolean shouldRenderFace(IBlockData var0, IBlockData var1, EnumDirection var2) {
        VoxelShape var3 = var1.getFaceOcclusionShape(var2.getOpposite());
        if (var3 == VoxelShapes.block()) {
            return false;
        }
        if (var0.skipRendering(var1, var2)) {
            return false;
        }
        if (var3 == VoxelShapes.empty()) {
            return true;
        }
        VoxelShape var4 = var0.getFaceOcclusionShape(var2);
        if (var4 == VoxelShapes.empty()) {
            return true;
        }
        a var5 = new a(var4, var3);
        Object2ByteLinkedOpenHashMap<a> var6 = OCCLUSION_CACHE.get();
        byte var7 = var6.getAndMoveToFirst((Object)var5);
        if (var7 != 127) {
            return var7 != 0;
        }
        boolean var8 = VoxelShapes.joinIsNotEmpty(var4, var3, OperatorBoolean.ONLY_FIRST);
        if (var6.size() == 256) {
            var6.removeLastByte();
        }
        var6.putAndMoveToFirst((Object)var5, (byte)(var8 ? 1 : 0));
        return var8;
    }

    public static boolean canSupportRigidBlock(IBlockAccess var0, BlockPosition var1) {
        return var0.getBlockState(var1).isFaceSturdy(var0, var1, EnumDirection.UP, EnumBlockSupport.RIGID);
    }

    public static boolean canSupportCenter(IWorldReader var0, BlockPosition var1, EnumDirection var2) {
        IBlockData var3 = var0.getBlockState(var1);
        if (var2 == EnumDirection.DOWN && var3.is(TagsBlock.UNSTABLE_BOTTOM_CENTER)) {
            return false;
        }
        return var3.isFaceSturdy(var0, var1, var2, EnumBlockSupport.CENTER);
    }

    public static boolean isFaceFull(VoxelShape var0, EnumDirection var1) {
        VoxelShape var2 = var0.getFaceShape(var1);
        return Block.isShapeFullBlock(var2);
    }

    public static boolean isShapeFullBlock(VoxelShape var0) {
        return (Boolean)SHAPE_FULL_BLOCK_CACHE.getUnchecked((Object)var0);
    }

    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
    }

    public void destroy(GeneratorAccess var0, BlockPosition var1, IBlockData var2) {
    }

    public static List<ItemStack> getDrops(IBlockData var0, WorldServer var1, BlockPosition var2, @Nullable TileEntity var3) {
        LootParams.a var4 = new LootParams.a(var1).withParameter(LootContextParameters.ORIGIN, Vec3D.atCenterOf(var2)).withParameter(LootContextParameters.TOOL, ItemStack.EMPTY).withOptionalParameter(LootContextParameters.BLOCK_ENTITY, var3);
        return var0.getDrops(var4);
    }

    public static List<ItemStack> getDrops(IBlockData var0, WorldServer var1, BlockPosition var2, @Nullable TileEntity var3, @Nullable Entity var4, ItemStack var5) {
        LootParams.a var6 = new LootParams.a(var1).withParameter(LootContextParameters.ORIGIN, Vec3D.atCenterOf(var2)).withParameter(LootContextParameters.TOOL, var5).withOptionalParameter(LootContextParameters.THIS_ENTITY, var4).withOptionalParameter(LootContextParameters.BLOCK_ENTITY, var3);
        return var0.getDrops(var6);
    }

    public static void dropResources(IBlockData var0, World var1, BlockPosition var22) {
        if (var1 instanceof WorldServer) {
            Block.getDrops(var0, (WorldServer)var1, var22, null).forEach(var2 -> Block.popResource(var1, var22, var2));
            var0.spawnAfterBreak((WorldServer)var1, var22, ItemStack.EMPTY, true);
        }
    }

    public static void dropResources(IBlockData var0, GeneratorAccess var1, BlockPosition var22, @Nullable TileEntity var3) {
        if (var1 instanceof WorldServer) {
            Block.getDrops(var0, (WorldServer)var1, var22, var3).forEach(var2 -> Block.popResource((World)((WorldServer)var1), var22, var2));
            var0.spawnAfterBreak((WorldServer)var1, var22, ItemStack.EMPTY, true);
        }
    }

    public static void dropResources(IBlockData var0, World var1, BlockPosition var22, @Nullable TileEntity var3, @Nullable Entity var4, ItemStack var5) {
        if (var1 instanceof WorldServer) {
            Block.getDrops(var0, (WorldServer)var1, var22, var3, var4, var5).forEach(var2 -> Block.popResource(var1, var22, var2));
            var0.spawnAfterBreak((WorldServer)var1, var22, var5, true);
        }
    }

    public static void popResource(World var0, BlockPosition var1, ItemStack var2) {
        double var3 = (double)EntityTypes.ITEM.getHeight() / 2.0;
        double var5 = (double)var1.getX() + 0.5 + MathHelper.nextDouble(var0.random, -0.25, 0.25);
        double var7 = (double)var1.getY() + 0.5 + MathHelper.nextDouble(var0.random, -0.25, 0.25) - var3;
        double var9 = (double)var1.getZ() + 0.5 + MathHelper.nextDouble(var0.random, -0.25, 0.25);
        Block.popResource(var0, () -> new EntityItem(var0, var5, var7, var9, var2), var2);
    }

    public static void popResourceFromFace(World var0, BlockPosition var1, EnumDirection var2, ItemStack var3) {
        int var4 = var2.getStepX();
        int var5 = var2.getStepY();
        int var6 = var2.getStepZ();
        double var7 = (double)EntityTypes.ITEM.getWidth() / 2.0;
        double var9 = (double)EntityTypes.ITEM.getHeight() / 2.0;
        double var11 = (double)var1.getX() + 0.5 + (var4 == 0 ? MathHelper.nextDouble(var0.random, -0.25, 0.25) : (double)var4 * (0.5 + var7));
        double var13 = (double)var1.getY() + 0.5 + (var5 == 0 ? MathHelper.nextDouble(var0.random, -0.25, 0.25) : (double)var5 * (0.5 + var9)) - var9;
        double var15 = (double)var1.getZ() + 0.5 + (var6 == 0 ? MathHelper.nextDouble(var0.random, -0.25, 0.25) : (double)var6 * (0.5 + var7));
        double var17 = var4 == 0 ? MathHelper.nextDouble(var0.random, -0.1, 0.1) : (double)var4 * 0.1;
        double var19 = var5 == 0 ? MathHelper.nextDouble(var0.random, 0.0, 0.1) : (double)var5 * 0.1 + 0.1;
        double var21 = var6 == 0 ? MathHelper.nextDouble(var0.random, -0.1, 0.1) : (double)var6 * 0.1;
        Block.popResource(var0, () -> new EntityItem(var0, var11, var13, var15, var3, var17, var19, var21), var3);
    }

    private static void popResource(World var0, Supplier<EntityItem> var1, ItemStack var2) {
        block3: {
            block2: {
                if (!(var0 instanceof WorldServer)) break block2;
                WorldServer var3 = (WorldServer)var0;
                if (!var2.isEmpty() && var3.getGameRules().get(GameRules.BLOCK_DROPS).booleanValue()) break block3;
            }
            return;
        }
        EntityItem var4 = var1.get();
        var4.setDefaultPickUpDelay();
        var0.addFreshEntity(var4);
    }

    public void popExperience(WorldServer var0, BlockPosition var1, int var2) {
        if (var0.getGameRules().get(GameRules.BLOCK_DROPS).booleanValue()) {
            EntityExperienceOrb.award(var0, Vec3D.atCenterOf(var1), var2);
        }
    }

    public float getExplosionResistance() {
        return this.explosionResistance;
    }

    public void wasExploded(WorldServer var0, BlockPosition var1, Explosion var2) {
    }

    public void stepOn(World var0, BlockPosition var1, IBlockData var2, Entity var3) {
    }

    public @Nullable IBlockData getStateForPlacement(BlockActionContext var0) {
        return this.defaultBlockState();
    }

    public void playerDestroy(World var0, EntityHuman var1, BlockPosition var2, IBlockData var3, @Nullable TileEntity var4, ItemStack var5) {
        var1.awardStat(StatisticList.BLOCK_MINED.get(this));
        var1.causeFoodExhaustion(0.005f);
        Block.dropResources(var3, var0, var2, var4, var1, var5);
    }

    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, @Nullable EntityLiving var3, ItemStack var4) {
    }

    public boolean isPossibleToRespawnInThis(IBlockData var0) {
        return !var0.isSolid() && !var0.liquid();
    }

    public IChatMutableComponent getName() {
        return IChatBaseComponent.translatable(this.getDescriptionId());
    }

    public void fallOn(World var0, IBlockData var1, BlockPosition var2, Entity var3, double var4) {
        var3.causeFallDamage(var4, 1.0f, var3.damageSources().fall());
    }

    public void updateEntityMovementAfterFallOn(IBlockAccess var0, Entity var1) {
        var1.setDeltaMovement(var1.getDeltaMovement().multiply(1.0, 0.0, 1.0));
    }

    public float getFriction() {
        return this.friction;
    }

    public float getSpeedFactor() {
        return this.speedFactor;
    }

    public float getJumpFactor() {
        return this.jumpFactor;
    }

    protected void spawnDestroyParticles(World var0, EntityHuman var1, BlockPosition var2, IBlockData var3) {
        var0.levelEvent(var1, 2001, var2, Block.getId(var3));
    }

    public IBlockData playerWillDestroy(World var0, BlockPosition var1, IBlockData var2, EntityHuman var3) {
        this.spawnDestroyParticles(var0, var3, var1, var2);
        if (var2.is(TagsBlock.GUARDED_BY_PIGLINS) && var0 instanceof WorldServer) {
            WorldServer var4 = (WorldServer)var0;
            PiglinAI.angerNearbyPiglins(var4, var3, false);
        }
        var0.gameEvent(GameEvent.BLOCK_DESTROY, var1, GameEvent.a.of(var3, var2));
        return var2;
    }

    public void handlePrecipitation(IBlockData var0, World var1, BlockPosition var2, BiomeBase.Precipitation var3) {
    }

    public boolean dropFromExplosion(Explosion var0) {
        return true;
    }

    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
    }

    public BlockStateList<Block, IBlockData> getStateDefinition() {
        return this.stateDefinition;
    }

    protected final void registerDefaultState(IBlockData var0) {
        this.defaultBlockState = var0;
    }

    public final IBlockData defaultBlockState() {
        return this.defaultBlockState;
    }

    public final IBlockData withPropertiesOf(IBlockData var0) {
        IBlockData var1 = this.defaultBlockState();
        for (IBlockState<?> var3 : var0.getBlock().getStateDefinition().getProperties()) {
            if (!var1.hasProperty(var3)) continue;
            var1 = Block.copyProperty(var0, var1, var3);
        }
        return var1;
    }

    private static <T extends Comparable<T>> IBlockData copyProperty(IBlockData var0, IBlockData var1, IBlockState<T> var2) {
        return (IBlockData)var1.setValue(var2, var0.getValue(var2));
    }

    @Override
    public Item asItem() {
        if (this.item == null) {
            this.item = Item.byBlock(this);
        }
        return this.item;
    }

    public boolean hasDynamicShape() {
        return this.dynamicShape;
    }

    public String toString() {
        return "Block{" + BuiltInRegistries.BLOCK.wrapAsHolder(this).getRegisteredName() + "}";
    }

    @Override
    protected Block asBlock() {
        return this;
    }

    protected Function<IBlockData, VoxelShape> getShapeForEachState(Function<IBlockData, VoxelShape> var0) {
        return arg_0 -> ((ImmutableMap)((ImmutableMap)this.stateDefinition.getPossibleStates().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), var0)))).get(arg_0);
    }

    protected Function<IBlockData, VoxelShape> getShapeForEachState(Function<IBlockData, VoxelShape> var02, IBlockState<?> ... var1) {
        Map<IBlockState, Object> var22 = Arrays.stream(var1).collect(Collectors.toMap(var0 -> var0, var0 -> var0.getPossibleValues().getFirst()));
        ImmutableMap var3 = (ImmutableMap)this.stateDefinition.getPossibleStates().stream().filter(var12 -> var22.entrySet().stream().allMatch(var1 -> var12.getValue((IBlockState)var1.getKey()) == var1.getValue())).collect(ImmutableMap.toImmutableMap(Function.identity(), var02));
        return var2 -> {
            for (Map.Entry var4 : var22.entrySet()) {
                var2 = Block.setValueHelper(var2, (IBlockState)var4.getKey(), var4.getValue());
            }
            return (VoxelShape)var3.get(var2);
        };
    }

    private static <S extends IBlockDataHolder<?, S>, T extends Comparable<T>> S setValueHelper(S var0, IBlockState<T> var1, Object var2) {
        return (S)((IBlockDataHolder)var0.setValue(var1, (Comparable)((Comparable)var2)));
    }

    @Deprecated
    public Holder.c<Block> builtInRegistryHolder() {
        return this.builtInRegistryHolder;
    }

    protected void tryDropExperience(WorldServer var0, BlockPosition var1, ItemStack var2, IntProvider var3) {
        int var4 = EnchantmentManager.processBlockExperience(var0, var2, var3.sample(var0.getRandom()));
        if (var4 > 0) {
            this.popExperience(var0, var1, var4);
        }
    }

    record a(VoxelShape first, VoxelShape second) {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object var0) {
            if (!(var0 instanceof a)) return false;
            a var1 = (a)var0;
            if (this.first != var1.first) return false;
            if (this.second != var1.second) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.first) * 31 + System.identityHashCode(this.second);
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.METHOD, ElementType.TYPE_USE})
    public static @interface b {
    }
}

