/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyAttachPosition;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import org.jspecify.annotations.Nullable;

public abstract class BlockAttachable
extends BlockFacingHorizontal {
    public static final BlockStateEnum<BlockPropertyAttachPosition> FACE = BlockProperties.ATTACH_FACE;

    protected BlockAttachable(BlockBase.Info var0) {
        super(var0);
    }

    protected abstract MapCodec<? extends BlockAttachable> codec();

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return BlockAttachable.canAttach(var1, var2, BlockAttachable.getConnectedDirection(var0).getOpposite());
    }

    public static boolean canAttach(IWorldReader var0, BlockPosition var1, EnumDirection var2) {
        BlockPosition var3 = var1.relative(var2);
        return var0.getBlockState(var3).isFaceSturdy(var0, var3, var2.getOpposite());
    }

    @Override
    public @Nullable IBlockData getStateForPlacement(BlockActionContext var0) {
        for (EnumDirection var4 : var0.getNearestLookingDirections()) {
            IBlockData var5 = var4.getAxis() == EnumDirection.EnumAxis.Y ? (IBlockData)((IBlockData)this.defaultBlockState().setValue(FACE, var4 == EnumDirection.UP ? BlockPropertyAttachPosition.CEILING : BlockPropertyAttachPosition.FLOOR)).setValue(FACING, var0.getHorizontalDirection()) : (IBlockData)((IBlockData)this.defaultBlockState().setValue(FACE, BlockPropertyAttachPosition.WALL)).setValue(FACING, var4.getOpposite());
            if (!var5.canSurvive(var0.getLevel(), var0.getClickedPos())) continue;
            return var5;
        }
        return null;
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (BlockAttachable.getConnectedDirection(var0).getOpposite() == var4 && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    protected static EnumDirection getConnectedDirection(IBlockData var0) {
        switch (var0.getValue(FACE)) {
            case CEILING: {
                return EnumDirection.DOWN;
            }
            case FLOOR: {
                return EnumDirection.UP;
            }
        }
        return (EnumDirection)var0.getValue(FACING);
    }
}

