/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBamboo;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyBambooSize;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockBambooSapling
extends Block
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockBambooSapling> CODEC = BlockBambooSapling.simpleCodec(BlockBambooSapling::new);
    private static final VoxelShape SHAPE = Block.column(8.0, 0.0, 12.0);

    public MapCodec<BlockBambooSapling> codec() {
        return CODEC;
    }

    public BlockBambooSapling(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE.move(var0.getOffset(var2));
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (var3.nextInt(3) == 0 && var1.isEmptyBlock(var2.above()) && var1.getRawBrightness(var2.above(), 0) >= 9) {
            this.growBamboo(var1, var2);
        }
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return var1.getBlockState(var2.below()).is(TagsBlock.BAMBOO_PLANTABLE_ON);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (!var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (var4 == EnumDirection.UP && var6.is(Blocks.BAMBOO)) {
            return Blocks.BAMBOO.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2, boolean var3) {
        return new ItemStack(Items.BAMBOO);
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return var0.getBlockState(var1.above()).isAir();
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        this.growBamboo(var0, var2);
    }

    protected void growBamboo(World var0, BlockPosition var1) {
        var0.setBlock(var1.above(), (IBlockData)Blocks.BAMBOO.defaultBlockState().setValue(BlockBamboo.LEAVES, BlockPropertyBambooSize.SMALL), 3);
    }
}

