/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAttachable;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyAttachPosition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.jspecify.annotations.Nullable;

public class BlockButtonAbstract
extends BlockAttachable {
    public static final MapCodec<BlockButtonAbstract> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(var0 -> var0.type), (App)Codec.intRange((int)1, (int)1024).fieldOf("ticks_to_stay_pressed").forGetter(var0 -> var0.ticksToStayPressed), BlockButtonAbstract.propertiesCodec()).apply((Applicative)var02, BlockButtonAbstract::new));
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    private final BlockSetType type;
    private final int ticksToStayPressed;
    private final Function<IBlockData, VoxelShape> shapes;

    public MapCodec<BlockButtonAbstract> codec() {
        return CODEC;
    }

    protected BlockButtonAbstract(BlockSetType var0, int var1, BlockBase.Info var2) {
        super(var2.sound(var0.soundType()));
        this.type = var0;
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(POWERED, false)).setValue(FACE, BlockPropertyAttachPosition.WALL));
        this.ticksToStayPressed = var1;
        this.shapes = this.makeShapes();
    }

    private Function<IBlockData, VoxelShape> makeShapes() {
        VoxelShape var0 = Block.cube(14.0);
        VoxelShape var1 = Block.cube(12.0);
        Map<BlockPropertyAttachPosition, Map<EnumDirection, VoxelShape>> var2 = VoxelShapes.rotateAttachFace(Block.boxZ(6.0, 4.0, 8.0, 16.0));
        return this.getShapeForEachState(var3 -> VoxelShapes.join((VoxelShape)((Map)var2.get(var3.getValue(FACE))).get(var3.getValue(FACING)), var3.getValue(POWERED) != false ? var0 : var1, OperatorBoolean.ONLY_FIRST));
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.shapes.apply(var0);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        if (var0.getValue(POWERED).booleanValue()) {
            return EnumInteractionResult.CONSUME;
        }
        this.press(var0, var1, var2, var3);
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    protected void onExplosionHit(IBlockData var0, WorldServer var1, BlockPosition var2, Explosion var3, BiConsumer<ItemStack, BlockPosition> var4) {
        if (var3.canTriggerBlocks() && !var0.getValue(POWERED).booleanValue()) {
            this.press(var0, var1, var2, null);
        }
        super.onExplosionHit(var0, var1, var2, var3, var4);
    }

    public void press(IBlockData var0, World var1, BlockPosition var2, @Nullable EntityHuman var3) {
        var1.setBlock(var2, (IBlockData)var0.setValue(POWERED, true), 3);
        this.updateNeighbours(var0, var1, var2);
        var1.scheduleTick(var2, this, this.ticksToStayPressed);
        this.playSound(var3, var1, var2, true);
        var1.gameEvent((Entity)var3, GameEvent.BLOCK_ACTIVATE, var2);
    }

    protected void playSound(@Nullable EntityHuman var0, GeneratorAccess var1, BlockPosition var2, boolean var3) {
        var1.playSound(var3 ? var0 : null, var2, this.getSound(var3), SoundCategory.BLOCKS);
    }

    protected SoundEffect getSound(boolean var0) {
        return var0 ? this.type.buttonClickOn() : this.type.buttonClickOff();
    }

    @Override
    protected void affectNeighborsAfterRemoval(IBlockData var0, WorldServer var1, BlockPosition var2, boolean var3) {
        if (!var3 && var0.getValue(POWERED).booleanValue()) {
            this.updateNeighbours(var0, var1, var2);
        }
    }

    @Override
    protected int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        return var0.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected int getDirectSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (var0.getValue(POWERED).booleanValue() && BlockButtonAbstract.getConnectedDirection(var0) == var3) {
            return 15;
        }
        return 0;
    }

    @Override
    protected boolean isSignalSource(IBlockData var0) {
        return true;
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!var0.getValue(POWERED).booleanValue()) {
            return;
        }
        this.checkPressed(var0, var1, var2);
    }

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3, InsideBlockEffectApplier var4, boolean var5) {
        if (var1.isClientSide() || !this.type.canButtonBeActivatedByArrows() || var0.getValue(POWERED).booleanValue()) {
            return;
        }
        this.checkPressed(var0, var1, var2);
    }

    protected void checkPressed(IBlockData var0, World var1, BlockPosition var2) {
        boolean var5;
        EntityArrow var3 = this.type.canButtonBeActivatedByArrows() ? (EntityArrow)var1.getEntitiesOfClass(EntityArrow.class, var0.getShape(var1, var2).bounds().move(var2)).stream().findFirst().orElse(null) : null;
        boolean var4 = var3 != null;
        if (var4 != (var5 = var0.getValue(POWERED).booleanValue())) {
            var1.setBlock(var2, (IBlockData)var0.setValue(POWERED, var4), 3);
            this.updateNeighbours(var0, var1, var2);
            this.playSound(null, var1, var2, var4);
            var1.gameEvent((Entity)var3, var4 ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE, var2);
        }
        if (var4) {
            var1.scheduleTick(new BlockPosition(var2), this, this.ticksToStayPressed);
        }
    }

    private void updateNeighbours(IBlockData var0, World var1, BlockPosition var2) {
        EnumDirection var3;
        Orientation var4 = ExperimentalRedstoneUtils.initialOrientation(var1, var3, (var3 = BlockButtonAbstract.getConnectedDirection(var0).getOpposite()).getAxis().isHorizontal() ? EnumDirection.UP : (EnumDirection)var0.getValue(FACING));
        var1.updateNeighborsAt(var2, this, var4);
        var1.updateNeighborsAt(var2.relative(var3), this, var4);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, POWERED, FACE);
    }
}

