/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.animal.feline.EntityCat;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChestAbstract;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.DoubleBlockFinder;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.jspecify.annotations.Nullable;

public class BlockChest
extends BlockChestAbstract<TileEntityChest>
implements IBlockWaterlogged {
    public static final MapCodec<BlockChest> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("open_sound").forGetter(BlockChest::getOpenChestSound), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("close_sound").forGetter(BlockChest::getCloseChestSound), BlockChest.propertiesCodec()).apply((Applicative)var02, (var0, var1, var2) -> new BlockChest(() -> TileEntityTypes.CHEST, (SoundEffect)var0, (SoundEffect)var1, (BlockBase.Info)var2)));
    public static final BlockStateEnum<EnumDirection> FACING = BlockFacingHorizontal.FACING;
    public static final BlockStateEnum<BlockPropertyChestType> TYPE = BlockProperties.CHEST_TYPE;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    public static final int EVENT_SET_OPEN_COUNT = 1;
    private static final VoxelShape SHAPE = Block.column(14.0, 0.0, 14.0);
    private static final Map<EnumDirection, VoxelShape> HALF_SHAPES = VoxelShapes.rotateHorizontal(Block.boxZ(14.0, 0.0, 14.0, 0.0, 15.0));
    private final SoundEffect openSound;
    private final SoundEffect closeSound;
    private static final DoubleBlockFinder.Combiner<TileEntityChest, Optional<IInventory>> CHEST_COMBINER = new DoubleBlockFinder.Combiner<TileEntityChest, Optional<IInventory>>(){

        @Override
        public Optional<IInventory> acceptDouble(TileEntityChest var0, TileEntityChest var1) {
            return Optional.of(new InventoryLargeChest(var0, var1));
        }

        @Override
        public Optional<IInventory> acceptSingle(TileEntityChest var0) {
            return Optional.of(var0);
        }

        @Override
        public Optional<IInventory> acceptNone() {
            return Optional.empty();
        }

        @Override
        public /* synthetic */ Object acceptNone() {
            return this.acceptNone();
        }
    };
    private static final DoubleBlockFinder.Combiner<TileEntityChest, Optional<ITileInventory>> MENU_PROVIDER_COMBINER = new DoubleBlockFinder.Combiner<TileEntityChest, Optional<ITileInventory>>(){

        @Override
        public Optional<ITileInventory> acceptDouble(final TileEntityChest var0, final TileEntityChest var1) {
            final InventoryLargeChest var2 = new InventoryLargeChest(var0, var1);
            return Optional.of(new ITileInventory(this){

                @Override
                public @Nullable Container createMenu(int var02, PlayerInventory var12, EntityHuman var22) {
                    if (var0.canOpen(var22) && var1.canOpen(var22)) {
                        var0.unpackLootTable(var12.player);
                        var1.unpackLootTable(var12.player);
                        return ContainerChest.sixRows(var02, var12, var2);
                    }
                    EnumDirection var3 = BlockChest.getConnectedDirection(var0.getBlockState());
                    Vec3D var4 = var0.getBlockPos().getCenter();
                    Vec3D var5 = var4.add((double)var3.getStepX() / 2.0, 0.0, (double)var3.getStepZ() / 2.0);
                    TileEntityContainer.sendChestLockedNotifications(var5, var22, this.getDisplayName());
                    return null;
                }

                @Override
                public IChatBaseComponent getDisplayName() {
                    if (var0.hasCustomName()) {
                        return var0.getDisplayName();
                    }
                    if (var1.hasCustomName()) {
                        return var1.getDisplayName();
                    }
                    return IChatBaseComponent.translatable("container.chestDouble");
                }
            });
        }

        @Override
        public Optional<ITileInventory> acceptSingle(TileEntityChest var0) {
            return Optional.of(var0);
        }

        @Override
        public Optional<ITileInventory> acceptNone() {
            return Optional.empty();
        }

        @Override
        public /* synthetic */ Object acceptNone() {
            return this.acceptNone();
        }
    };

    @Override
    public MapCodec<? extends BlockChest> codec() {
        return CODEC;
    }

    protected BlockChest(Supplier<TileEntityTypes<? extends TileEntityChest>> var0, SoundEffect var1, SoundEffect var2, BlockBase.Info var3) {
        super(var3, var0);
        this.openSound = var1;
        this.closeSound = var2;
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(TYPE, BlockPropertyChestType.SINGLE)).setValue(WATERLOGGED, false));
    }

    public static DoubleBlockFinder.BlockType getBlockType(IBlockData var0) {
        BlockPropertyChestType var1 = var0.getValue(TYPE);
        if (var1 == BlockPropertyChestType.SINGLE) {
            return DoubleBlockFinder.BlockType.SINGLE;
        }
        if (var1 == BlockPropertyChestType.RIGHT) {
            return DoubleBlockFinder.BlockType.FIRST;
        }
        return DoubleBlockFinder.BlockType.SECOND;
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        if (this.chestCanConnectTo(var6) && var4.getAxis().isHorizontal()) {
            BlockPropertyChestType var8 = var6.getValue(TYPE);
            if (var0.getValue(TYPE) == BlockPropertyChestType.SINGLE && var8 != BlockPropertyChestType.SINGLE && var0.getValue(FACING) == var6.getValue(FACING) && BlockChest.getConnectedDirection(var6) == var4.getOpposite()) {
                return (IBlockData)var0.setValue(TYPE, var8.getOpposite());
            }
        } else if (BlockChest.getConnectedDirection(var0) == var4) {
            return (IBlockData)var0.setValue(TYPE, BlockPropertyChestType.SINGLE);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    public boolean chestCanConnectTo(IBlockData var0) {
        return var0.is(this);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return switch (var0.getValue(TYPE)) {
            default -> throw new MatchException(null, null);
            case BlockPropertyChestType.SINGLE -> SHAPE;
            case BlockPropertyChestType.LEFT, BlockPropertyChestType.RIGHT -> HALF_SHAPES.get(BlockChest.getConnectedDirection(var0));
        };
    }

    public static EnumDirection getConnectedDirection(IBlockData var0) {
        EnumDirection var1 = var0.getValue(FACING);
        return var0.getValue(TYPE) == BlockPropertyChestType.LEFT ? var1.getClockWise() : var1.getCounterClockWise();
    }

    public static BlockPosition getConnectedBlockPos(BlockPosition var0, IBlockData var1) {
        EnumDirection var2 = BlockChest.getConnectedDirection(var1);
        return var0.relative(var2);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        EnumDirection var6;
        BlockPropertyChestType var1 = BlockPropertyChestType.SINGLE;
        EnumDirection var2 = var0.getHorizontalDirection().getOpposite();
        Fluid var3 = var0.getLevel().getFluidState(var0.getClickedPos());
        boolean var4 = var0.isSecondaryUseActive();
        EnumDirection var5 = var0.getClickedFace();
        if (var5.getAxis().isHorizontal() && var4 && (var6 = this.candidatePartnerFacing(var0.getLevel(), var0.getClickedPos(), var5.getOpposite())) != null && var6.getAxis() != var5.getAxis()) {
            var2 = var6;
            BlockPropertyChestType blockPropertyChestType = var1 = var2.getCounterClockWise() == var5.getOpposite() ? BlockPropertyChestType.RIGHT : BlockPropertyChestType.LEFT;
        }
        if (var1 == BlockPropertyChestType.SINGLE && !var4) {
            var1 = this.getChestType(var0.getLevel(), var0.getClickedPos(), var2);
        }
        return (IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, var2)).setValue(TYPE, var1)).setValue(WATERLOGGED, var3.getType() == FluidTypes.WATER);
    }

    protected BlockPropertyChestType getChestType(World var0, BlockPosition var1, EnumDirection var2) {
        if (var2 == this.candidatePartnerFacing(var0, var1, var2.getClockWise())) {
            return BlockPropertyChestType.LEFT;
        }
        if (var2 == this.candidatePartnerFacing(var0, var1, var2.getCounterClockWise())) {
            return BlockPropertyChestType.RIGHT;
        }
        return BlockPropertyChestType.SINGLE;
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    private @Nullable EnumDirection candidatePartnerFacing(World var0, BlockPosition var1, EnumDirection var2) {
        IBlockData var3 = var0.getBlockState(var1.relative(var2));
        return this.chestCanConnectTo(var3) && var3.getValue(TYPE) == BlockPropertyChestType.SINGLE ? var3.getValue(FACING) : null;
    }

    @Override
    protected void affectNeighborsAfterRemoval(IBlockData var0, WorldServer var1, BlockPosition var2, boolean var3) {
        InventoryUtils.updateNeighboursAfterDestroy(var0, var1, var2);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        if (var1 instanceof WorldServer) {
            WorldServer var5 = (WorldServer)var1;
            ITileInventory var6 = this.getMenuProvider(var0, var1, var2);
            if (var6 != null) {
                var3.openMenu(var6);
                var3.awardStat(this.getOpenChestStat());
                PiglinAI.angerNearbyPiglins(var5, var3, true);
            }
        }
        return EnumInteractionResult.SUCCESS;
    }

    protected Statistic<MinecraftKey> getOpenChestStat() {
        return StatisticList.CUSTOM.get(StatisticList.OPEN_CHEST);
    }

    public TileEntityTypes<? extends TileEntityChest> blockEntityType() {
        return (TileEntityTypes)this.blockEntityType.get();
    }

    public static @Nullable IInventory getContainer(BlockChest var0, IBlockData var1, World var2, BlockPosition var3, boolean var4) {
        return var0.combine(var1, var2, var3, var4).apply(CHEST_COMBINER).orElse(null);
    }

    @Override
    public DoubleBlockFinder.Result<? extends TileEntityChest> combine(IBlockData var02, World var12, BlockPosition var2, boolean var3) {
        BiPredicate<GeneratorAccess, BlockPosition> var4 = var3 ? (var0, var1) -> false : BlockChest::isChestBlockedAt;
        return DoubleBlockFinder.combineWithNeigbour((TileEntityTypes)this.blockEntityType.get(), BlockChest::getBlockType, BlockChest::getConnectedDirection, FACING, var02, var12, var2, var4);
    }

    @Override
    protected @Nullable ITileInventory getMenuProvider(IBlockData var0, World var1, BlockPosition var2) {
        return this.combine(var0, var1, var2, false).apply(MENU_PROVIDER_COMBINER).orElse(null);
    }

    public static DoubleBlockFinder.Combiner<TileEntityChest, Float2FloatFunction> opennessCombiner(final LidBlockEntity var0) {
        return new DoubleBlockFinder.Combiner<TileEntityChest, Float2FloatFunction>(){

            @Override
            public Float2FloatFunction acceptDouble(TileEntityChest var02, TileEntityChest var1) {
                return var2 -> Math.max(var02.getOpenNess(var2), var1.getOpenNess(var2));
            }

            @Override
            public Float2FloatFunction acceptSingle(TileEntityChest var02) {
                return var02::getOpenNess;
            }

            @Override
            public Float2FloatFunction acceptNone() {
                return var0::getOpenNess;
            }

            @Override
            public /* synthetic */ Object acceptNone() {
                return this.acceptNone();
            }
        };
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityChest(var0, var1);
    }

    @Override
    public <T extends TileEntity> @Nullable BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return var0.isClientSide() ? BlockChest.createTickerHelper(var2, this.blockEntityType(), TileEntityChest::lidAnimateTick) : null;
    }

    public static boolean isChestBlockedAt(GeneratorAccess var0, BlockPosition var1) {
        return BlockChest.isBlockedChestByBlock(var0, var1) || BlockChest.isCatSittingOnChest(var0, var1);
    }

    private static boolean isBlockedChestByBlock(IBlockAccess var0, BlockPosition var1) {
        BlockPosition var2 = var1.above();
        return var0.getBlockState(var2).isRedstoneConductor(var0, var2);
    }

    private static boolean isCatSittingOnChest(GeneratorAccess var0, BlockPosition var1) {
        List<EntityCat> var2 = var0.getEntitiesOfClass(EntityCat.class, new AxisAlignedBB(var1.getX(), var1.getY() + 1, var1.getZ(), var1.getX() + 1, var1.getY() + 2, var1.getZ() + 1));
        if (!var2.isEmpty()) {
            for (EntityCat var4 : var2) {
                if (!var4.isInSittingPose()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2, EnumDirection var3) {
        return Container.getRedstoneSignalFromContainer(BlockChest.getContainer(this, var0, var1, var2, false));
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, TYPE, WATERLOGGED);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        TileEntity var4 = var1.getBlockEntity(var2);
        if (var4 instanceof TileEntityChest) {
            ((TileEntityChest)var4).recheckOpen();
        }
    }

    public SoundEffect getOpenChestSound() {
        return this.openSound;
    }

    public SoundEffect getCloseChestSound() {
        return this.closeSound;
    }
}

