/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.OptionalInt;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class BlockLeaves
extends Block
implements IBlockWaterlogged {
    public static final int DECAY_DISTANCE = 7;
    public static final BlockStateInteger DISTANCE = BlockProperties.DISTANCE;
    public static final BlockStateBoolean PERSISTENT = BlockProperties.PERSISTENT;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    protected final float leafParticleChance;
    private static final int TICK_DELAY = 1;
    private static boolean cutoutLeaves = true;

    public abstract MapCodec<? extends BlockLeaves> codec();

    public BlockLeaves(float var0, BlockBase.Info var1) {
        super(var1);
        this.leafParticleChance = var0;
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(DISTANCE, 7)).setValue(PERSISTENT, false)).setValue(WATERLOGGED, false));
    }

    @Override
    protected boolean skipRendering(IBlockData var0, IBlockData var1, EnumDirection var2) {
        if (!cutoutLeaves && var1.getBlock() instanceof BlockLeaves) {
            return true;
        }
        return super.skipRendering(var0, var1, var2);
    }

    public static void setCutoutLeaves(boolean var0) {
        cutoutLeaves = var0;
    }

    @Override
    protected VoxelShape getBlockSupportShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return VoxelShapes.empty();
    }

    @Override
    protected boolean isRandomlyTicking(IBlockData var0) {
        return var0.getValue(DISTANCE) == 7 && var0.getValue(PERSISTENT) == false;
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (this.decaying(var0)) {
            BlockLeaves.dropResources(var0, var1, var2);
            var1.removeBlock(var2, false);
        }
    }

    protected boolean decaying(IBlockData var0) {
        return var0.getValue(PERSISTENT) == false && var0.getValue(DISTANCE) == 7;
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        var1.setBlock(var2, BlockLeaves.updateDistance(var0, var1, var2), 3);
    }

    @Override
    protected int getLightBlock(IBlockData var0) {
        return 1;
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        int var8;
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        if ((var8 = BlockLeaves.getDistanceAt(var6) + 1) != 1 || var0.getValue(DISTANCE) != var8) {
            var2.scheduleTick(var3, this, 1);
        }
        return var0;
    }

    private static IBlockData updateDistance(IBlockData var0, GeneratorAccess var1, BlockPosition var2) {
        int var3 = 7;
        BlockPosition.MutableBlockPosition var4 = new BlockPosition.MutableBlockPosition();
        for (EnumDirection var8 : EnumDirection.values()) {
            var4.setWithOffset((BaseBlockPosition)var2, var8);
            var3 = Math.min(var3, BlockLeaves.getDistanceAt(var1.getBlockState(var4)) + 1);
            if (var3 == 1) break;
        }
        return (IBlockData)var0.setValue(DISTANCE, var3);
    }

    private static int getDistanceAt(IBlockData var0) {
        return BlockLeaves.getOptionalDistanceAt(var0).orElse(7);
    }

    public static OptionalInt getOptionalDistanceAt(IBlockData var0) {
        if (var0.is(TagsBlock.LOGS)) {
            return OptionalInt.of(0);
        }
        if (var0.hasProperty(DISTANCE)) {
            return OptionalInt.of(var0.getValue(DISTANCE));
        }
        return OptionalInt.empty();
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        super.animateTick(var0, var1, var2, var3);
        BlockPosition var4 = var2.below();
        IBlockData var5 = var1.getBlockState(var4);
        BlockLeaves.makeDrippingWaterParticles(var1, var2, var3, var5, var4);
        this.makeFallingLeavesParticles(var1, var2, var3, var5, var4);
    }

    private static void makeDrippingWaterParticles(World var0, BlockPosition var1, RandomSource var2, IBlockData var3, BlockPosition var4) {
        if (!var0.isRainingAt(var1.above())) {
            return;
        }
        if (var2.nextInt(15) != 1) {
            return;
        }
        if (var3.canOcclude() && var3.isFaceSturdy(var0, var4, EnumDirection.UP)) {
            return;
        }
        ParticleUtils.spawnParticleBelow(var0, var1, var2, Particles.DRIPPING_WATER);
    }

    private void makeFallingLeavesParticles(World var0, BlockPosition var1, RandomSource var2, IBlockData var3, BlockPosition var4) {
        if (var2.nextFloat() >= this.leafParticleChance) {
            return;
        }
        if (BlockLeaves.isFaceFull(var3.getCollisionShape(var0, var4), EnumDirection.UP)) {
            return;
        }
        this.spawnFallingLeavesParticle(var0, var1, var2);
    }

    protected abstract void spawnFallingLeavesParticle(World var1, BlockPosition var2, RandomSource var3);

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(DISTANCE, PERSISTENT, WATERLOGGED);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        Fluid var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        IBlockData var2 = (IBlockData)((IBlockData)this.defaultBlockState().setValue(PERSISTENT, true)).setValue(WATERLOGGED, var1.getType() == FluidTypes.WATER);
        return BlockLeaves.updateDistance(var2, var0.getLevel(), var0.getClickedPos());
    }
}

