/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class BlockRespawnAnchor
extends Block {
    public static final MapCodec<BlockRespawnAnchor> CODEC = BlockRespawnAnchor.simpleCodec(BlockRespawnAnchor::new);
    public static final int MIN_CHARGES = 0;
    public static final int MAX_CHARGES = 4;
    public static final BlockStateInteger CHARGE = BlockProperties.RESPAWN_ANCHOR_CHARGES;
    private static final ImmutableList<BaseBlockPosition> RESPAWN_HORIZONTAL_OFFSETS = ImmutableList.of((Object)new BaseBlockPosition(0, 0, -1), (Object)new BaseBlockPosition(-1, 0, 0), (Object)new BaseBlockPosition(0, 0, 1), (Object)new BaseBlockPosition(1, 0, 0), (Object)new BaseBlockPosition(-1, 0, -1), (Object)new BaseBlockPosition(1, 0, -1), (Object)new BaseBlockPosition(-1, 0, 1), (Object)new BaseBlockPosition(1, 0, 1));
    private static final ImmutableList<BaseBlockPosition> RESPAWN_OFFSETS = new ImmutableList.Builder().addAll(RESPAWN_HORIZONTAL_OFFSETS).addAll(RESPAWN_HORIZONTAL_OFFSETS.stream().map(BaseBlockPosition::below).iterator()).addAll(RESPAWN_HORIZONTAL_OFFSETS.stream().map(BaseBlockPosition::above).iterator()).add((Object)new BaseBlockPosition(0, 1, 0)).build();

    public MapCodec<BlockRespawnAnchor> codec() {
        return CODEC;
    }

    public BlockRespawnAnchor(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(CHARGE, 0));
    }

    @Override
    protected EnumInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        if (BlockRespawnAnchor.isRespawnFuel(var0) && BlockRespawnAnchor.canBeCharged(var1)) {
            BlockRespawnAnchor.charge(var4, var2, var3, var1);
            var0.consume(1, var4);
            return EnumInteractionResult.SUCCESS;
        }
        if (var5 == EnumHand.MAIN_HAND && BlockRespawnAnchor.isRespawnFuel(var4.getItemInHand(EnumHand.OFF_HAND)) && BlockRespawnAnchor.canBeCharged(var1)) {
            return EnumInteractionResult.PASS;
        }
        return EnumInteractionResult.TRY_WITH_EMPTY_HAND;
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        if (var0.getValue(CHARGE) == 0) {
            return EnumInteractionResult.PASS;
        }
        if (!(var1 instanceof WorldServer)) {
            return EnumInteractionResult.CONSUME;
        }
        WorldServer var5 = (WorldServer)var1;
        if (BlockRespawnAnchor.canSetSpawn(var5, var2)) {
            if (var3 instanceof EntityPlayer) {
                EntityPlayer var6 = (EntityPlayer)var3;
                EntityPlayer.RespawnConfig var7 = var6.getRespawnConfig();
                EntityPlayer.RespawnConfig var8 = new EntityPlayer.RespawnConfig(WorldData.a.of(var5.dimension(), var2, 0.0f, 0.0f), false);
                if (var7 == null || !var7.isSamePosition(var8)) {
                    var6.setRespawnPosition(var8, true);
                    var5.playSound(null, (double)var2.getX() + 0.5, (double)var2.getY() + 0.5, (double)var2.getZ() + 0.5, SoundEffects.RESPAWN_ANCHOR_SET_SPAWN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return EnumInteractionResult.SUCCESS_SERVER;
                }
            }
            return EnumInteractionResult.CONSUME;
        }
        this.explode(var0, var5, var2);
        return EnumInteractionResult.SUCCESS_SERVER;
    }

    private static boolean isRespawnFuel(ItemStack var0) {
        return var0.is(Items.GLOWSTONE);
    }

    private static boolean canBeCharged(IBlockData var0) {
        return var0.getValue(CHARGE) < 4;
    }

    private static boolean isWaterThatWouldFlow(BlockPosition var0, World var1) {
        Fluid var2 = var1.getFluidState(var0);
        if (!var2.is(TagsFluid.WATER)) {
            return false;
        }
        if (var2.isSource()) {
            return true;
        }
        float var3 = var2.getAmount();
        if (var3 < 2.0f) {
            return false;
        }
        Fluid var4 = var1.getFluidState(var0.below());
        return !var4.is(TagsFluid.WATER);
    }

    private void explode(IBlockData var0, WorldServer var12, final BlockPosition var2) {
        var12.removeBlock(var2, false);
        boolean var3 = EnumDirection.EnumDirectionLimit.HORIZONTAL.stream().map(var2::relative).anyMatch(var1 -> BlockRespawnAnchor.isWaterThatWouldFlow(var1, var12));
        final boolean var4 = var3 || var12.getFluidState(var2.above()).is(TagsFluid.WATER);
        ExplosionDamageCalculator var5 = new ExplosionDamageCalculator(this){

            @Override
            public Optional<Float> getBlockExplosionResistance(Explosion var0, IBlockAccess var1, BlockPosition var22, IBlockData var3, Fluid var42) {
                if (var22.equals(var2) && var4) {
                    return Optional.of(Float.valueOf(Blocks.WATER.getExplosionResistance()));
                }
                return super.getBlockExplosionResistance(var0, var1, var22, var3, var42);
            }
        };
        Vec3D var6 = var2.getCenter();
        var12.explode(null, var12.damageSources().badRespawnPointExplosion(var6), var5, var6, 5.0f, true, World.a.BLOCK);
    }

    public static boolean canSetSpawn(WorldServer var0, BlockPosition var1) {
        return var0.environmentAttributes().getValue(EnvironmentAttributes.RESPAWN_ANCHOR_WORKS, var1);
    }

    public static void charge(@Nullable Entity var0, World var1, BlockPosition var2, IBlockData var3) {
        IBlockData var4 = (IBlockData)var3.setValue(CHARGE, var3.getValue(CHARGE) + 1);
        var1.setBlock(var2, var4, 3);
        var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var0, var4));
        var1.playSound(null, (double)var2.getX() + 0.5, (double)var2.getY() + 0.5, (double)var2.getZ() + 0.5, SoundEffects.RESPAWN_ANCHOR_CHARGE, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        if (var0.getValue(CHARGE) == 0) {
            return;
        }
        if (var3.nextInt(100) == 0) {
            var1.playLocalSound(var2, SoundEffects.RESPAWN_ANCHOR_AMBIENT, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
        double var4 = (double)var2.getX() + 0.5 + (0.5 - var3.nextDouble());
        double var6 = (double)var2.getY() + 1.0;
        double var8 = (double)var2.getZ() + 0.5 + (0.5 - var3.nextDouble());
        double var10 = (double)var3.nextFloat() * 0.04;
        var1.addParticle(Particles.REVERSE_PORTAL, var4, var6, var8, 0.0, var10, 0.0);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(CHARGE);
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    public static int getScaledChargeLevel(IBlockData var0, int var1) {
        return MathHelper.floor((float)(var0.getValue(CHARGE) - 0) / 4.0f * (float)var1);
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2, EnumDirection var3) {
        return BlockRespawnAnchor.getScaledChargeLevel(var0, 15);
    }

    public static Optional<Vec3D> findStandUpPosition(EntityTypes<?> var0, ICollisionAccess var1, BlockPosition var2) {
        Optional<Vec3D> var3 = BlockRespawnAnchor.findStandUpPosition(var0, var1, var2, true);
        if (var3.isPresent()) {
            return var3;
        }
        return BlockRespawnAnchor.findStandUpPosition(var0, var1, var2, false);
    }

    private static Optional<Vec3D> findStandUpPosition(EntityTypes<?> var0, ICollisionAccess var1, BlockPosition var2, boolean var3) {
        BlockPosition.MutableBlockPosition var4 = new BlockPosition.MutableBlockPosition();
        for (BaseBlockPosition var6 : RESPAWN_OFFSETS) {
            var4.set(var2).move(var6);
            Vec3D var7 = DismountUtil.findSafeDismountLocation(var0, var1, var4, var3);
            if (var7 == null) continue;
            return Optional.of(var7);
        }
        return Optional.empty();
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }
}

