/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.jspecify.annotations.Nullable;

public class BlockTrapdoor
extends BlockFacingHorizontal
implements IBlockWaterlogged {
    public static final MapCodec<BlockTrapdoor> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(var0 -> var0.type), BlockTrapdoor.propertiesCodec()).apply((Applicative)var02, BlockTrapdoor::new));
    public static final BlockStateBoolean OPEN = BlockProperties.OPEN;
    public static final BlockStateEnum<BlockPropertyHalf> HALF = BlockProperties.HALF;
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    private static final Map<EnumDirection, VoxelShape> SHAPES = VoxelShapes.rotateAll(Block.boxZ(16.0, 13.0, 16.0));
    private final BlockSetType type;

    public MapCodec<? extends BlockTrapdoor> codec() {
        return CODEC;
    }

    protected BlockTrapdoor(BlockSetType var0, BlockBase.Info var1) {
        super(var1.sound(var0.soundType()));
        this.type = var0;
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(OPEN, false)).setValue(HALF, BlockPropertyHalf.BOTTOM)).setValue(POWERED, false)).setValue(WATERLOGGED, false));
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPES.get(var0.getValue(OPEN) != false ? var0.getValue(FACING) : (var0.getValue(HALF) == BlockPropertyHalf.TOP ? EnumDirection.DOWN : EnumDirection.UP));
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        switch (var1) {
            case LAND: {
                return var0.getValue(OPEN);
            }
            case WATER: {
                return var0.getValue(WATERLOGGED);
            }
            case AIR: {
                return var0.getValue(OPEN);
            }
        }
        return false;
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        if (!this.type.canOpenByHand()) {
            return EnumInteractionResult.PASS;
        }
        this.toggle(var0, var1, var2, var3);
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    protected void onExplosionHit(IBlockData var0, WorldServer var1, BlockPosition var2, Explosion var3, BiConsumer<ItemStack, BlockPosition> var4) {
        if (var3.canTriggerBlocks() && this.type.canOpenByWindCharge() && !var0.getValue(POWERED).booleanValue()) {
            this.toggle(var0, var1, var2, null);
        }
        super.onExplosionHit(var0, var1, var2, var3, var4);
    }

    private void toggle(IBlockData var0, World var1, BlockPosition var2, @Nullable EntityHuman var3) {
        IBlockData var4 = (IBlockData)var0.cycle(OPEN);
        var1.setBlock(var2, var4, 2);
        if (var4.getValue(WATERLOGGED).booleanValue()) {
            var1.scheduleTick(var2, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        this.playSound(var3, var1, var2, var4.getValue(OPEN));
    }

    protected void playSound(@Nullable EntityHuman var0, World var1, BlockPosition var2, boolean var3) {
        var1.playSound((Entity)var0, var2, var3 ? this.type.trapdoorOpen() : this.type.trapdoorClose(), SoundCategory.BLOCKS, 1.0f, var1.getRandom().nextFloat() * 0.1f + 0.9f);
        var1.gameEvent((Entity)var0, var3 ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, var2);
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, @Nullable Orientation var4, boolean var5) {
        if (var1.isClientSide()) {
            return;
        }
        boolean var6 = var1.hasNeighborSignal(var2);
        if (var6 != var0.getValue(POWERED)) {
            if (var0.getValue(OPEN) != var6) {
                var0 = (IBlockData)var0.setValue(OPEN, var6);
                this.playSound(null, var1, var2, var6);
            }
            var1.setBlock(var2, (IBlockData)var0.setValue(POWERED, var6), 2);
            if (var0.getValue(WATERLOGGED).booleanValue()) {
                var1.scheduleTick(var2, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
            }
        }
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        IBlockData var1 = this.defaultBlockState();
        Fluid var2 = var0.getLevel().getFluidState(var0.getClickedPos());
        EnumDirection var3 = var0.getClickedFace();
        var1 = var0.replacingClickedOnBlock() || !var3.getAxis().isHorizontal() ? (IBlockData)((IBlockData)var1.setValue(FACING, var0.getHorizontalDirection().getOpposite())).setValue(HALF, var3 == EnumDirection.UP ? BlockPropertyHalf.BOTTOM : BlockPropertyHalf.TOP) : (IBlockData)((IBlockData)var1.setValue(FACING, var3)).setValue(HALF, var0.getClickLocation().y - (double)var0.getClickedPos().getY() > 0.5 ? BlockPropertyHalf.TOP : BlockPropertyHalf.BOTTOM);
        if (var0.getLevel().hasNeighborSignal(var0.getClickedPos())) {
            var1 = (IBlockData)((IBlockData)var1.setValue(OPEN, true)).setValue(POWERED, true);
        }
        return (IBlockData)var1.setValue(WATERLOGGED, var2.getType() == FluidTypes.WATER);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, OPEN, HALF, POWERED, WATERLOGGED);
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    protected BlockSetType getType() {
        return this.type;
    }
}

